/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles.gui;

import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.battles.attacks.BattleMessageBase;
import com.pixelmonmod.pixelmon.battles.attacks.MessageType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.battles.timerTasks.DamageTask;
import com.pixelmonmod.pixelmon.client.gui.battles.timerTasks.HPTask;
import com.pixelmonmod.pixelmon.client.gui.battles.timerTasks.HealTask;
import io.netty.buffer.ByteBuf;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class HPPacket
extends BattleMessageBase
implements IMessage {
    public int healthDifference;

    public HPPacket() {
    }

    public HPPacket(PixelmonWrapper user, int healthDifference) {
        this.pokemonUUID = user.getPokemonUUID();
        this.healthDifference = healthDifference;
    }

    public void fromBytes(ByteBuf buf) {
        this.pokemonUUID = new UUID(buf.readLong(), buf.readLong());
        this.healthDifference = buf.readInt();
        this.messageType = MessageType.HP;
    }

    public void toBytes(ByteBuf buf) {
        PixelmonMethods.toBytesUUID(buf, this.pokemonUUID);
        buf.writeInt(this.healthDifference);
    }

    @Override
    public void process() {
        HPTask task = this.healthDifference <= 0 ? new DamageTask(this, this.healthDifference, this.pokemonUUID) : new HealTask(this, this.healthDifference, this.pokemonUUID);
        new Timer().scheduleAtFixedRate((TimerTask)task, 0L, 10L);
    }

    public static class Handler
    implements IMessageHandler<HPPacket, IMessage> {
        public IMessage onMessage(HPPacket message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> ClientProxy.battleManager.addBattleMessage(message));
            return null;
        }
    }
}

