/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.battles;

import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.api.comm.ISyncHandler;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SetBattlingPokemon
implements IMessage {
    UUID[] pokemon;

    public SetBattlingPokemon() {
    }

    public SetBattlingPokemon(ArrayList<PixelmonWrapper> arrayList) {
        int numPokemon = arrayList.size();
        this.pokemon = new UUID[numPokemon];
        for (int i = 0; i < numPokemon; ++i) {
            PixelmonWrapper pw = arrayList.get(i);
            if (pw == null) continue;
            this.pokemon[i] = pw.getPokemonUUID();
        }
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeShort(this.pokemon.length);
        for (UUID uuid : this.pokemon) {
            PixelmonMethods.toBytesUUID(buffer, uuid);
        }
    }

    public void fromBytes(ByteBuf buffer) {
        int size = buffer.readShort();
        this.pokemon = new UUID[size];
        for (int i = 0; i < size; ++i) {
            this.pokemon[i] = new UUID(buffer.readLong(), buffer.readLong());
        }
    }

    public static class Handler
    implements ISyncHandler<SetBattlingPokemon> {
        @Override
        public void onSyncMessage(SetBattlingPokemon message, MessageContext ctx) {
            ClientProxy.battleManager.setTeamPokemon(message.pokemon);
        }
    }
}

