/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.badgecase;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.badgecase.BadgecaseUpdateClientPacket;
import com.pixelmonmod.pixelmon.items.ItemBadgecase;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class BadgecaseUpdateServerPacket
implements IMessage {
    private int slot;

    public BadgecaseUpdateServerPacket() {
    }

    public BadgecaseUpdateServerPacket(int slot, EntityPlayer player) {
        this.slot = slot;
    }

    public void fromBytes(ByteBuf buf) {
        this.slot = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.slot);
    }

    private static List<String> getBadgesAsList(String badgesUnformatted) {
        ArrayList<String> badges = new ArrayList<String>();
        if (!badgesUnformatted.contains(",")) {
            if (badgesUnformatted.isEmpty()) {
                return badges;
            }
            badges.add(badgesUnformatted);
            return badges;
        }
        for (String s : badgesUnformatted.split(",")) {
            badges.add(s);
        }
        return badges;
    }

    private static String formatBadges(List<String> badgeList) {
        if (badgeList.isEmpty()) {
            return "";
        }
        if (badgeList.size() == 1) {
            return badgeList.get(0);
        }
        String formatted = badgeList.get(0);
        for (int i = 1; i <= badgeList.size() - 1; ++i) {
            formatted = formatted + "," + badgeList.get(i);
        }
        return formatted;
    }

    private static List<NBTTagCompound> getBadgeCompoundsAsList(NBTTagCompound badgeCompound) {
        ArrayList<NBTTagCompound> badges = new ArrayList<NBTTagCompound>();
        if (badgeCompound.func_150296_c().isEmpty()) {
            return badges;
        }
        int biggestNum = -1;
        for (int i = 0; i < badgeCompound.func_150296_c().size(); ++i) {
            for (String s : badgeCompound.func_150296_c()) {
                try {
                    if (Integer.parseInt(s.substring(5)) != biggestNum + 1) continue;
                    badges.add(badgeCompound.func_74775_l(s));
                    ++biggestNum;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return badges;
    }

    private static NBTTagCompound formatBadgeCompounds(List<NBTTagCompound> badgeList) {
        if (badgeList.isEmpty()) {
            return new NBTTagCompound();
        }
        NBTTagCompound formatted = new NBTTagCompound();
        int i = 0;
        for (NBTTagCompound c : badgeList) {
            formatted.func_74782_a("badge" + i, (NBTBase)c);
            ++i;
        }
        return formatted;
    }

    public static class Handler
    implements IMessageHandler<BadgecaseUpdateServerPacket, IMessage> {
        public IMessage onMessage(BadgecaseUpdateServerPacket message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            ItemStack badgecase = player.func_184614_ca();
            if (player.field_71071_by.func_70447_i() == -1) {
                return null;
            }
            if (badgecase.func_77942_o() && badgecase.func_77973_b() instanceof ItemBadgecase && badgecase.func_77978_p().func_74764_b("Owners-UUID") && badgecase.func_77978_p().func_74764_b("Badges") && badgecase.func_77978_p().func_74764_b("BadgeCompounds") && badgecase.func_77978_p().func_74779_i("Owners-UUID").equalsIgnoreCase(player.func_110124_au().toString())) {
                NBTTagCompound tags = badgecase.func_77978_p();
                List badges = BadgecaseUpdateServerPacket.getBadgesAsList(tags.func_74779_i("Badges"));
                List badgeCompounds = BadgecaseUpdateServerPacket.getBadgeCompoundsAsList((NBTTagCompound)tags.func_74781_a("BadgeCompounds"));
                ItemStack stack = new ItemStack(Item.func_111206_d((String)("pixelmon:" + (String)badges.get(message.slot))));
                if (badgeCompounds.get(message.slot) != null && !((NBTTagCompound)badgeCompounds.get(message.slot)).func_82582_d()) {
                    stack.func_77982_d((NBTTagCompound)badgeCompounds.get(message.slot));
                }
                player.func_191521_c(stack);
                badges.remove(message.slot);
                badgeCompounds.remove(message.slot);
                NBTTagCompound nbtData = badgecase.func_77978_p();
                nbtData.func_74778_a("Badges", BadgecaseUpdateServerPacket.formatBadges(badges));
                nbtData.func_74782_a("BadgeCompounds", (NBTBase)BadgecaseUpdateServerPacket.formatBadgeCompounds(badgeCompounds));
                badgecase.func_77982_d(nbtData);
                BadgecaseUpdateClientPacket packet = new BadgecaseUpdateClientPacket(message.slot);
                Pixelmon.network.sendTo((IMessage)packet, player);
            }
            return null;
        }
    }
}

