/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers.badgecase;

import com.pixelmonmod.pixelmon.items.ItemBadgecase;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class BadgecasePacket
implements IMessage {
    private String uuid;
    private String badges;
    private boolean fromBadgecase;
    private String owner;
    private NBTTagCompound badgeCompounds;

    public BadgecasePacket() {
    }

    public BadgecasePacket(String uuid, String badges, NBTTagCompound badgeCompounds, boolean fromBadgecase, EntityPlayer player) {
        this.uuid = uuid;
        this.badges = badges;
        this.badgeCompounds = badgeCompounds;
        this.fromBadgecase = fromBadgecase;
        this.owner = player.func_70005_c_();
    }

    public void fromBytes(ByteBuf buf) {
        this.uuid = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.badges = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.badgeCompounds = ByteBufUtils.readTag((ByteBuf)buf);
        this.fromBadgecase = buf.readBoolean();
        this.owner = ByteBufUtils.readUTF8String((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.uuid);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.badges);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.badgeCompounds);
        buf.writeBoolean(this.fromBadgecase);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.owner);
    }

    public static class Handler
    implements IMessageHandler<BadgecasePacket, IMessage> {
        public IMessage onMessage(BadgecasePacket message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            ItemStack badgecase = null;
            if (!message.fromBadgecase) {
                for (ItemStack s : player.field_71071_by.field_70462_a) {
                    if (!(s.func_77973_b() instanceof ItemBadgecase) || !s.func_77942_o() || !player.func_110124_au().toString().equalsIgnoreCase(s.func_77978_p().func_74779_i("Owners-UUID"))) continue;
                    badgecase = s;
                    break;
                }
                if (badgecase == null) {
                    return null;
                }
            } else {
                badgecase = player.func_184614_ca();
            }
            if (badgecase.func_77973_b() instanceof ItemBadgecase) {
                NBTTagCompound nbtData = badgecase.func_77942_o() ? badgecase.func_77978_p() : new NBTTagCompound();
                nbtData.func_74778_a("Owners-Username", message.owner);
                nbtData.func_74778_a("Owners-UUID", message.uuid);
                nbtData.func_74778_a("Badges", message.badges);
                nbtData.func_74782_a("BadgeCompounds", (NBTBase)message.badgeCompounds);
                badgecase.func_77982_d(nbtData);
            }
            return null;
        }
    }
}

