/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.comm.ISyncHandler;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EnumSpecialTexture;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasData;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasStorage;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PlayerExtrasPacket
implements IMessage {
    private int slot;

    public PlayerExtrasPacket() {
    }

    private PlayerExtrasPacket(int slot) {
        this.slot = slot;
    }

    public static PlayerExtrasPacket getSetTexturePacket(int slot) {
        return new PlayerExtrasPacket(slot);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.slot);
    }

    public void fromBytes(ByteBuf buf) {
        this.slot = buf.readByte();
    }

    public static class Handler
    implements ISyncHandler<PlayerExtrasPacket> {
        @Override
        public void onSyncMessage(PlayerExtrasPacket message, MessageContext ctx) {
            PixelExtrasData data;
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            PlayerPartyStorage party = Pixelmon.storageManager.getParty(player);
            Pokemon pokemon = party.get(message.slot - 1);
            if (pokemon != null && (data = PixelExtrasStorage.getData(player.func_110124_au())).canSeeTexture(pokemon.getSpecies())) {
                pokemon.setSpecialTexture(EnumSpecialTexture.Online);
            }
        }
    }
}

