/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.comm.packetHandlers;

import com.pixelmonmod.pixelmon.api.comm.ISyncHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.EnumMovementType;
import com.pixelmonmod.pixelmon.entities.bikes.EntityBike;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity4Interactions;
import com.pixelmonmod.pixelmon.enums.EnumMovement;
import com.pixelmonmod.pixelmon.tools.IMovementHandler;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class Movement
implements IMessage {
    public static HashMap<EntityPlayerMP, EnumMovement[]> movementList = new HashMap();
    static IMovementHandler handler;
    EnumMovementType type;
    EnumMovement[] movement;

    public static void registerMovementHandler(IMovementHandler mHandler) {
        handler = mHandler;
    }

    public Movement() {
    }

    public Movement(EnumMovement[] movement, EnumMovementType type) {
        this.movement = movement;
        this.type = type;
    }

    public void fromBytes(ByteBuf buffer) {
        this.type = EnumMovementType.getFromOrdinal(buffer.readByte());
        int numMovements = buffer.readShort();
        this.movement = new EnumMovement[numMovements];
        for (int i = 0; i < numMovements; ++i) {
            this.movement[i] = EnumMovement.getMovement(buffer.readShort());
        }
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeByte(this.type.ordinal());
        buffer.writeShort(this.movement.length);
        for (EnumMovement aMovement : this.movement) {
            buffer.writeShort(aMovement.ordinal());
        }
    }

    public static class Handler
    implements ISyncHandler<Movement> {
        @Override
        public void onSyncMessage(Movement message, MessageContext ctx) {
            if (message.type == EnumMovementType.Riding) {
                EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                if (player.func_184187_bx() instanceof Entity4Interactions) {
                    Entity4Interactions mount = (Entity4Interactions)player.func_184187_bx();
                    for (EnumMovement movementType : message.movement) {
                        if (movementType == EnumMovement.Jump) {
                            ++mount.ridingPlayerVertical;
                            continue;
                        }
                        if (movementType != EnumMovement.Descend) continue;
                        --mount.ridingPlayerVertical;
                    }
                } else if (player.func_184187_bx() instanceof EntityBike && player.func_184187_bx().field_70122_E) {
                    for (EnumMovement movementType : message.movement) {
                        if (movementType != EnumMovement.Jump) continue;
                        ((EntityBike)player.func_184187_bx()).jumping = true;
                    }
                }
            } else if (handler != null) {
                handler.handleMovement(ctx.getServerHandler().field_147369_b, message.movement);
            }
        }
    }
}

