/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.render.layers;

import com.pixelmonmod.pixelmon.client.models.IPixelmonModel;
import com.pixelmonmod.pixelmon.client.models.PlayerExtraModels;
import com.pixelmonmod.pixelmon.storage.extras.PixelExtrasData;
import com.pixelmonmod.pixelmon.storage.extras.PlayerExtraDataStore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LayerHat
implements LayerRenderer<EntityPlayer> {
    private final ResourceLocation GOLD_MONOCLE_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/monocle_gold.png");
    private final ResourceLocation BLACK_MONOCLE_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/monocle_black.png");
    private final ResourceLocation TOP_HAT_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/tophat.png");
    private final ResourceLocation FEZ_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/fez.png");
    private final ResourceLocation FEDORA_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/fedora.png");
    private final ResourceLocation TRAINERHAT_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/trainerhat.png");
    private final ResourceLocation PIKAHOOD_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/pikahood.png");
    private final ResourceLocation EEVEEHOOD_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/eeveehood.png");
    private final ResourceLocation SCORHOOD_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/scorhood.png");
    private final ResourceLocation WIKI_TEXTURE = new ResourceLocation("pixelmon", "textures/playeritems/grad_cap.png");
    private ModelRenderer head;
    private final RenderPlayer renderer;
    private final ResourceLocation locationCapBG;
    private final DynamicTexture capBG;

    public LayerHat(RenderPlayer renderer) {
        this.renderer = renderer;
        this.capBG = new DynamicTexture(1, 1);
        this.capBG.func_110565_c()[0] = -1;
        this.capBG.func_110564_a();
        this.locationCapBG = Minecraft.func_71410_x().func_110434_K().func_110578_a("capBG", this.capBG);
    }

    public void doRenderLayer(EntityPlayer player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        PixelExtrasData extras = PlayerExtraDataStore.get(player);
        if (!extras.isReady() || player.func_82150_aj()) {
            return;
        }
        this.head = this.renderer.func_177087_b().field_78116_c;
        Minecraft.func_71410_x().field_71424_I.func_76320_a("layer_hat");
        if (extras.isEnabled(PixelExtrasData.Category.HAT) && extras.getHatType() != PixelExtrasData.HatType.NONE) {
            this.renderHat(player, extras, partialTicks);
        }
        if (extras.isEnabled(PixelExtrasData.Category.MONOCLE) && extras.getMonocleType() != PixelExtrasData.MonocleType.NONE) {
            this.renderMonocle(player, extras, partialTicks);
        }
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }

    public void renderHat(EntityPlayer player, PixelExtrasData data, float partialTicks) {
        ResourceLocation path;
        IModel hat;
        switch (data.getHatType()) {
            case TOP_HAT: {
                hat = PlayerExtraModels.TopHat.getModel();
                path = this.TOP_HAT_TEXTURE;
                break;
            }
            case FEZ: {
                hat = PlayerExtraModels.Fez.getModel();
                path = this.FEZ_TEXTURE;
                break;
            }
            case FEDORA: {
                hat = PlayerExtraModels.Fedora.getModel();
                path = this.FEDORA_TEXTURE;
                break;
            }
            case TRAINER_CAP: {
                hat = PlayerExtraModels.TrainerHat.getModel();
                path = this.TRAINERHAT_TEXTURE;
                break;
            }
            case PIKA_HOOD: {
                hat = PlayerExtraModels.PikaHood.getModel();
                path = this.PIKAHOOD_TEXTURE;
                break;
            }
            case EEVEE_HOOD: {
                hat = PlayerExtraModels.PikaHood.getModel();
                path = this.EEVEEHOOD_TEXTURE;
                break;
            }
            case SCOR_HOOD: {
                hat = PlayerExtraModels.PikaHood.getModel();
                path = this.SCORHOOD_TEXTURE;
                break;
            }
            case WIKI: {
                hat = PlayerExtraModels.Wiki.getModel();
                path = this.WIKI_TEXTURE;
                break;
            }
            default: {
                return;
            }
        }
        GlStateManager.func_179094_E();
        if (player.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)-0.73f, (float)0.0f);
        }
        this.head.func_78794_c(1.0f);
        GlStateManager.func_179109_b((float)this.head.field_82906_o, (float)this.head.field_82908_p, (float)this.head.field_82907_q);
        GlStateManager.func_179109_b((float)0.0f, (float)1.5f, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        if (data.getHatType() == PixelExtrasData.HatType.TRAINER_CAP) {
            if (data.getColours(PixelExtrasData.Category.HAT)[0] == -1) {
                this.renderer.func_110776_a(this.locationCapBG);
                int i = player.field_70173_aa / 25 + player.func_145782_y();
                int j = EnumDyeColor.values().length;
                int k = i % j;
                int l = (i + 1) % j;
                float f7 = ((float)(player.field_70173_aa % 25) + partialTicks) / 25.0f;
                float[] afloat1 = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.func_176764_b((int)k));
                float[] afloat2 = EntitySheep.func_175513_a((EnumDyeColor)EnumDyeColor.func_176764_b((int)l));
                float r = afloat1[0] * (1.0f - f7) + afloat2[0] * f7;
                float g = afloat1[1] * (1.0f - f7) + afloat2[1] * f7;
                float b = afloat1[2] * (1.0f - f7) + afloat2[2] * f7;
                this.capBG.func_110565_c()[0] = 0xFF000000 | (int)((double)(r * 255.0f) + 0.5) << 16 | (int)((double)(g * 255.0f) + 0.5) << 8 | (int)((double)(b * 255.0f) + 0.5);
                this.capBG.func_110564_a();
            } else {
                this.capBG.func_110565_c()[0] = 0xFF000000 | data.getColours(PixelExtrasData.Category.HAT)[0] << 16 | data.getColours(PixelExtrasData.Category.HAT)[1] << 8 | data.getColours(PixelExtrasData.Category.HAT)[2];
                this.capBG.func_110564_a();
            }
            ((IPixelmonModel)hat).renderAll();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
        Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(path);
        ((IPixelmonModel)hat).renderAll();
        GlStateManager.func_179121_F();
    }

    public void renderMonocle(EntityPlayer player, PixelExtrasData data, float partialTicks) {
        GlStateManager.func_179094_E();
        if (player.func_70093_af()) {
            GlStateManager.func_179109_b((float)0.0f, (float)-0.73f, (float)0.0f);
        }
        this.head.func_78794_c(1.0f);
        GlStateManager.func_179109_b((float)this.head.field_82906_o, (float)this.head.field_82908_p, (float)this.head.field_82907_q);
        GlStateManager.func_179109_b((float)0.0f, (float)1.5f, (float)0.0f);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179091_B();
        GlStateManager.func_179109_b((float)0.15f, (float)-1.45f, (float)-0.29f);
        GlStateManager.func_179139_a((double)0.3, (double)0.3, (double)0.3);
        ResourceLocation texture = data.getMonocleType() == PixelExtrasData.MonocleType.GOLD_MONOCLE ? this.GOLD_MONOCLE_TEXTURE : this.BLACK_MONOCLE_TEXTURE;
        Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(texture);
        ((IPixelmonModel)PlayerExtraModels.Monocle.getModel()).renderAll();
        GlStateManager.func_179121_F();
    }

    public boolean func_177142_b() {
        return false;
    }
}

