/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.pokemoneditor;

import com.pixelmonmod.pixelmon.api.exceptions.ShowdownImportException;
import com.pixelmonmod.pixelmon.api.pokemon.ImportExportConverter;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiButtonHoverDisable;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiDropDown;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiScreenDropDown;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.EnumTextureType;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.GuiImportExport;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.GuiPokemonEditorAdvanced;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.IImportableContainer;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity3HasStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.EnumSpecialTexture;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.enums.EnumGrowth;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.forms.IEnumForm;
import com.pixelmonmod.pixelmon.util.ITranslatable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;

public abstract class GuiIndividualEditorBase
extends GuiScreenDropDown
implements IImportableContainer {
    public Pokemon p;
    public String titleText;
    private GuiTextField tbName;
    private GuiTextField tbNickname;
    private GuiTextField tbLvl;
    private GuiTextField[] tbMoves = new GuiTextField[4];
    private String origName;
    private Attack[] attacks = new Attack[4];
    private static final int BUTTON_OKAY = 1;
    private static final int BUTTON_GENDER = 3;
    private static final int BUTTON_CHANGE = 4;
    private static final int BUTTON_ADVANCED = 6;
    private static final int BUTTON_DELETE = 14;
    private static final int BUTTON_IMPORT_EXPORT = 15;
    protected List<GuiTextField> textFields = new ArrayList<GuiTextField>();

    public GuiIndividualEditorBase(Pokemon p, String titleText) {
        this.p = p;
        this.origName = p.getSpecies().getLocalizedName();
        this.titleText = titleText;
    }

    @Override
    public void func_73866_w_() {
        int i;
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 155, this.field_146295_m / 2 + 90, 30, 20, I18n.func_135052_a((String)"gui.guiItemDrops.ok", (Object[])new Object[0])));
        ArrayList<EnumTextureType> shinyOptions = new ArrayList<EnumTextureType>(Arrays.asList(EnumTextureType.Normal, EnumTextureType.Shiny));
        EnumSpecies species = this.p.getSpecies();
        if (species.hasSpecialTexture() && species.getSpecialTexture() != EnumSpecialTexture.Online) {
            shinyOptions.add(EnumTextureType.Special);
        }
        EnumTextureType currentType = EnumTextureType.Normal;
        if (this.p.isShiny()) {
            currentType = EnumTextureType.Shiny;
        } else if (this.p.getSpecialTexture().id != 0) {
            currentType = EnumTextureType.Special;
        }
        this.addDropDown(new GuiDropDown<EnumTextureType>(shinyOptions, currentType, this.field_146294_l / 2 - 120, this.field_146295_m / 2 + 14, 80, 50).setOnSelected(this::setTextureType).setGetOptionString(EnumTextureType::getLocalizedName));
        int malePercent = this.p.getSpecies().getBaseStats().malePercent;
        if (malePercent > 0 && malePercent < 100) {
            this.field_146292_n.add(new GuiButtonHoverDisable(3, this.field_146294_l / 2 - 120, this.field_146295_m / 2 + 30, 80, 20, this.p.getGender() == Gender.Male ? I18n.func_135052_a((String)"gui.trainereditor.male", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.trainereditor.female", (Object[])new Object[0])));
        }
        this.addDropDown(new GuiDropDown<EnumGrowth>(EnumGrowth.orderedList, this.p.getGrowth(), this.field_146294_l / 2 - 120, this.field_146295_m / 2 + 28, 80, 100).setOnSelected(growth -> this.p.setGrowth((EnumGrowth)growth)).setGetOptionString(ITranslatable::getLocalizedName).setInactiveTop(this.field_146295_m / 2 + 54));
        GuiDropDown formGuiDropDown = this.addDropDown(new GuiDropDown<IEnumForm>(species.getPossibleForms(true), this.p.getFormEnum(), this.field_146294_l / 2 - 120, this.field_146295_m / 2 + 92 + Math.max(-16, Math.min(6, species.getPossibleForms(true).size()) - 1) * -10, 80, 80).setOnSelected(enumForm -> this.p.setForm((IEnumForm)enumForm)).setGetOptionString(ITranslatable::getLocalizedName).setInactiveTop(this.field_146295_m / 2 + 94));
        if (!Entity3HasStats.hasForms(this.p.getSpecies())) {
            formGuiDropDown.setVisible(false);
        }
        this.tbName = new GuiTextField(6, this.field_146297_k.field_71466_p, this.field_146294_l / 2 - 120, this.field_146295_m / 2 - 50, 90, 17);
        this.tbName.func_146180_a(this.p.getSpecies().getLocalizedName());
        this.field_146292_n.add(new GuiButton(4, this.field_146294_l / 2 - 20, this.field_146295_m / 2 - 52, 100, 20, I18n.func_135052_a((String)"gui.trainereditor.changepokemon", (Object[])new Object[0])));
        this.tbLvl = new GuiTextField(7, this.field_146297_k.field_71466_p, this.field_146294_l / 2 - 120, this.field_146295_m / 2 - 30, 60, 17);
        this.tbLvl.func_146180_a(this.p.getLevel() + "");
        this.tbNickname = new GuiTextField(8, this.field_146297_k.field_71466_p, this.field_146294_l / 2 - 120, this.field_146295_m / 2 - 10, 90, 17);
        this.tbNickname.func_146180_a(this.p.getNickname() == null ? "" : this.p.getNickname());
        for (i = 0; i < this.tbMoves.length; ++i) {
            this.tbMoves[i] = new GuiTextField(9 + i, this.field_146297_k.field_71466_p, this.field_146294_l / 2 + 60, this.field_146295_m / 2 + 20 * i, 120, 17);
        }
        for (i = 0; i < this.p.getMoveset().size(); ++i) {
            this.attacks[i] = this.p.getMoveset().get(i);
            this.tbMoves[i].func_146180_a(this.attacks[i].getMove().getLocalizedName());
        }
        this.field_146292_n.add(new GuiButton(6, this.field_146294_l / 2 + 105, this.field_146295_m / 2 - 110, 80, 20, I18n.func_135052_a((String)"gui.trainereditor.advanced", (Object[])new Object[0])));
        this.textFields.clear();
        this.textFields.addAll(Arrays.asList(this.tbName, this.tbLvl, this.tbNickname, this.tbMoves[0], this.tbMoves[1], this.tbMoves[2], this.tbMoves[3]));
        if (this.showDeleteButton()) {
            this.field_146292_n.add(new GuiButton(14, this.field_146294_l / 2 - 185, this.field_146295_m / 2 - 110, 90, 20, I18n.func_135052_a((String)"gui.trainereditor.deletepoke", (Object[])new Object[0])));
        }
        this.field_146292_n.add(new GuiButton(15, this.field_146294_l / 2 + 20, this.field_146295_m / 2 + 90, 100, 20, I18n.func_135052_a((String)"gui.pokemoneditor.importexport", (Object[])new Object[0])));
    }

    protected GuiTextField createExtraTextField(int id) {
        return new GuiTextField(id, this.field_146297_k.field_71466_p, this.field_146294_l / 2 - 120, this.field_146295_m / 2 + 72, 60, 17);
    }

    private void setTextureType(EnumTextureType textureType) {
        switch (textureType) {
            case Normal: {
                this.p.setShiny(false);
                this.p.setSpecialTexture(EnumSpecialTexture.fromIndex(0));
                break;
            }
            case Shiny: {
                this.p.setShiny(true);
                this.p.setSpecialTexture(EnumSpecialTexture.fromIndex(0));
                break;
            }
            case Special: {
                this.p.setShiny(false);
                this.p.setSpecialTexture(this.p.getSpecies().getSpecialTexture());
            }
        }
    }

    protected boolean showDeleteButton() {
        return true;
    }

    @Override
    protected void drawBackgroundUnderMenus(float f, int i, int j) {
        if (this.tbName == null) {
            this.func_73866_w_();
        }
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.cwPanel);
        GuiHelper.drawImageQuad(this.field_146294_l / 2 - 200, this.field_146295_m / 2 - 120, 400.0, 240.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        RenderHelper.func_74518_a();
        this.field_146297_k.field_71466_p.func_78276_b(this.titleText, this.field_146294_l / 2 - this.field_146297_k.field_71466_p.func_78256_a(this.titleText) / 2, this.field_146295_m / 2 - 90, 0);
        this.field_146297_k.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gui.trainereditor.name", (Object[])new Object[0]), this.field_146294_l / 2 - 180, this.field_146295_m / 2 - 45, 0);
        this.field_146297_k.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gui.trainereditor.lvl", (Object[])new Object[0]), this.field_146294_l / 2 - 180, this.field_146295_m / 2 - 25, 0);
        this.tbName.func_146194_f();
        this.tbLvl.func_146194_f();
        this.field_146297_k.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gui.trainereditor.nickname", (Object[])new Object[0]), this.field_146294_l / 2 - 180, this.field_146295_m / 2 - 5, 0);
        this.tbNickname.func_146194_f();
        this.field_146297_k.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gui.trainereditor.shiny", (Object[])new Object[0]), this.field_146294_l / 2 - 180, this.field_146295_m / 2 + 15, 0);
        this.field_146297_k.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gui.trainereditor.gender", (Object[])new Object[0]), this.field_146294_l / 2 - 180, this.field_146295_m / 2 + 35, 0);
        this.field_146297_k.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gui.trainereditor.growth", (Object[])new Object[0]), this.field_146294_l / 2 - 180, this.field_146295_m / 2 + 55, 0);
        if (this.p.getSpecies().getNumForms(true) > 0) {
            this.field_146297_k.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gui.trainereditor.form", (Object[])new Object[0]), this.field_146294_l / 2 - 180, this.field_146295_m / 2 + 95, 0);
        }
        GuiHelper.bindPokemonSprite(this.p, this.field_146297_k);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GuiHelper.drawImageQuad(this.field_146294_l / 2 - 157, this.field_146295_m / 2 - 73, 20.0, 20.0f, 0.0, 0.0, 1.0, 1.0, 1.0f);
        this.field_146297_k.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gui.screenpokechecker.moves", (Object[])new Object[0]), this.field_146294_l / 2 + 100, this.field_146295_m / 2 - 15, 0);
        for (GuiTextField tbMove : this.tbMoves) {
            tbMove.func_146194_f();
        }
    }

    protected void drawExtraText(GuiTextField textField, String langKey) {
        if (textField != null) {
            textField.func_146194_f();
            this.field_146297_k.field_71466_p.func_78276_b(I18n.func_135052_a((String)langKey, (Object[])new Object[0]), this.field_146294_l / 2 - 180, textField.field_146210_g + 3, 0);
        }
    }

    protected void func_73869_a(char key, int keyCode) throws IOException {
        this.tbLvl.func_146201_a(key, keyCode);
        try {
            int lvl = Integer.parseInt(this.tbLvl.func_146179_b());
            if (lvl > 0 && lvl <= PixelmonServerConfig.maxLevel) {
                this.p.setLevel(lvl);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        GuiHelper.textboxKeyTypedLimited(this.tbNickname, key, keyCode, 11);
        this.p.setNickname(this.tbNickname.func_146179_b());
        this.tbName.func_146201_a(key, keyCode);
        for (GuiTextField tbMove : this.tbMoves) {
            tbMove.func_146201_a(key, keyCode);
        }
        GuiHelper.switchFocus(keyCode, this.textFields);
        if (keyCode == 1 || keyCode == 28) {
            this.saveFields();
        }
    }

    @Override
    protected void mouseClickedUnderMenus(int x, int y, int button) throws IOException {
        this.tbLvl.func_146192_a(x, y, button);
        this.tbNickname.func_146192_a(x, y, button);
        this.tbName.func_146192_a(x, y, button);
        for (GuiTextField tbMove : this.tbMoves) {
            tbMove.func_146192_a(x, y, button);
        }
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146124_l) {
            if (button.field_146127_k == 1) {
                this.saveFields();
            } else if (button.field_146127_k == 3 && this.p.getSpecies().getBaseStats().malePercent > 0) {
                if (this.p.getGender() == Gender.Male) {
                    this.p.setGender(Gender.Female);
                } else {
                    this.p.setGender(Gender.Male);
                }
                button.field_146126_j = this.p.getGender() == Gender.Male ? I18n.func_135052_a((String)"gui.trainereditor.male", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.trainereditor.female", (Object[])new Object[0]);
            } else if (button.field_146127_k == 4) {
                Optional<EnumSpecies> pokemon = EnumSpecies.getFromName(this.tbName.func_146179_b());
                if (pokemon.isPresent()) {
                    this.origName = this.tbName.func_146179_b();
                    this.changePokemon(pokemon.get());
                } else {
                    this.tbName.func_146180_a(this.origName);
                }
            } else if (button.field_146127_k == 6) {
                if (this.checkFields()) {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiPokemonEditorAdvanced(this));
                }
            } else if (button.field_146127_k == 14) {
                this.deletePokemon();
            } else if (button.field_146127_k == 15 && this.checkFields()) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiImportExport(this, this.titleText));
            }
        }
    }

    protected abstract void changePokemon(EnumSpecies var1);

    protected abstract void deletePokemon();

    private void saveFields() {
        if (this.checkFields()) {
            this.saveAndClose();
        }
    }

    protected abstract void saveAndClose();

    protected boolean checkFields() {
        this.p.getMoveset().clear();
        int numMoves = 0;
        for (GuiTextField tbMove : this.tbMoves) {
            String moveText = tbMove.func_146179_b();
            if (moveText.isEmpty()) continue;
            if (Attack.hasAttack(moveText)) {
                this.p.getMoveset().set(this.getNextAvailablePosition(), new Attack(moveText));
                continue;
            }
            tbMove.func_146180_a("");
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if (this.p.getMoveset().get(i) == null) continue;
            ++numMoves;
        }
        return numMoves != 0;
    }

    public int getNextAvailablePosition() {
        int size = this.p.getMoveset().size();
        if (size == 4) {
            return -1;
        }
        return size;
    }

    public abstract List<Pokemon> getPokemonList();

    @Override
    public String getExportText() {
        return ImportExportConverter.getExportText(this.p);
    }

    @Override
    public String importText(String importText) {
        try {
            Pokemon importedPokemon = ImportExportConverter.importText(importText);
            if (importedPokemon != null) {
                importedPokemon.setUUID(this.p.getUUID());
                this.p = importedPokemon;
                return null;
            }
            return "Error";
        }
        catch (ShowdownImportException e) {
            return e.field.errorCode;
        }
    }

    @Override
    public GuiScreen getScreen() {
        return this;
    }
}

