/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.npcEditor;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.chooseMoveset.GuiMoveList;
import com.pixelmonmod.pixelmon.client.gui.chooseMoveset.IMoveClicked;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiScreenDropDown;
import com.pixelmonmod.pixelmon.client.gui.npc.GuiTutor;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.TextureEditorNPC;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.DeleteNPC;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.StoreTutorData;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class GuiTutorEditor
extends GuiScreenDropDown
implements IMoveClicked {
    NPCTutor tutor;
    ArrayList<ItemStack> cost;
    int listTop;
    int listLeft;
    int listHeight;
    int listWidth;
    GuiMoveList attackListGui;
    int selectedMove = -1;
    GuiTextField newMove;
    GuiTextField newItem;
    GuiTextField newItemAmount;
    GuiTextField newItemDamage;
    GuiButton addMove;
    GuiButton deleteMove;
    GuiButton addItem;
    GuiButton[] deleteCost = new GuiButton[4];
    GuiButton deleteTutor;
    private TextureEditorNPC textureEditor;

    public GuiTutorEditor(int tutorID) {
        Keyboard.enableRepeatEvents((boolean)true);
        Optional<NPCTutor> entityNPCOptional = EntityNPC.locateNPCClient((World)Minecraft.func_71410_x().field_71441_e, tutorID, NPCTutor.class);
        if (!entityNPCOptional.isPresent()) {
            GuiHelper.closeScreen();
            return;
        }
        this.tutor = entityNPCOptional.get();
        this.listHeight = 150;
        this.listWidth = 90;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.listTop = this.field_146295_m / 2 - 62;
        this.listLeft = this.field_146294_l / 2 - 68;
        this.attackListGui = new GuiMoveList(this, GuiTutor.attackList, this.listWidth, this.listHeight, this.listTop, this.listLeft, this.field_146297_k);
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 155, this.field_146295_m / 2 + 90, 50, 20, I18n.func_135052_a((String)"gui.guiItemDrops.ok", (Object[])new Object[0])));
        this.newMove = new GuiTextField(1, this.field_146297_k.field_71466_p, this.field_146294_l / 2 + 54, this.field_146295_m / 2 - 100, 90, 20);
        this.newItem = new GuiTextField(2, this.field_146297_k.field_71466_p, this.field_146294_l / 2 + 64, this.field_146295_m / 2 + 30, 70, 20);
        this.newItemAmount = new GuiTextField(3, this.field_146297_k.field_71466_p, this.field_146294_l / 2 + 64, this.field_146295_m / 2 + 50, 70, 20);
        this.newItemDamage = new GuiTextField(4, this.field_146297_k.field_71466_p, this.field_146294_l / 2 + 64, this.field_146295_m / 2 + 70, 70, 20);
        this.addMove = new GuiButton(2, this.field_146294_l / 2 + 69, this.field_146295_m / 2 - 80, 60, 20, I18n.func_135052_a((String)"gui.tutor.addmove", (Object[])new Object[0]));
        this.deleteMove = new GuiButton(3, this.field_146294_l / 2 + 64, this.field_146295_m / 2 - 45, 70, 20, I18n.func_135052_a((String)"gui.tutor.deletemove", (Object[])new Object[0]));
        this.addItem = new GuiButton(4, this.field_146294_l / 2 + 144, this.field_146295_m / 2 + 50, 60, 20, I18n.func_135052_a((String)"gui.tutor.addcost", (Object[])new Object[0]));
        if (this.selectedMove > -1) {
            this.field_146292_n.add(this.addItem);
            this.field_146292_n.add(this.deleteMove);
        }
        for (int i = 0; i < this.deleteCost.length; ++i) {
            this.deleteCost[i] = new GuiButton(5 + i, this.field_146294_l / 2 + 74 + 20 * i, this.field_146295_m / 2 + 8, 20, 20, "X");
        }
        this.deleteTutor = new GuiButton(9, this.field_146294_l / 2 - 193, this.field_146295_m / 2 - 100, 80, 20, I18n.func_135052_a((String)"gui.tutor.deletetutor", (Object[])new Object[0]));
        this.textureEditor = new TextureEditorNPC(this, this.tutor, this.field_146294_l / 2 - 203, this.field_146295_m / 2 + 55, 130, -28);
        this.field_146292_n.add(this.addMove);
        this.field_146292_n.add(this.deleteTutor);
    }

    @Override
    protected void drawBackgroundUnderMenus(float mFloat, int mouseX, int mouseY) {
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.cwPanel);
        GuiHelper.drawImageQuad(0.0, 0.0, this.field_146294_l, this.field_146295_m, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        RenderHelper.func_74518_a();
        String text = I18n.func_135052_a((String)"pixelmon.npc.tutorname", (Object[])new Object[0]);
        this.field_146297_k.field_71466_p.func_78276_b(text, this.field_146294_l / 2 - this.field_146289_q.func_78256_a(text) / 2, 10, 0);
        text = I18n.func_135052_a((String)"gui.choosemoveset.choosemove", (Object[])new Object[0]);
        this.field_146297_k.field_71466_p.func_78276_b(text, this.field_146294_l / 2 - 33 - this.field_146289_q.func_78256_a(text) / 2, this.field_146295_m / 2 - 92, 0);
        if (GuiTutor.attackList != null) {
            this.attackListGui.drawScreen(mouseX, mouseY, mFloat);
        }
        GuiHelper.drawEntity((EntityLivingBase)this.tutor, this.field_146294_l / 2 - 133, this.field_146295_m / 2 + 50, 50.0f, 0.0f, 0.0f);
        this.newMove.func_146194_f();
        if (this.selectedMove >= 0) {
            text = GuiTutor.attackList.get(this.selectedMove).getMove().getLocalizedName();
            this.field_146297_k.field_71466_p.func_78276_b(text, this.field_146294_l / 2 + 99 - this.field_146289_q.func_78256_a(text) / 2, this.field_146295_m / 2 - 20, 0);
            text = I18n.func_135052_a((String)"gui.choosemoveset.cost", (Object[])new Object[0]);
            this.field_146297_k.field_71466_p.func_78276_b(text, this.field_146294_l / 2 + 74 - this.field_146289_q.func_78256_a(text), this.field_146295_m / 2 - 5, 0);
            if (this.cost.size() < 4) {
                this.newItem.func_146194_f();
                this.newItemAmount.func_146194_f();
                this.newItemDamage.func_146194_f();
                text = I18n.func_135052_a((String)"gui.tutor.itemname", (Object[])new Object[0]);
                this.field_146297_k.field_71466_p.func_78276_b(text, this.field_146294_l / 2 + 59 - this.field_146289_q.func_78256_a(text), this.field_146295_m / 2 + 35, 0);
                text = I18n.func_135052_a((String)"gui.tutor.itemamount", (Object[])new Object[0]);
                this.field_146297_k.field_71466_p.func_78276_b(text, this.field_146294_l / 2 + 59 - this.field_146289_q.func_78256_a(text), this.field_146295_m / 2 + 55, 0);
                text = I18n.func_135052_a((String)"gui.tutor.itemdamage", (Object[])new Object[0]);
                this.field_146297_k.field_71466_p.func_78276_b(text, this.field_146294_l / 2 + 59 - this.field_146289_q.func_78256_a(text), this.field_146295_m / 2 + 75, 0);
            }
        }
        this.textureEditor.drawCustomTextBox();
        if (this.cost != null && !this.cost.isEmpty()) {
            int i = 0;
            for (ItemStack item : this.cost) {
                this.field_146296_j.func_180450_b(item, this.field_146294_l / 2 + 74 + i * 20, this.field_146295_m / 2 - 10);
                this.field_146296_j.func_180453_a(this.field_146297_k.field_71466_p, item, this.field_146294_l / 2 + 74 + i * 20, this.field_146295_m / 2 - 10, null);
                if (i < this.deleteCost.length && !this.field_146292_n.contains(this.deleteCost[i])) {
                    this.field_146292_n.add(this.deleteCost[i]);
                }
                ++i;
            }
        }
    }

    @Override
    protected void mouseClickedUnderMenus(int x, int y, int mouseButton) throws IOException {
        this.newMove.func_146192_a(x, y, mouseButton);
        this.newItem.func_146192_a(x, y, mouseButton);
        this.newItemAmount.func_146192_a(x, y, mouseButton);
        this.newItemDamage.func_146192_a(x, y, mouseButton);
        this.textureEditor.mouseClicked(x, y, mouseButton);
    }

    @Override
    public void elementClicked(List<Attack> list, int index) {
        if (GuiTutor.attackList != null && GuiTutor.costs != null && index < GuiTutor.attackList.size()) {
            this.selectedMove = index;
            this.cost = GuiTutor.costs.get(index);
            if (!this.field_146292_n.contains(this.deleteMove)) {
                this.field_146292_n.add(this.deleteMove);
            }
            if (!this.field_146292_n.contains(this.addItem) && this.cost.size() < 4) {
                this.field_146292_n.add(this.addItem);
            }
            for (GuiButton deleteCostButton : this.deleteCost) {
                this.field_146292_n.remove(deleteCostButton);
            }
        }
    }

    protected void func_73869_a(char key, int keyCode) {
        this.newMove.func_146201_a(key, keyCode);
        ArrayList<GuiTextField> textFields = new ArrayList<GuiTextField>();
        textFields.add(this.newMove);
        if (this.selectedMove >= 0 && this.cost.size() < 4) {
            this.newItem.func_146201_a(key, keyCode);
            this.newItemAmount.func_146201_a(key, keyCode);
            this.newItemDamage.func_146201_a(key, keyCode);
            textFields.addAll(Arrays.asList(this.newItem, this.newItemAmount, this.newItemDamage));
        }
        this.textureEditor.keyTyped(key, keyCode, textFields.toArray(new GuiTextField[textFields.size()]));
        if (keyCode == 1 || keyCode == 28) {
            this.saveFields();
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 1) {
            this.saveFields();
        } else if (button.field_146127_k == 2) {
            Attack newAttack = new Attack(this.newMove.func_146179_b());
            if (newAttack.getMove() != null && !GuiTutor.attackList.contains(newAttack)) {
                GuiTutor.attackList.add(newAttack);
                GuiTutor.costs.add(new ArrayList());
            }
        } else if (button.field_146127_k == 3) {
            if (this.selectedMove >= 0 && this.selectedMove < GuiTutor.attackList.size()) {
                GuiTutor.attackList.remove(this.selectedMove);
                GuiTutor.costs.remove(this.selectedMove);
                this.cost = null;
                this.selectedMove = -1;
                this.field_146292_n.remove(this.addItem);
                this.field_146292_n.remove(this.deleteMove);
                for (GuiButton deleteCostButton : this.deleteCost) {
                    this.field_146292_n.remove(deleteCostButton);
                }
            }
        } else if (button.field_146127_k == 4) {
            if (this.cost.size() < 4) {
                Item item = Item.func_111206_d((String)this.newItem.func_146179_b());
                if (item == null) {
                    item = PixelmonItems.getItemFromName(this.newItem.func_146179_b());
                }
                if (item != null) {
                    int amount = 1;
                    int damage = 0;
                    try {
                        amount = Math.max(amount, Integer.parseInt(this.newItemAmount.func_146179_b()));
                    }
                    catch (NumberFormatException deleteCostButton) {
                        // empty catch block
                    }
                    try {
                        damage = Math.max(damage, Integer.parseInt(this.newItemDamage.func_146179_b()));
                    }
                    catch (NumberFormatException deleteCostButton) {
                        // empty catch block
                    }
                    ItemStack newItem = new ItemStack(item, amount);
                    if (amount > newItem.func_77976_d()) {
                        newItem.func_190920_e(newItem.func_77976_d());
                    }
                    newItem.func_77964_b(damage);
                    this.cost.add(newItem);
                    if (this.cost.size() >= 4) {
                        this.field_146292_n.remove(this.addItem);
                    }
                }
            }
        } else if (button.field_146127_k >= 5 && button.field_146127_k <= 8) {
            int deleteButtonIndex = button.field_146127_k - 5;
            if (this.cost.size() > deleteButtonIndex) {
                this.cost.remove(deleteButtonIndex);
                for (GuiButton deleteCostButton : this.deleteCost) {
                    this.field_146292_n.remove(deleteCostButton);
                }
                if (!this.field_146292_n.contains(this.addItem)) {
                    this.field_146292_n.add(this.addItem);
                }
            }
        } else if (button.field_146127_k == 9) {
            Pixelmon.network.sendToServer((IMessage)new DeleteNPC(this.tutor.getId()));
            GuiHelper.closeScreen();
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private void saveFields() {
        if (!GuiTutor.attackList.isEmpty()) {
            if (this.tutor != null) {
                Pixelmon.network.sendToServer((IMessage)new StoreTutorData(this.tutor.getId()));
                this.textureEditor.saveCustomTexture();
            }
            GuiHelper.closeScreen();
        }
    }
}

