/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.npcEditor;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.api.trading.TradePair;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiScreenDropDown;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.TextureEditorNPC;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.DeleteNPC;
import com.pixelmonmod.pixelmon.comm.packetHandlers.npc.NPCServerPacket;
import com.pixelmonmod.pixelmon.entities.npcs.EntityNPC;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrader;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity1Base;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class GuiTradeEditor
extends GuiScreenDropDown {
    public int top;
    public int left;
    GuiTextField offerName;
    GuiTextField exchangeName;
    GuiTextField descriptionTextBox;
    NPCTrader trader;
    PokemonSpec offer;
    boolean offerChanged = false;
    PokemonSpec exchange;
    boolean exchangeChanged = false;
    String description;
    private TextureEditorNPC textureEditor;

    public GuiTradeEditor(int traderId) {
        Keyboard.enableRepeatEvents((boolean)true);
        this.xSize = 256;
        this.ySize = 226;
        Optional<NPCTrader> entityNPCOptional = EntityNPC.locateNPCClient((World)Minecraft.func_71410_x().field_71441_e, traderId, NPCTrader.class);
        if (!entityNPCOptional.isPresent()) {
            GuiHelper.closeScreen();
            return;
        }
        this.trader = entityNPCOptional.get();
        this.offer = ClientProxy.currentTradePair.offer;
        this.exchange = ClientProxy.currentTradePair.exchange;
        this.description = ClientProxy.currentTradePair.description;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.trader == null) {
            GuiHelper.closeScreen();
            return;
        }
        if (ClientProxy.currentTradePair == null) {
            ClientProxy.currentTradePair = new TradePair(new PokemonSpec("random"), new PokemonSpec("random"));
        }
        this.left = (this.field_146294_l - this.xSize) / 2;
        this.top = (this.field_146295_m - this.ySize) / 2;
        this.offerName = new GuiTextField(6, this.field_146297_k.field_71466_p, this.field_146294_l / 2 - 45, this.field_146295_m / 2 + 10, 90, 17);
        this.offerName.func_146203_f(150);
        this.offerName.func_146180_a(Entity1Base.getLocalizedName(this.offer.name));
        this.exchangeName = new GuiTextField(7, this.field_146297_k.field_71466_p, this.field_146294_l / 2 + 100, this.field_146295_m / 2 + 10, 90, 17);
        this.exchangeName.func_146203_f(150);
        this.exchangeName.func_146180_a(Entity1Base.getLocalizedName(this.exchange.name));
        this.descriptionTextBox = new GuiTextField(8, this.field_146297_k.field_71466_p, this.field_146294_l / 2 - 45, this.field_146295_m / 2 + 50, 235, 15);
        this.descriptionTextBox.func_146203_f(150);
        if (this.description != null) {
            this.descriptionTextBox.func_146180_a(this.description);
        }
        this.field_146292_n.add(new GuiButton(0, this.field_146294_l / 2 + 155, this.field_146295_m / 2 + 90, 30, 20, I18n.func_135052_a((String)"gui.guiItemDrops.ok", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 100, this.field_146295_m / 2 - 110, 80, 20, I18n.func_135052_a((String)"gui.tradereditor.delete", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(2, this.field_146294_l / 2 - 40, this.field_146295_m / 2 - 110, 80, 20, I18n.func_135052_a((String)"gui.tradereditor.random", (Object[])new Object[0])));
        this.field_146292_n.add(new GuiButton(3, this.field_146294_l / 2 + 58, this.field_146295_m / 2 + 9, 30, 20, "<->"));
        this.textureEditor = new TextureEditorNPC(this, this.trader, this.field_146294_l / 2 - 190, this.field_146295_m / 2 + 50, 130, -23);
    }

    @Override
    protected void drawBackgroundUnderMenus(float var1, int var2, int var3) {
        this.field_146297_k.field_71446_o.func_110577_a(GuiResources.cwPanel);
        GuiHelper.drawImageQuad(this.field_146294_l / 2 - 200, this.field_146295_m / 2 - 120, 400.0, 240.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
        RenderHelper.func_74518_a();
        GuiHelper.drawEntity((EntityLivingBase)this.trader, this.field_146294_l / 2 - 125, this.field_146295_m / 2 + 40, 50.0f, 0.0f, 0.0f);
        if (ClientProxy.currentTradePair.offer.shiny == Boolean.TRUE) {
            this.offerName.func_146193_g(0xFFFF33);
        } else {
            this.offerName.func_146193_g(0xFFFFFF);
        }
        this.offerName.func_146194_f();
        if (ClientProxy.currentTradePair.exchange.shiny == Boolean.TRUE) {
            this.exchangeName.func_146193_g(0xFFFF33);
        } else {
            this.exchangeName.func_146193_g(0xFFFFFF);
        }
        this.exchangeName.func_146194_f();
        this.descriptionTextBox.func_146194_f();
        this.field_146297_k.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gui.tradereditor.offer", (Object[])new Object[0]), this.left + 85, this.top + 110, 0);
        this.field_146297_k.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gui.tradereditor.exchange", (Object[])new Object[0]), this.left + 225, this.top + 110, 0);
        this.field_146297_k.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gui.tradereditor.description", (Object[])new Object[0]), this.left + 85, this.top + 150, 0);
        this.textureEditor.drawCustomTextBox();
    }

    protected void func_73869_a(char key, int keyCode) {
        ArrayList<GuiTextField> textFields = new ArrayList<GuiTextField>(4);
        String beforeText = this.offerName.func_146179_b();
        this.offerName.func_146201_a(key, keyCode);
        String afterText = this.offerName.func_146179_b();
        if (!beforeText.equals(afterText)) {
            this.offerChanged = true;
        }
        textFields.add(this.offerName);
        beforeText = this.exchangeName.func_146179_b();
        this.exchangeName.func_146201_a(key, keyCode);
        afterText = this.exchangeName.func_146179_b();
        if (!beforeText.equals(afterText)) {
            this.exchangeChanged = true;
        }
        textFields.add(this.exchangeName);
        this.descriptionTextBox.func_146201_a(key, keyCode);
        textFields.add(this.descriptionTextBox);
        this.textureEditor.keyTyped(key, keyCode, textFields.toArray(new GuiTextField[textFields.size()]));
        if (keyCode == 1 || keyCode == 28) {
            this.saveFields();
        }
    }

    @Override
    protected void mouseClickedUnderMenus(int x, int y, int mouseButton) throws IOException {
        this.offerName.func_146192_a(x, y, mouseButton);
        this.exchangeName.func_146192_a(x, y, mouseButton);
        this.descriptionTextBox.func_146192_a(x, y, mouseButton);
        this.textureEditor.mouseClicked(x, y, mouseButton);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146124_l) {
            if (button.field_146127_k == 0) {
                this.saveFields();
            } else if (button.field_146127_k == 1) {
                GuiHelper.closeScreen();
                Minecraft.func_71410_x().func_175607_a((Entity)Minecraft.func_71410_x().field_71439_g);
                Pixelmon.network.sendToServer((IMessage)new DeleteNPC(this.trader.getId()));
            } else if (button.field_146127_k == 2) {
                EnumSpecies[] list = EnumSpecies.values();
                String poke2 = list[RandomHelper.getRandomNumberBetween((int)0, (int)(list.length - 1))].name;
                String poke1 = list[RandomHelper.getRandomNumberBetween((int)0, (int)(list.length - 1))].name;
                if (poke2.equalsIgnoreCase(poke1)) {
                    poke2 = list[RandomHelper.getRandomNumberBetween((int)0, (int)(list.length - 1))].name;
                }
                this.offerName.func_146180_a(Entity1Base.getLocalizedName(poke1));
                this.exchangeName.func_146180_a(Entity1Base.getLocalizedName(poke2));
            } else if (button.field_146127_k == 3) {
                String text = this.offerName.func_146179_b();
                this.offerName.func_146180_a(this.exchangeName.func_146179_b());
                this.exchangeName.func_146180_a(text);
            }
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private void saveFields() {
        String offerText = this.offerName.func_146179_b();
        String exchangeText = this.exchangeName.func_146179_b();
        this.description = this.descriptionTextBox.func_146179_b();
        PokemonSpec offer = new PokemonSpec(offerText.split(" "));
        PokemonSpec exchange = new PokemonSpec(exchangeText.split(" "));
        if (exchange.name != null && offer.name != null) {
            this.setNewTradePokemon(this.offerChanged ? offer : this.offer, this.exchangeChanged ? exchange : this.exchange);
            this.exchangeChanged = false;
            this.offerChanged = false;
            GuiHelper.closeScreen();
            Minecraft.func_71410_x().func_175607_a((Entity)Minecraft.func_71410_x().field_71439_g);
        }
        this.textureEditor.saveCustomTexture();
    }

    private void setNewTradePokemon(PokemonSpec offer, PokemonSpec exchange) {
        ClientProxy.currentTradePair = new TradePair(offer, exchange, this.description);
        Pixelmon.network.sendToServer((IMessage)new NPCServerPacket(this.trader.getId(), offer, exchange, this.description));
    }
}

