/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.factory.config;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.battles.rules.clauses.tiers.RulesRegistry;
import com.pixelmonmod.pixelmon.client.gui.factory.config.ConfigurateNodeElement;
import com.pixelmonmod.pixelmon.client.gui.factory.config.SpecialReloadingNode;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import info.pixelmon.repack.ninja.leaping.configurate.commented.CommentedConfigurationNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.client.config.DummyConfigElement;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.IConfigElement;

public class PixelmonConfigGui
extends GuiConfig {
    public PixelmonConfigGui(GuiScreen parentScreen) {
        super(parentScreen, PixelmonConfigGui.getConfigElements(), "pixelmon", false, false, I18n.func_135052_a((String)"pixelmon.config.title", (Object[])new Object[0]));
    }

    private static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("General", "pixelmon.config.general", GeneralEntry.class));
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("Starter", "pixelmon.config.starter", StarterEntry.class));
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("Spawning", "pixelmon.config.spawning", SpawningEntry.class));
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("PokeLoot", "pixelmon.config.pokeloot", PokeLootEntry.class));
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("AFK Handler", "pixelmon.config.afkhandler", AFKEntry.class));
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("Graphics", "pixelmon.config.graphics", GraphicsEntry.class));
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("Breeding", "pixelmon.config.breeding", BreedingEntry.class));
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("Pixel Utilities", "pixelmon.config.pixelutilities", PixelUtilsEntry.class));
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("External Moves", "pixelmon.config.externalmoves", ExternalMovesEntry.class));
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("Pokerus", "pixelmon.config.pokerus", PokerusEntry.class));
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("Riding", "pixelmon.config.riding", RidingEntry.class));
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("World Gen", "pixelmon.config.worldgen", WorldGenEntry.class));
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("Ultra Space", "pixelmon.config.ultraspace", UltraSpaceEntry.class));
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("External Files", "pixelmon.config.externalfiles", ExternalFilesEntry.class));
        list.add((IConfigElement)new DummyConfigElement.DummyCategoryElement("Elevator", "pixelmon.config.elevator", ElevatorEntry.class));
        return list;
    }

    static void validate(List<IConfigElement> configElements) {
        for (IConfigElement element : configElements) {
            try {
                if (element.get() != null) continue;
                System.out.println(element.getName());
            }
            catch (Exception exception) {}
        }
    }

    public static class ElevatorEntry
    extends PixelmonCategoryEntry {
        public ElevatorEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
        }

        protected GuiScreen buildChildScreen() {
            ArrayList configElements = Lists.newArrayList();
            configElements.add(new ConfigurateNodeElement(PixelmonConfig.getConfig().getNode("Elevator").getNode("elevatorSearchRange"), 10).setBounds(1, 255).setSlider());
            return new GuiConfig((GuiScreen)this.owningScreen, (List)configElements, this.owningScreen.modID, "Elevator", this.configElement.requiresWorldRestart() || this.owningScreen.allRequireWorldRestart, this.configElement.requiresMcRestart() || this.owningScreen.allRequireMcRestart, I18n.func_135052_a((String)"pixelmon.config.elevator.tooltip", (Object[])new Object[0]));
        }
    }

    public static class StarterEntry
    extends PixelmonCategoryEntry {
        public StarterEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
        }

        protected GuiScreen buildChildScreen() {
            ArrayList configElements = Lists.newArrayList();
            CommentedConfigurationNode parentNode = PixelmonConfig.getConfig().getNode("Starters");
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("level"), 5).setBounds(1, 100).setSlider());
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("shiny"), false));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("useCustomStarters"), false));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("starterList"), Lists.newArrayList((Object[])new String[]{"Bulbasaur", "Squirtle", "Charmander", "Chikorita", "Totodile", "Cyndaquil", "Treecko", "Mudkip", "Torchic", "Turtwig", "Piplup", "Chimchar", "Snivy", "Oshawott", "Tepig", "Chespin", "Froakie", "Fennekin", "Rowlet", "Popplio", "Litten"})));
            return new GuiConfig((GuiScreen)this.owningScreen, (List)configElements, this.owningScreen.modID, "Starters", this.configElement.requiresWorldRestart() || this.owningScreen.allRequireWorldRestart, this.configElement.requiresMcRestart() || this.owningScreen.allRequireMcRestart, I18n.func_135052_a((String)"pixelmon.config.starter.tooltip", (Object[])new Object[0]));
        }
    }

    public static class ExternalFilesEntry
    extends PixelmonCategoryEntry {
        public ExternalFilesEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
        }

        protected GuiScreen buildChildScreen() {
            ArrayList configElements = Lists.newArrayList();
            CommentedConfigurationNode generalNode = PixelmonConfig.getConfig().getNode("General");
            CommentedConfigurationNode spawningNode = PixelmonConfig.getConfig().getNode("Spawning");
            configElements.add(new ConfigurateNodeElement(generalNode.getNode("useExternalJSONFilesDrops"), false).setRequiresRestart());
            configElements.add(new SpecialReloadingNode(generalNode.getNode("useExternalJSONFilesNPCs"), false).setRequiresRestart());
            configElements.add(new SpecialReloadingNode(generalNode.getNode("useExternalJSONFilesRules"), false).setReloadFunction(o -> RulesRegistry.registerRules()));
            configElements.add(new SpecialReloadingNode(generalNode.getNode("useExternalJSONFilesSpawning"), false).setReloadFunction(o -> PixelmonSpawning.totalReload()));
            configElements.add(new ConfigurateNodeElement(generalNode.getNode("useExternalJSONFilesStructures"), false).setRequiresRestart());
            configElements.add(new ConfigurateNodeElement(generalNode.getNode("useExternalJSONFilesStats"), false).setRequiresRestart());
            configElements.add(new SpecialReloadingNode(generalNode.getNode("useExternalJSONFilesMoves"), false).setReloadFunction(o -> AttackBase.loadAllAttacks()));
            configElements.add(new SpecialReloadingNode(spawningNode.getNode("spawnSetFolder"), "default").setReloadFunction(o -> PixelmonSpawning.totalReload()));
            configElements.add(new SpecialReloadingNode(spawningNode.getNode("useBetterSpawnerConfig"), false).setReloadFunction(o -> PixelmonSpawning.totalReload()));
            return new GuiConfig((GuiScreen)this.owningScreen, (List)configElements, this.owningScreen.modID, "External Files", this.configElement.requiresWorldRestart() || this.owningScreen.allRequireWorldRestart, this.configElement.requiresMcRestart() || this.owningScreen.allRequireMcRestart, I18n.func_135052_a((String)"pixelmon.config.externalfiles.tooltip", (Object[])new Object[0]));
        }
    }

    public static class UltraSpaceEntry
    extends PixelmonCategoryEntry {
        public UltraSpaceEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
        }

        protected GuiScreen buildChildScreen() {
            ArrayList configElements = Lists.newArrayList();
            CommentedConfigurationNode generalNode = PixelmonConfig.getConfig().getNode("General");
            CommentedConfigurationNode spawningNode = PixelmonConfig.getConfig().getNode("Spawning");
            configElements.add(new ConfigurateNodeElement(generalNode.getNode("ultraSpace"), true));
            configElements.add(new ConfigurateNodeElement(generalNode.getNode("ultraSpaceDimId"), 0));
            configElements.add(new ConfigurateNodeElement(spawningNode.getNode("ultraSpaceShinyModifier"), Float.valueOf(0.5f)).setNonNegative());
            configElements.add(new ConfigurateNodeElement(spawningNode.getNode("ultraSpaceBossModifier"), Float.valueOf(0.5f)).setNonNegative());
            configElements.add(new ConfigurateNodeElement(spawningNode.getNode("ultraSpaceHiddenAbilityModifier"), Float.valueOf(0.5f)).setNonNegative());
            return new GuiConfig((GuiScreen)this.owningScreen, (List)configElements, this.owningScreen.modID, "Ultra Space", this.configElement.requiresWorldRestart() || this.owningScreen.allRequireWorldRestart, this.configElement.requiresMcRestart() || this.owningScreen.allRequireMcRestart, I18n.func_135052_a((String)"pixelmon.config.ultraspace.tooltip", (Object[])new Object[0]));
        }
    }

    public static class WorldGenEntry
    extends PixelmonCategoryEntry {
        public WorldGenEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
        }

        protected GuiScreen buildChildScreen() {
            ArrayList configElements = Lists.newArrayList();
            CommentedConfigurationNode generalNode = PixelmonConfig.getConfig().getNode("General");
            CommentedConfigurationNode spawningNode = PixelmonConfig.getConfig().getNode("Spawning");
            configElements.add(new ConfigurateNodeElement(generalNode.getNode("spawnStructures"), true).setRequiresRestart());
            configElements.add(new ConfigurateNodeElement(generalNode.getNode("spawnBirdShrines"), true).setRequiresRestart());
            configElements.add(new ConfigurateNodeElement(spawningNode.getNode("replaceMCVillagers"), true).setRequiresRestart());
            configElements.add(new ConfigurateNodeElement(spawningNode.getNode("spawnPokeMarts"), true).setRequiresRestart());
            configElements.add(new ConfigurateNodeElement(spawningNode.getNode("spawnGyms"), true).setRequiresRestart());
            configElements.add(new ConfigurateNodeElement(spawningNode.getNode("injectIntoLootTables"), true).setRequiresRestart());
            return new GuiConfig((GuiScreen)this.owningScreen, (List)configElements, this.owningScreen.modID, "World Gen", this.configElement.requiresWorldRestart() || this.owningScreen.allRequireWorldRestart, this.configElement.requiresMcRestart() || this.owningScreen.allRequireMcRestart, I18n.func_135052_a((String)"pixelmon.config.worldgen.tooltip", (Object[])new Object[0]));
        }
    }

    public static class RidingEntry
    extends PixelmonCategoryEntry {
        public RidingEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
        }

        protected GuiScreen buildChildScreen() {
            ArrayList configElements = Lists.newArrayList();
            CommentedConfigurationNode parentNode = PixelmonConfig.getConfig().getNode("Riding");
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("allowRiding"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("ridingSpeedMultiplier"), Float.valueOf(1.0f)).setLowerBound(0));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("enablePointToSteer"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("landMount"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("requireHM"), false));
            return new GuiConfig((GuiScreen)this.owningScreen, (List)configElements, this.owningScreen.modID, "Riding", this.configElement.requiresWorldRestart() || this.owningScreen.allRequireWorldRestart, this.configElement.requiresMcRestart() || this.owningScreen.allRequireMcRestart, I18n.func_135052_a((String)"pixelmon.config.riding.tooltip", (Object[])new Object[0]));
        }
    }

    public static class PokerusEntry
    extends PixelmonCategoryEntry {
        public PokerusEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
        }

        protected GuiScreen buildChildScreen() {
            ArrayList configElements = Lists.newArrayList();
            CommentedConfigurationNode parentNode = PixelmonConfig.getConfig().getNode("Pokerus");
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("pkrsEnabled"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("pkrsSpawnRate"), 12288).setLowerBound(0));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("pkrsInformPlayers"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("pkrsSpreadRate"), 1).setLowerBound(-1));
            return new GuiConfig((GuiScreen)this.owningScreen, (List)configElements, this.owningScreen.modID, "Pokerus", this.configElement.requiresWorldRestart() || this.owningScreen.allRequireWorldRestart, this.configElement.requiresMcRestart() || this.owningScreen.allRequireMcRestart, I18n.func_135052_a((String)"pixelmon.config.pokerus.tooltip", (Object[])new Object[0]));
        }
    }

    public static class ExternalMovesEntry
    extends PixelmonCategoryEntry {
        public ExternalMovesEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
        }

        protected GuiScreen buildChildScreen() {
            ArrayList configElements = Lists.newArrayList();
            CommentedConfigurationNode parentNode = PixelmonConfig.getConfig().getNode("ExternalMoves");
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("allowExternalMoves"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("allowDestructiveExternalMoves"), true));
            return new GuiConfig((GuiScreen)this.owningScreen, (List)configElements, this.owningScreen.modID, "External Moves", this.configElement.requiresWorldRestart() || this.owningScreen.allRequireWorldRestart, this.configElement.requiresMcRestart() || this.owningScreen.allRequireMcRestart, I18n.func_135052_a((String)"pixelmon.config.externalmoves.tooltip", (Object[])new Object[0]));
        }
    }

    public static class PixelUtilsEntry
    extends PixelmonCategoryEntry {
        public PixelUtilsEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
        }

        protected GuiScreen buildChildScreen() {
            ArrayList configElements = Lists.newArrayList();
            CommentedConfigurationNode parentNode = PixelmonConfig.getConfig().getNode("PixelUtilities");
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("scaleGrassBattles"), false));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("pokeGiftReusable"), false));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("pokeGiftHaveEvents"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("eventPokeGiftLoad"), false));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("eventHasLegendaries"), false));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("eventHasShinies"), false));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("eventMaxPokemon"), 1).setBounds(1, 10).setSlider());
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("eventShinyRate"), 10).setBounds(1, 100).setSlider());
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("eventTime"), "D/M"));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("eventCoords"), Collections.singletonList("notConfigured")));
            return new GuiConfig((GuiScreen)this.owningScreen, (List)configElements, this.owningScreen.modID, "PixelUtils", this.configElement.requiresWorldRestart() || this.owningScreen.allRequireWorldRestart, this.configElement.requiresMcRestart() || this.owningScreen.allRequireMcRestart, I18n.func_135052_a((String)"pixelmon.config.pixelutilities.tooltip", (Object[])new Object[0]));
        }
    }

    public static class BreedingEntry
    extends PixelmonCategoryEntry {
        public BreedingEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
        }

        protected GuiScreen buildChildScreen() {
            ArrayList configElements = Lists.newArrayList();
            CommentedConfigurationNode parentNode = PixelmonConfig.getConfig().getNode("Breeding");
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("allowBreeding"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("maxCumulativePokemonInRanch"), 0).setNonNegative());
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("allowDittoDittoBreeding"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("allowRandomBreedingEggsToBeLegendary"), false));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("useBreedingEnvironment"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("stepsPerEggCycle"), 255).setNonNegative());
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("numBreedingStages"), 5).setNonNegative());
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("breedingTicks"), 18000).setLowerBound(20));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("allowRanchExpansion"), true));
            return new GuiConfig((GuiScreen)this.owningScreen, (List)configElements, this.owningScreen.modID, "Breeding", this.configElement.requiresWorldRestart() || this.owningScreen.allRequireWorldRestart, this.configElement.requiresMcRestart() || this.owningScreen.allRequireMcRestart, I18n.func_135052_a((String)"pixelmon.config.breeding.tooltip", (Object[])new Object[0]));
        }
    }

    public static class GraphicsEntry
    extends PixelmonCategoryEntry {
        public GraphicsEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
        }

        protected GuiScreen buildChildScreen() {
            ArrayList configElements = Lists.newArrayList();
            CommentedConfigurationNode parentNode = PixelmonConfig.getConfig().getNode("Graphics");
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("renderDistanceWeight"), 2.0).setNonNegative());
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("namePlateRange"), 1).setBounds(1, 3).setSlider());
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("renderWildLevels"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("showWildNames"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("scalePokemonModels"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("useSmoothShadingOnPokeBalls"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("useSmoothShadingOnPokemon"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("showCurrentAttackTarget"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("drawHealthBars"), false));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("useBattleCamera"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("playerControlCamera"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("onlyShowAttackEffectsToBattlers"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("rangeToDisplayAttackAnimations"), 40).setNonNegative());
            return new GuiConfig((GuiScreen)this.owningScreen, (List)configElements, this.owningScreen.modID, "Graphics", this.configElement.requiresWorldRestart() || this.owningScreen.allRequireWorldRestart, this.configElement.requiresMcRestart() || this.owningScreen.allRequireMcRestart, I18n.func_135052_a((String)"pixelmon.config.graphics.tooltip", (Object[])new Object[0]));
        }
    }

    public static class AFKEntry
    extends PixelmonCategoryEntry {
        public AFKEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
        }

        protected GuiScreen buildChildScreen() {
            ArrayList configElements = Lists.newArrayList();
            CommentedConfigurationNode parentNode = PixelmonConfig.getConfig().getNode("AFKHandler");
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("enableAFKHandler"), false));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("afkActivateSeconds"), 90).setNonNegative());
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("afkHandlerTurnSeconds"), 15).setNonNegative());
            return new GuiConfig((GuiScreen)this.owningScreen, (List)configElements, this.owningScreen.modID, "AFKHandler", this.configElement.requiresWorldRestart() || this.owningScreen.allRequireWorldRestart, this.configElement.requiresMcRestart() || this.owningScreen.allRequireMcRestart, I18n.func_135052_a((String)"pixelmon.config.afkhandler.tooltip", (Object[])new Object[0]));
        }
    }

    public static class PokeLootEntry
    extends PixelmonCategoryEntry {
        public PokeLootEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
        }

        protected GuiScreen buildChildScreen() {
            ArrayList configElements = Lists.newArrayList();
            CommentedConfigurationNode parentNode = PixelmonConfig.getConfig().getNode("PokeLoot");
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("spawnNormal"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("spawnHidden"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("spawnGrotto"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("spawnRate"), 1).setBounds(0, 3).setSlider());
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("spawnMode"), 0).setBounds(0, 3).setSlider());
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("timedLootReuseHours"), 24).setNonNegative());
            return new GuiConfig((GuiScreen)this.owningScreen, (List)configElements, this.owningScreen.modID, "PokeLoot", this.configElement.requiresWorldRestart() || this.owningScreen.allRequireWorldRestart, this.configElement.requiresMcRestart() || this.owningScreen.allRequireMcRestart, I18n.func_135052_a((String)"pixelmon.config.pokeloot.tooltip", (Object[])new Object[0]));
        }
    }

    public static class SpawningGensEntry
    extends PixelmonCategoryEntry {
        public SpawningGensEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
        }

        protected GuiScreen buildChildScreen() {
            ArrayList configElements = Lists.newArrayList();
            CommentedConfigurationNode parentNode = PixelmonConfig.getConfig().getNode("Spawning").getNode("Gens");
            configElements.add(new SpecialReloadingNode(parentNode.getNode("Gen1"), true).setReloadFunction(o -> PixelmonSpawning.totalReload()));
            configElements.add(new SpecialReloadingNode(parentNode.getNode("Gen2"), true).setReloadFunction(o -> PixelmonSpawning.totalReload()));
            configElements.add(new SpecialReloadingNode(parentNode.getNode("Gen3"), true).setReloadFunction(o -> PixelmonSpawning.totalReload()));
            configElements.add(new SpecialReloadingNode(parentNode.getNode("Gen4"), true).setReloadFunction(o -> PixelmonSpawning.totalReload()));
            configElements.add(new SpecialReloadingNode(parentNode.getNode("Gen5"), true).setReloadFunction(o -> PixelmonSpawning.totalReload()));
            configElements.add(new SpecialReloadingNode(parentNode.getNode("Gen6"), true).setReloadFunction(o -> PixelmonSpawning.totalReload()));
            configElements.add(new SpecialReloadingNode(parentNode.getNode("Gen7"), true).setReloadFunction(o -> PixelmonSpawning.totalReload()));
            return new GuiConfig((GuiScreen)this.owningScreen, (List)configElements, this.owningScreen.modID, "Spawning Gens", this.configElement.requiresWorldRestart() || this.owningScreen.allRequireWorldRestart, this.configElement.requiresMcRestart() || this.owningScreen.allRequireMcRestart, I18n.func_135052_a((String)"pixelmon.config.gens.tooltip", (Object[])new Object[0]));
        }
    }

    public static class SpawningEntry
    extends PixelmonCategoryEntry {
        public SpawningEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
        }

        protected GuiScreen buildChildScreen() {
            ArrayList configElements = Lists.newArrayList();
            CommentedConfigurationNode parentNode = PixelmonConfig.getConfig().getNode("Spawning");
            configElements.add(new SpecialReloadingNode(parentNode.getNode("shinySpawnRate"), Float.valueOf(4096.0f)).setReloadFunction(o -> PixelmonSpawning.totalReload()).setNonNegative());
            configElements.add(new SpecialReloadingNode(parentNode.getNode("bossRate"), Float.valueOf(256.0f)).setReloadFunction(o -> PixelmonSpawning.totalReload()));
            configElements.add(new SpecialReloadingNode(parentNode.getNode("bossSpawnTicks"), 10000).setReloadFunction(o -> PixelmonSpawning.totalReload()).setNonNegative());
            configElements.add(new SpecialReloadingNode(parentNode.getNode("bossSpawnChance"), Float.valueOf(0.3f)).setReloadFunction(o -> PixelmonSpawning.totalReload()).setBounds(0, 1));
            configElements.add(new SpecialReloadingNode(parentNode.getNode("legendarySpawnTicks"), 25000).setReloadFunction(o -> PixelmonSpawning.totalReload()).setNonNegative());
            configElements.add(new SpecialReloadingNode(parentNode.getNode("legendarySpawnChance"), Float.valueOf(0.3f)).setReloadFunction(o -> PixelmonSpawning.totalReload()).setBounds(0, 1));
            configElements.add(new SpecialReloadingNode(parentNode.getNode("spawnTicksPlayerMultiplier"), Float.valueOf(0.01f)).setReloadFunction(o -> PixelmonSpawning.totalReload()).setNonNegative());
            configElements.add(new SpecialReloadingNode(parentNode.getNode("spawnLevelsByDistance"), false).setReloadFunction(o -> PixelmonSpawning.totalReload()));
            configElements.add(new SpecialReloadingNode(parentNode.getNode("maxLevelByDistance"), 60).setReloadFunction(o -> PixelmonSpawning.totalReload()).setBounds(5, 100));
            configElements.add(new SpecialReloadingNode(parentNode.getNode("distancePerLevel"), 30).setReloadFunction(o -> PixelmonSpawning.totalReload()).setNonNegative());
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("spawnLevelsCloserToPlayerLevels"), true));
            configElements.add(new SpecialReloadingNode(parentNode.getNode("hiddenAbilitySpawnRate"), 150).setReloadFunction(o -> PixelmonSpawning.totalReload()).setNonNegative());
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("allowLegendarySpawn"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("displayLegendaryGlobalMessage"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("useRecentLevelMoves"), false));
            configElements.add(new SpecialReloadingNode(parentNode.getNode("despawnOnFleeOrLoss"), false).setReloadFunction(o -> PixelmonSpawning.totalReload()));
            configElements.add(new SpecialReloadingNode(parentNode.getNode("entitiesPerPlayer"), 45).setReloadFunction(o -> PixelmonSpawning.totalReload()));
            configElements.add(new SpecialReloadingNode(parentNode.getNode("spawnsPerPass"), 2).setReloadFunction(o -> PixelmonSpawning.totalReload()));
            configElements.add(new SpecialReloadingNode(parentNode.getNode("spawnFrequency"), 60).setReloadFunction(o -> PixelmonSpawning.totalReload()));
            configElements.add(new SpecialReloadingNode(parentNode.getNode("minimumDistanceBetweenSpawns"), 15).setReloadFunction(o -> PixelmonSpawning.totalReload()));
            configElements.add(new SpecialReloadingNode(parentNode.getNode("minimumDistanceFromCentre"), 18).setReloadFunction(o -> PixelmonSpawning.totalReload()));
            configElements.add(new SpecialReloadingNode(parentNode.getNode("maximumDistanceFromCentre"), 64).setReloadFunction(o -> PixelmonSpawning.totalReload()));
            configElements.add(new SpecialReloadingNode(parentNode.getNode("horizontalTrackFactor"), Float.valueOf(80.0f)).setReloadFunction(o -> PixelmonSpawning.totalReload()));
            configElements.add(new SpecialReloadingNode(parentNode.getNode("verticalTrackFactor"), Float.valueOf(0.0f)).setReloadFunction(o -> PixelmonSpawning.totalReload()));
            configElements.add(new SpecialReloadingNode(parentNode.getNode("horizontalSliceRadius"), 10).setReloadFunction(o -> PixelmonSpawning.totalReload()));
            configElements.add(new SpecialReloadingNode(parentNode.getNode("verticalSliceRadius"), 25).setReloadFunction(o -> PixelmonSpawning.totalReload()));
            configElements.add(new SpecialReloadingNode(parentNode.getNode("maximumSpawnedPokemon"), 3000).setReloadFunction(o -> PixelmonSpawning.totalReload()));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("bellSuccessChance"), Float.valueOf(0.01f)).setBounds(0, 1));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("bellInclusionRange"), 1).setNonNegative());
            configElements.add(new DummyConfigElement.DummyCategoryElement("Gens", "pixelmon.config.gens", SpawningGensEntry.class));
            return new GuiConfig((GuiScreen)this.owningScreen, (List)configElements, this.owningScreen.modID, "Spawning", this.configElement.requiresWorldRestart() || this.owningScreen.allRequireWorldRestart, this.configElement.requiresMcRestart() || this.owningScreen.allRequireMcRestart, I18n.func_135052_a((String)"pixelmon.config.spawning.tooltip", (Object[])new Object[0]));
        }
    }

    public static class GeneralEntry
    extends PixelmonCategoryEntry {
        public GeneralEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
        }

        protected GuiScreen buildChildScreen() {
            ArrayList configElements = Lists.newArrayList();
            CommentedConfigurationNode parentNode = PixelmonConfig.getConfig().getNode("General");
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("awardPhotos"), false));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("allowPokemonNicknames"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("allowAnvilAutoreloading"), false));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("allowVanillaMobs"), false).setRequiresRestart());
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("allowCaptureOutsideBattle"), true).setRequiresRestart());
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("allowRandomPokemonToBeLegendary"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("growthScaleModifier"), 1.0).setBounds(0.0, 2.0).setSlider());
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("pokemonDropsEnabled"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("printErrors"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("allowPlanting"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("maximumPlants"), 32).setLowerBound(0));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("allowPvPExperience"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("allowTrainerExperience"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("returnHeldItems"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("forceEndBattleResult"), 0).setBounds(0, 2).setSlider());
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("cloningMachineEnabled"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("lakeTrioMaxEnchants"), 3).setNonNegative().setRequiresRestart());
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("engagePlayerByPokeBall"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("computerBoxes"), 30).setBounds(1, 256).setRequiresRestart());
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("enableWildAggression"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("allowTMReuse"), false));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("writeEntitiesToWorld"), false));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("reusableBirdShrines"), false));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("spawnersOpOnly"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("needHMToRide"), false));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("tradersReusable"), false));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("movesPerTutor"), 20));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("starterOnJoin"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("useSystemTimeForWorldTime"), false));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("systemTimeSyncInterval"), 30).setLowerBound(2));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("battleAIWild"), 1).setBounds(1, 4).setSlider());
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("battleAIBoss"), 2).setBounds(1, 4).setSlider());
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("battleAITrainer"), 3).setBounds(1, 4).setSlider());
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("expModifier"), Float.valueOf(1.0f)).setNonNegative());
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("multiplePhotosOfSamePokemon"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("allowPayDayMoney"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("pickupRate"), 10).setNonNegative());
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("bedsHealPokemon"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("allowPokemonEditors"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("dataSaveOnWorldSave"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("useDropGUI"), true));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("berryTreeGrowthMultiplier"), 1.0).setBounds(0.1, 1000.0));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("maxLevel"), 100));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("despawnRadius"), 80));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("canPokemonBeHit"), false));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("alwaysHaveMegaRing"), false).setRequiresRestart());
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("deleteUnwantedDrops"), false));
            configElements.add(new ConfigurateNodeElement(parentNode.getNode("chanceToGetSpecialBidoof"), 30));
            return new GuiConfig((GuiScreen)this.owningScreen, (List)configElements, this.owningScreen.modID, "General", this.configElement.requiresWorldRestart() || this.owningScreen.allRequireWorldRestart, this.configElement.requiresMcRestart() || this.owningScreen.allRequireMcRestart, I18n.func_135052_a((String)"pixelmon.config.general.tooltip", (Object[])new Object[0]));
        }
    }

    public static class PixelmonCategoryEntry
    extends GuiConfigEntries.CategoryEntry {
        public PixelmonCategoryEntry(GuiConfig owningScreen, GuiConfigEntries owningEntryList, IConfigElement configElement) {
            super(owningScreen, owningEntryList, configElement);
        }
    }
}

