/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.choosePokemon;

import com.pixelmonmod.pixelmon.client.gui.battles.GuiBattle;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonInGui;
import com.pixelmonmod.pixelmon.client.gui.battles.battleScreens.choosePokemon.ChoosePokemon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SwitchPokemon;
import com.pixelmonmod.pixelmon.enums.battle.BattleMode;
import com.pixelmonmod.pixelmon.util.helpers.CollectionHelper;
import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;

public class EnforcedSwitch
extends ChoosePokemon {
    public static boolean failFlee;

    public EnforcedSwitch(GuiBattle parent) {
        super(parent, BattleMode.EnforcedSwitch);
    }

    @Override
    protected String getBackText() {
        if (failFlee || this.getSwitchingPokemon().health > 0.0f) {
            return "";
        }
        return "gui.fainterChoice.run";
    }

    @Override
    protected void addSwitch(UUID newPokemonUUID) {
        failFlee = false;
        this.bm.selectedActions.add(new SwitchPokemon(newPokemonUUID, this.bm.battleControllerIndex, this.getSwitchingPokemon().pokemonUUID, true));
        if (this.bm.afkOn) {
            this.bm.resetAFKTime();
        }
    }

    @Override
    protected void clickBackButton() {
        if (!"".equals(this.backText)) {
            this.bm.selectRunAction(this.getSwitchingPokemon().pokemonUUID);
        }
    }

    private PixelmonInGui getSwitchingPokemon() {
        if (this.bm.currentPokemon < 0) {
            this.bm.currentPokemon = 0;
        }
        if (CollectionHelper.find(Arrays.asList(this.inBattle), Objects::nonNull) == null) {
            return null;
        }
        return this.inBattle[this.bm.currentPokemon % this.inBattle.length];
    }

    @Override
    protected void selectedMove() {
        this.bm.selectedMove(true);
    }
}

