/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.battles;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.NoStatus;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.entities.pixelmon.Entity1Base;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Illusion;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.BaseStats;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Moveset;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.items.ItemHeld;
import com.pixelmonmod.pixelmon.items.heldItems.NoItem;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PixelmonInGui {
    public UUID pokemonUUID;
    public EnumSpecies species;
    public short form = 0;
    public short gender;
    public float health;
    public int maxHealth;
    public String nickname;
    public int status = -1;
    public int level;
    public int bossLevel;
    public boolean shiny;
    public int position = 0;
    public short specialTexture = 0;
    public String customTexture = "";
    public Moveset moveset = null;
    public ItemHeld heldItem = null;
    public float expFraction = 0.0f;
    public int xPos = 0;
    public boolean isSwitching;
    public boolean blockCapture = false;

    public PixelmonInGui() {
        this.nickname = "";
        this.species = null;
    }

    public PixelmonInGui(Pokemon poke) {
        this.set(poke);
    }

    public PixelmonInGui(PixelmonWrapper pixelmon) {
        this.pokemonUUID = pixelmon.getPokemonUUID();
        this.health = pixelmon.getHealth();
        this.maxHealth = pixelmon.getMaxHealth();
        AbilityBase ability = pixelmon.getBattleAbility();
        boolean inIllusion = false;
        if (ability instanceof Illusion) {
            Illusion illusion = (Illusion)ability;
            if (illusion.disguisedGender != null) {
                this.nickname = illusion.disguisedNickname;
                this.species = illusion.disguisedPokemon;
                this.gender = (short)illusion.disguisedGender.ordinal();
                this.form = (short)illusion.disguisedForm;
                inIllusion = true;
            }
        }
        if (!inIllusion) {
            this.nickname = pixelmon.getRealNickname();
            this.species = pixelmon.getSpecies();
            this.gender = (short)pixelmon.getGender().ordinal();
            this.form = (short)pixelmon.getForm();
        }
        this.level = pixelmon.getLevelNum();
        if (pixelmon.entity != null) {
            this.bossLevel = pixelmon.entity.getBossMode().index;
        }
        this.shiny = pixelmon.getInnerLink().isShiny();
        this.specialTexture = (short)pixelmon.getInnerLink().getSpecialTexture().id;
        this.customTexture = pixelmon.pokemon.getCustomTexture();
        StatusPersist primaryStatus = pixelmon.getPrimaryStatus();
        this.status = primaryStatus != NoStatus.noStatus ? primaryStatus.type.ordinal() : -1;
        this.moveset = pixelmon.getMoveset();
        this.heldItem = pixelmon.getHeldItem();
        this.expFraction = pixelmon.pokemon.getExperienceFraction();
        this.blockCapture = pixelmon.pokemon.getBonusStats().preventsCapture();
    }

    public void set(Pokemon poke) {
        this.pokemonUUID = poke.getUUID();
        this.health = poke.getHealth();
        this.maxHealth = poke.getStat(StatsType.HP);
        this.nickname = poke.getDisplayName();
        this.species = poke.getSpecies();
        this.status = poke.getStatus() == null || poke.getStatus().type == StatusType.None ? -1 : poke.getStatus().type.ordinal();
        this.level = poke.getLevel();
        this.gender = (short)poke.getGender().ordinal();
        this.shiny = poke.isShiny();
        this.expFraction = poke.getExperienceFraction();
        this.form = (short)poke.getForm();
        this.specialTexture = (short)poke.getSpecialTexture().id;
        this.customTexture = poke.getCustomTexture();
        this.moveset = poke.getMoveset();
        this.heldItem = poke.getHeldItemAsItemHeld();
        this.blockCapture = poke.getBonusStats().preventsCapture();
    }

    public static PixelmonInGui[] convertToGUI(List<PixelmonWrapper> pokemon) {
        PixelmonInGui[] data = new PixelmonInGui[pokemon.size()];
        for (int i = 0; i < pokemon.size(); ++i) {
            data[i] = new PixelmonInGui(pokemon.get(i));
        }
        return data;
    }

    public void decodeInto(ByteBuf buffer) {
        this.pokemonUUID = new UUID(buffer.readLong(), buffer.readLong());
        this.species = EnumSpecies.getFromDex(buffer.readShort());
        this.form = buffer.readShort();
        this.health = buffer.readFloat();
        this.maxHealth = buffer.readInt();
        this.nickname = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.level = buffer.readInt();
        this.bossLevel = buffer.readInt();
        this.gender = buffer.readShort();
        this.shiny = buffer.readBoolean();
        this.status = buffer.readInt();
        this.expFraction = buffer.readFloat();
        this.specialTexture = buffer.readShort();
        this.customTexture = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.blockCapture = buffer.readBoolean();
        this.moveset = new Moveset();
        this.moveset.fromBytes(buffer);
        boolean noItem = buffer.readBoolean();
        this.heldItem = noItem ? NoItem.noItem : ItemHeld.getItemHeld(ByteBufUtils.readItemStack((ByteBuf)buffer));
    }

    public void encodeInto(ByteBuf buffer) {
        if (this.nickname == null) {
            this.nickname = this.species.name;
        }
        buffer.writeLong(this.pokemonUUID.getMostSignificantBits()).writeLong(this.pokemonUUID.getLeastSignificantBits());
        buffer.writeShort(this.species.getNationalPokedexInteger());
        buffer.writeShort((int)this.form);
        buffer.writeFloat(this.health);
        buffer.writeInt(this.maxHealth);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.nickname);
        buffer.writeInt(this.level);
        buffer.writeInt(this.bossLevel);
        buffer.writeShort((int)this.gender);
        buffer.writeBoolean(this.shiny);
        buffer.writeInt(this.status);
        buffer.writeFloat(this.expFraction);
        buffer.writeShort((int)this.specialTexture);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.customTexture);
        buffer.writeBoolean(this.blockCapture);
        this.moveset.toBytes(buffer);
        boolean noItem = this.heldItem == NoItem.noItem || this.heldItem == null;
        buffer.writeBoolean(noItem);
        if (!noItem) {
            ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)new ItemStack((Item)this.heldItem));
        }
    }

    public String getDisplayName() {
        String localizedName = Entity1Base.getLocalizedName(this.species.name);
        if (this.nickname == null || this.nickname.isEmpty() || this.nickname.equals(this.species.name)) {
            return localizedName;
        }
        return this.nickname;
    }

    public int getDexNumber() {
        return this.species.getNationalPokedexInteger();
    }

    public BaseStats getBaseStats() {
        return this.species.getBaseStats(this.species.getFormEnum(this.form));
    }

    public Gender getGender() {
        return Gender.getGender(this.gender);
    }

    public float[] getStatusTexturePos() {
        return StatusType.getTexturePos(this.status == -1 ? StatusType.None : StatusType.getEffect(this.status));
    }
}

