/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui.badgecase;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.comm.packetHandlers.badgecase.BadgecasePacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.badgecase.BadgecaseUpdateServerPacket;
import com.pixelmonmod.pixelmon.enums.items.EnumBadgecases;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiBadgecase
extends GuiScreen {
    private ItemStack itemBadgeCase;
    private ResourceLocation upTexture;
    private ResourceLocation downTexture;
    private ResourceLocation registerTexture;
    private ResourceLocation badgeCaseTexture;
    private EnumBadgecases color;
    private GuiButton buttonUp;
    private int upX = 17;
    private int upY = 208;
    private GuiButton buttonRegister;
    private int registerX = 16;
    private int registerY = 10;
    private GuiButton buttonDown;
    private int downX = 59;
    private int downY = 208;
    private GuiButton buttonBadge1;
    private int badge1X = 32;
    private int badge1Y = 137;
    private GuiButton buttonBadge2;
    private int badge2X = 74;
    private int badge2Y = 137;
    private GuiButton buttonBadge3;
    private int badge3X = 116;
    private int badge3Y = 137;
    private GuiButton buttonBadge4;
    private int badge4X = 158;
    private int badge4Y = 137;
    private GuiButton buttonBadge5;
    private int badge5X = 32;
    private int badge5Y = 170;
    private GuiButton buttonBadge6;
    private int badge6X = 74;
    private int badge6Y = 170;
    private GuiButton buttonBadge7;
    private int badge7X = 116;
    private int badge7Y = 170;
    private GuiButton buttonBadge8;
    private int badge8X = 158;
    private int badge8Y = 170;
    private int selectedBadge = -1;
    private int page = 0;
    private String owner;
    private String uuid;
    private boolean isAGP;
    public List<String> obtainedBadges = new ArrayList<String>();
    public List<NBTTagCompound> obtainedBadgeCompounds = new ArrayList<NBTTagCompound>();

    public GuiBadgecase(String username, ItemStack itemBadgeCase, EnumBadgecases color, String badges, NBTTagCompound badgeCompounds) {
        this.field_146297_k = Minecraft.func_71410_x();
        this.obtainedBadges = this.getBadgesAsList(badges);
        this.owner = username;
        this.color = color;
        this.itemBadgeCase = itemBadgeCase;
        this.badgeCaseTexture = new ResourceLocation(GuiResources.prefix + "gui/badgecases/badgecase_" + color.toString().toLowerCase() + ".png");
        this.upTexture = new ResourceLocation(GuiResources.prefix + "gui/badgecases/up_button_" + color.toString().toLowerCase() + ".png");
        this.downTexture = new ResourceLocation(GuiResources.prefix + "gui/badgecases/down_button_" + color.toString().toLowerCase() + ".png");
        this.registerTexture = new ResourceLocation(GuiResources.prefix + "gui/badgecases/register_" + color.toString().toLowerCase() + ".png");
        this.isAGP = true;
    }

    public GuiBadgecase(ItemStack itemBadgeCase, EnumBadgecases color) {
        this.field_146297_k = Minecraft.func_71410_x();
        this.itemBadgeCase = itemBadgeCase;
        this.color = color;
        this.isAGP = false;
        this.badgeCaseTexture = new ResourceLocation(GuiResources.prefix + "gui/badgecases/badgecase_" + color.toString().toLowerCase() + ".png");
        this.upTexture = new ResourceLocation(GuiResources.prefix + "gui/badgecases/up_button_" + color.toString().toLowerCase() + ".png");
        this.downTexture = new ResourceLocation(GuiResources.prefix + "gui/badgecases/down_button_" + color.toString().toLowerCase() + ".png");
        this.registerTexture = new ResourceLocation(GuiResources.prefix + "gui/badgecases/register_" + color.toString().toLowerCase() + ".png");
        if (itemBadgeCase.func_77942_o() && itemBadgeCase.func_77978_p().func_74764_b("Badges") && itemBadgeCase.func_77978_p().func_74764_b("Owners-Username") && itemBadgeCase.func_77978_p().func_74764_b("Owners-UUID") && itemBadgeCase.func_77978_p().func_74764_b("BadgeCompounds")) {
            NBTTagCompound nbtBadgeCase = itemBadgeCase.func_77978_p();
            this.obtainedBadges = this.getBadgesAsList(nbtBadgeCase.func_74779_i("Badges"));
            this.obtainedBadgeCompounds = this.getBadgeCompoundsAsList(nbtBadgeCase.func_74775_l("BadgeCompounds"));
            this.owner = nbtBadgeCase.func_74779_i("Owners-Username");
            this.uuid = nbtBadgeCase.func_74779_i("Owners-UUID");
        }
        if (itemBadgeCase.func_77942_o() && itemBadgeCase.func_77978_p().func_74764_b("Owners-UUID") && itemBadgeCase.func_77978_p().func_74764_b("Owners-UUID") && this.field_146297_k.field_71439_g.func_110124_au().toString().equalsIgnoreCase(itemBadgeCase.func_77978_p().func_74779_i("Owners-UUID")) && !this.field_146297_k.field_71439_g.func_70005_c_().equalsIgnoreCase(itemBadgeCase.func_77978_p().func_74779_i("Owners-Username"))) {
            BadgecasePacket packet = new BadgecasePacket(this.field_146297_k.field_71439_g.func_110124_au().toString(), this.formatBadges(this.obtainedBadges), this.formatBadgeCompounds(this.obtainedBadgeCompounds), true, (EntityPlayer)this.field_146297_k.field_71439_g);
            Pixelmon.network.sendToServer((IMessage)packet);
        }
    }

    public void func_73866_w_() {
        int buttonID = 0;
        int xOffset = (this.field_146294_l - 252) / 2;
        int yOffset = 2;
        this.buttonUp = new GuiButton(buttonID, xOffset + this.upX, yOffset + this.upY, 54, 20, "");
        this.buttonDown = new GuiButton(++buttonID, xOffset + this.downX, yOffset + this.downY, 54, 20, "");
        this.buttonRegister = new GuiButton(++buttonID, xOffset + this.registerX, yOffset + this.registerY, 211, 38, "");
        this.buttonBadge1 = new GuiButton(++buttonID, xOffset + this.badge1X, yOffset + this.badge1Y, 32, 32, "");
        this.buttonBadge2 = new GuiButton(++buttonID, xOffset + this.badge2X, yOffset + this.badge2Y, 32, 32, "");
        this.buttonBadge3 = new GuiButton(++buttonID, xOffset + this.badge3X, yOffset + this.badge3Y, 32, 32, "");
        this.buttonBadge4 = new GuiButton(++buttonID, xOffset + this.badge4X, yOffset + this.badge4Y, 32, 32, "");
        this.buttonBadge5 = new GuiButton(++buttonID, xOffset + this.badge5X, yOffset + this.badge5Y, 32, 32, "");
        this.buttonBadge6 = new GuiButton(++buttonID, xOffset + this.badge6X, yOffset + this.badge6Y, 32, 32, "");
        this.buttonBadge7 = new GuiButton(++buttonID, xOffset + this.badge7X, yOffset + this.badge7Y, 32, 32, "");
        this.buttonBadge8 = new GuiButton(++buttonID, xOffset + this.badge8X, yOffset + this.badge8Y, 32, 32, "");
        this.field_146292_n.add(this.buttonUp);
        this.field_146292_n.add(this.buttonDown);
        if (this.isAGP) {
            this.buttonRegister.field_146124_l = false;
        } else if (this.itemBadgeCase.func_77942_o() && this.itemBadgeCase.func_77978_p().func_74764_b("Badges") && this.itemBadgeCase.func_77978_p().func_74764_b("Owners-Username") && this.itemBadgeCase.func_77978_p().func_74764_b("Owners-UUID")) {
            this.buttonRegister.field_146124_l = false;
        }
        this.field_146292_n.add(this.buttonRegister);
        this.field_146292_n.add(this.buttonBadge1);
        this.field_146292_n.add(this.buttonBadge2);
        this.field_146292_n.add(this.buttonBadge3);
        this.field_146292_n.add(this.buttonBadge4);
        this.field_146292_n.add(this.buttonBadge5);
        this.field_146292_n.add(this.buttonBadge6);
        this.field_146292_n.add(this.buttonBadge7);
        this.field_146292_n.add(this.buttonBadge8);
    }

    public void func_73732_a(FontRenderer fontRendererIn, String text, int x, int y, int color) {
        this.field_146289_q.func_175065_a(text, (float)(x + this.registerX + 19), (float)(y + this.registerY + 3), color, false);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int guiWidth = 210;
        int guiHeight = 235;
        int xOffset = (this.field_146294_l - 205) / 2;
        int yOffset = 2;
        this.field_146297_k.field_71446_o.func_110577_a(this.badgeCaseTexture);
        Gui.func_146110_a((int)xOffset, (int)yOffset, (float)0.0f, (float)0.0f, (int)210, (int)235, (float)210.0f, (float)235.0f);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        int upDownButtonWidth = 40;
        int upDownButtonHeight = 14;
        this.field_146297_k.field_71446_o.func_110577_a(this.upTexture);
        Gui.func_146110_a((int)(xOffset + this.upX), (int)(yOffset + this.upY), (float)0.0f, (float)0.0f, (int)upDownButtonWidth, (int)upDownButtonHeight, (float)upDownButtonWidth, (float)upDownButtonHeight);
        this.field_146297_k.field_71446_o.func_110577_a(this.downTexture);
        Gui.func_146110_a((int)(xOffset + this.downX), (int)(yOffset + this.downY), (float)0.0f, (float)0.0f, (int)upDownButtonWidth, (int)upDownButtonHeight, (float)upDownButtonWidth, (float)upDownButtonHeight);
        int registerButtonWidth = 80;
        int registerButtonHeight = 14;
        if (this.buttonRegister.field_146124_l) {
            this.field_146297_k.field_71446_o.func_110577_a(this.registerTexture);
            Gui.func_146110_a((int)(xOffset + this.registerX), (int)(yOffset + this.registerY), (float)0.0f, (float)0.0f, (int)registerButtonWidth, (int)registerButtonHeight, (float)registerButtonWidth, (float)registerButtonHeight);
        }
        int textColor = 1048575;
        switch (this.color) {
            case Black: {
                textColor = 0x919191;
                break;
            }
            case Blue: {
                if (this.buttonRegister.field_146124_l) {
                    textColor = 0x1919FF;
                    break;
                }
                textColor = 35020;
                break;
            }
            case Green: {
                textColor = 13064;
                break;
            }
            case Pink: {
                if (!this.buttonRegister.field_146124_l) {
                    textColor = 0xFF99FF;
                    break;
                }
                textColor = 0xE600E6;
                break;
            }
            case Red: {
                if (this.buttonRegister.field_146124_l) {
                    textColor = 0xB30000;
                    break;
                }
                textColor = 0xFF4D4D;
                break;
            }
            case White: {
                textColor = 0;
                break;
            }
            case Yellow: {
                textColor = 0;
                break;
            }
            default: {
                textColor = 1048575;
            }
        }
        this.func_73732_a(Minecraft.func_71410_x().field_71466_p, this.buttonRegister.field_146124_l ? I18n.func_135052_a((String)"gui.badgecase.register", (Object[])new Object[0]) : this.owner, xOffset, yOffset, textColor);
        int badgeButtonWidth = 20;
        int badgeButtonHeight = 20;
        for (int i = 0; i <= 7 && this.page * 8 + i != this.obtainedBadges.size(); ++i) {
            int rowX = 32;
            int firstRowY = 137;
            int secondRowY = 170;
            int rowOffset = 42;
            if (this.selectedBadge == this.page * 8 + i) {
                GlStateManager.func_179124_c((float)0.173f, (float)0.216f, (float)0.23f);
            }
            this.field_146297_k.field_71446_o.func_110577_a(new ResourceLocation(GuiResources.prefix + "items/badges/" + this.obtainedBadges.get(this.page * 8 + i).replace("_", "") + ".png"));
            Gui.func_146110_a((int)(xOffset + rowX + (i + 1 <= 4 ? i * rowOffset : (i - 4) * rowOffset)), (int)(yOffset + (i + 1 <= 4 ? firstRowY : secondRowY)), (float)0.0f, (float)0.0f, (int)badgeButtonWidth, (int)badgeButtonHeight, (float)badgeButtonWidth, (float)badgeButtonHeight);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (!this.isAGP && this.itemBadgeCase.func_77942_o() && this.itemBadgeCase.func_77978_p().func_74764_b("Badges") && this.itemBadgeCase.func_77978_p().func_74764_b("Owners-Username") && this.itemBadgeCase.func_77978_p().func_74764_b("Owners-UUID") && !this.field_146297_k.field_71439_g.func_110124_au().toString().equalsIgnoreCase(this.uuid)) {
            return;
        }
        int badgeButtonWidth = 20;
        int badgeButtonHeight = 20;
        int upDownButtonWidth = 40;
        int upDownButtonHeight = 14;
        int registerButtonWidth = 80;
        int registerButtonHeight = 14;
        int xOffset = (this.field_146294_l - 205) / 2;
        int yOffset = 2;
        if (mouseX > this.badge1X + xOffset && mouseX < this.badge1X + badgeButtonWidth + xOffset && mouseY > this.badge1Y + yOffset && mouseY <= this.badge1Y + badgeButtonHeight + yOffset) {
            if (this.isAGP) {
                return;
            }
            if (this.obtainedBadges.size() >= this.page * 8 + 1) {
                if (mouseButton == 0) {
                    this.buttonBadge1.func_146113_a(this.field_146297_k.func_147118_V());
                    if (this.selectedBadge == -1) {
                        this.selectedBadge = this.page * 8 + 0;
                    } else {
                        this.swapBadges(this.selectedBadge, this.page * 8 + 0);
                        this.selectedBadge = -1;
                        this.updateBadgeList();
                    }
                } else if (mouseButton == 1) {
                    this.buttonBadge1.func_146113_a(this.field_146297_k.func_147118_V());
                    this.removeBadge(this.page * 8 + 0);
                    this.selectedBadge = -1;
                }
            }
        } else if (mouseX > this.badge2X + xOffset && mouseX < this.badge2X + badgeButtonWidth + xOffset && mouseY > this.badge2Y + yOffset && mouseY <= this.badge2Y + badgeButtonHeight + yOffset) {
            if (this.isAGP) {
                return;
            }
            if (this.obtainedBadges.size() >= this.page * 8 + 2) {
                if (mouseButton == 0) {
                    this.buttonBadge2.func_146113_a(this.field_146297_k.func_147118_V());
                    if (this.selectedBadge == -1) {
                        this.selectedBadge = this.page * 8 + 1;
                    } else {
                        this.swapBadges(this.selectedBadge, this.page * 8 + 1);
                        this.selectedBadge = -1;
                        this.updateBadgeList();
                    }
                } else if (mouseButton == 1) {
                    this.buttonBadge2.func_146113_a(this.field_146297_k.func_147118_V());
                    this.removeBadge(this.page * 8 + 1);
                    this.selectedBadge = -1;
                }
            }
        } else if (mouseX > this.badge3X + xOffset && mouseX < this.badge3X + badgeButtonWidth + xOffset && mouseY > this.badge3Y + yOffset && mouseY <= this.badge3Y + badgeButtonHeight + yOffset) {
            if (this.isAGP) {
                return;
            }
            if (this.obtainedBadges.size() >= this.page * 8 + 3) {
                if (mouseButton == 0) {
                    this.buttonBadge3.func_146113_a(this.field_146297_k.func_147118_V());
                    if (this.selectedBadge == -1) {
                        this.selectedBadge = this.page * 8 + 2;
                    } else {
                        this.swapBadges(this.selectedBadge, this.page * 8 + 2);
                        this.selectedBadge = -1;
                        this.updateBadgeList();
                    }
                } else if (mouseButton == 1) {
                    this.buttonBadge3.func_146113_a(this.field_146297_k.func_147118_V());
                    this.removeBadge(this.page * 8 + 2);
                    this.selectedBadge = -1;
                }
            }
        } else if (mouseX > this.badge4X + xOffset && mouseX < this.badge4X + badgeButtonWidth + xOffset && mouseY > this.badge4Y + yOffset && mouseY <= this.badge4Y + badgeButtonHeight + yOffset) {
            if (this.isAGP) {
                return;
            }
            if (this.obtainedBadges.size() >= this.page * 8 + 4) {
                if (mouseButton == 0) {
                    this.buttonBadge4.func_146113_a(this.field_146297_k.func_147118_V());
                    if (this.selectedBadge == -1) {
                        this.selectedBadge = this.page * 8 + 3;
                    } else {
                        this.swapBadges(this.selectedBadge, this.page * 8 + 3);
                        this.selectedBadge = -1;
                        this.updateBadgeList();
                    }
                } else if (mouseButton == 1) {
                    this.buttonBadge4.func_146113_a(this.field_146297_k.func_147118_V());
                    this.removeBadge(this.page * 8 + 3);
                    this.selectedBadge = -1;
                }
            }
        } else if (mouseX > this.badge5X + xOffset && mouseX < this.badge5X + badgeButtonWidth + xOffset && mouseY > this.badge5Y + yOffset && mouseY <= this.badge5Y + badgeButtonHeight + yOffset) {
            if (this.isAGP) {
                return;
            }
            if (this.obtainedBadges.size() >= this.page * 8 + 5) {
                if (mouseButton == 0) {
                    this.buttonBadge5.func_146113_a(this.field_146297_k.func_147118_V());
                    if (this.selectedBadge == -1) {
                        this.selectedBadge = this.page * 8 + 4;
                    } else {
                        this.swapBadges(this.selectedBadge, this.page * 8 + 4);
                        this.selectedBadge = -1;
                        this.updateBadgeList();
                    }
                } else if (mouseButton == 1) {
                    this.buttonBadge5.func_146113_a(this.field_146297_k.func_147118_V());
                    this.removeBadge(this.page * 8 + 4);
                    this.selectedBadge = -1;
                }
            }
        } else if (mouseX > this.badge6X + xOffset && mouseX < this.badge6X + badgeButtonWidth + xOffset && mouseY > this.badge6Y + yOffset && mouseY <= this.badge6Y + badgeButtonHeight + yOffset) {
            if (this.isAGP) {
                return;
            }
            if (this.obtainedBadges.size() >= this.page * 8 + 6) {
                if (mouseButton == 0) {
                    this.buttonBadge6.func_146113_a(this.field_146297_k.func_147118_V());
                    if (this.selectedBadge == -1) {
                        this.selectedBadge = this.page * 8 + 5;
                    } else {
                        this.swapBadges(this.selectedBadge, this.page * 8 + 5);
                        this.selectedBadge = -1;
                        this.updateBadgeList();
                    }
                } else if (mouseButton == 1) {
                    this.buttonBadge6.func_146113_a(this.field_146297_k.func_147118_V());
                    this.removeBadge(this.page * 8 + 5);
                    this.selectedBadge = -1;
                }
            }
        } else if (mouseX > this.badge7X + xOffset && mouseX < this.badge7X + badgeButtonWidth + xOffset && mouseY > this.badge7Y + yOffset && mouseY <= this.badge7Y + badgeButtonHeight + yOffset) {
            if (this.isAGP) {
                return;
            }
            if (this.obtainedBadges.size() >= this.page * 8 + 7) {
                if (mouseButton == 0) {
                    this.buttonBadge7.func_146113_a(this.field_146297_k.func_147118_V());
                    if (this.selectedBadge == -1) {
                        this.selectedBadge = this.page * 8 + 6;
                    } else {
                        this.swapBadges(this.selectedBadge, this.page * 8 + 6);
                        this.selectedBadge = -1;
                        this.updateBadgeList();
                    }
                } else if (mouseButton == 1) {
                    this.buttonBadge7.func_146113_a(this.field_146297_k.func_147118_V());
                    this.removeBadge(this.page * 8 + 6);
                    this.selectedBadge = -1;
                }
            }
        } else if (mouseX > this.badge8X + xOffset && mouseX < this.badge8X + badgeButtonWidth + xOffset && mouseY > this.badge8Y + yOffset && mouseY <= this.badge8Y + badgeButtonHeight + yOffset) {
            if (this.isAGP) {
                return;
            }
            if (this.obtainedBadges.size() >= this.page * 8 + 8) {
                if (mouseButton == 0) {
                    this.buttonBadge8.func_146113_a(this.field_146297_k.func_147118_V());
                    if (this.selectedBadge == -1) {
                        this.selectedBadge = this.page * 8 + 7;
                    } else {
                        this.swapBadges(this.selectedBadge, this.page * 8 + 7);
                        this.updateBadgeList();
                        this.selectedBadge = -1;
                    }
                } else if (mouseButton == 1) {
                    this.buttonBadge8.func_146113_a(this.field_146297_k.func_147118_V());
                    this.removeBadge(this.page * 8 + 7);
                    this.selectedBadge = -1;
                }
            }
        } else if (mouseX > this.registerX + xOffset && mouseX < this.registerX + registerButtonWidth + xOffset && mouseY > this.registerY + yOffset && mouseY <= this.registerY + registerButtonHeight + yOffset) {
            if (this.isAGP) {
                return;
            }
            if (this.buttonRegister.field_146124_l) {
                this.registerBadgecase();
                this.buttonRegister.field_146124_l = false;
                this.buttonBadge1.func_146113_a(this.field_146297_k.func_147118_V());
            }
        } else if (mouseX > this.upX + xOffset && mouseX < this.upX + upDownButtonWidth + xOffset && mouseY > this.upY + yOffset && mouseY <= this.upY + upDownButtonHeight + yOffset) {
            this.buttonBadge1.func_146113_a(this.field_146297_k.func_147118_V());
            this.pageUp();
        } else if (mouseX > this.downX + xOffset && mouseX < this.downX + upDownButtonWidth + xOffset && mouseY > this.downY + yOffset && mouseY <= this.downY + upDownButtonHeight + yOffset) {
            this.buttonBadge1.func_146113_a(this.field_146297_k.func_147118_V());
            this.pageDown();
        }
    }

    private void pageDown() {
        if ((this.page + 1) * 8 >= this.obtainedBadges.size()) {
            return;
        }
        ++this.page;
    }

    private void pageUp() {
        if (this.page == 0) {
            return;
        }
        --this.page;
    }

    private void swapBadges(int badgeOne, int badgeTwo) {
        String temp = this.obtainedBadges.get(badgeTwo);
        String temp2 = this.obtainedBadges.get(badgeOne);
        this.obtainedBadges.set(badgeOne, temp);
        this.obtainedBadges.set(badgeTwo, temp2);
        NBTTagCompound temp3 = this.obtainedBadgeCompounds.get(badgeTwo);
        NBTTagCompound temp4 = this.obtainedBadgeCompounds.get(badgeOne);
        this.obtainedBadgeCompounds.set(badgeOne, temp3);
        this.obtainedBadgeCompounds.set(badgeTwo, temp4);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode)) {
            this.field_146297_k.func_147108_a(null);
            if (this.field_146297_k.field_71462_r == null) {
                this.field_146297_k.func_71381_h();
            }
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    private void registerBadgecase() {
        if (this.itemBadgeCase.func_77942_o() && this.itemBadgeCase.func_77978_p().func_74764_b("Badges") && this.itemBadgeCase.func_77978_p().func_74764_b("Owners-Username") && this.itemBadgeCase.func_77978_p().func_74764_b("Owners-UUID")) {
            return;
        }
        this.owner = this.field_146297_k.field_71439_g.func_70005_c_();
        this.uuid = this.field_146297_k.field_71439_g.func_110124_au().toString();
        BadgecasePacket packet = new BadgecasePacket(this.field_146297_k.field_71439_g.func_110124_au().toString(), "", new NBTTagCompound(), true, (EntityPlayer)this.field_146297_k.field_71439_g);
        Pixelmon.network.sendToServer((IMessage)packet);
    }

    private void updateBadgeList() {
        BadgecasePacket packet = new BadgecasePacket(this.field_146297_k.field_71439_g.func_110124_au().toString(), this.formatBadges(this.obtainedBadges), this.formatBadgeCompounds(this.obtainedBadgeCompounds), true, (EntityPlayer)this.field_146297_k.field_71439_g);
        Pixelmon.network.sendToServer((IMessage)packet);
    }

    private void removeBadge(int slot) {
        BadgecaseUpdateServerPacket packet = new BadgecaseUpdateServerPacket(slot, (EntityPlayer)this.field_146297_k.field_71439_g);
        Pixelmon.network.sendToServer((IMessage)packet);
    }

    private List<String> getBadgesAsList(String badgesUnformatted) {
        ArrayList<String> badges = new ArrayList<String>();
        if (!badgesUnformatted.contains(",")) {
            if (badgesUnformatted.isEmpty()) {
                return badges;
            }
            badges.add(badgesUnformatted);
            return badges;
        }
        for (String s : badgesUnformatted.split(",")) {
            badges.add(s);
        }
        return badges;
    }

    private String formatBadges(List<String> badgeList) {
        if (badgeList.isEmpty()) {
            return "";
        }
        if (badgeList.size() == 1) {
            return badgeList.get(0);
        }
        String formatted = badgeList.get(0);
        for (int i = 1; i <= badgeList.size() - 1; ++i) {
            formatted = formatted + "," + badgeList.get(i);
        }
        return formatted;
    }

    private List<NBTTagCompound> getBadgeCompoundsAsList(NBTTagCompound badgeCompound) {
        ArrayList<NBTTagCompound> badges = new ArrayList<NBTTagCompound>();
        if (badgeCompound.func_150296_c().isEmpty()) {
            return badges;
        }
        int biggestNum = -1;
        for (int i = 0; i < badgeCompound.func_150296_c().size(); ++i) {
            for (String s : badgeCompound.func_150296_c()) {
                try {
                    if (Integer.parseInt(s.substring(5)) != biggestNum + 1) continue;
                    badges.add(badgeCompound.func_74775_l(s));
                    ++biggestNum;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return badges;
    }

    private NBTTagCompound formatBadgeCompounds(List<NBTTagCompound> badgeList) {
        if (badgeList.isEmpty()) {
            return new NBTTagCompound();
        }
        NBTTagCompound formatted = new NBTTagCompound();
        int i = 0;
        for (NBTTagCompound c : badgeList) {
            formatted.func_74782_a("badge" + i, (NBTBase)c);
            ++i;
        }
        return formatted;
    }
}

