/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client.gui;

import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.client.ClientProxy;
import com.pixelmonmod.pixelmon.client.gui.GuiCameraOverlay;
import com.pixelmonmod.pixelmon.client.gui.GuiHelper;
import com.pixelmonmod.pixelmon.client.gui.GuiItemDrops;
import com.pixelmonmod.pixelmon.client.gui.GuiResources;
import com.pixelmonmod.pixelmon.client.gui.elements.GuiKeybindIcon;
import com.pixelmonmod.pixelmon.client.listener.SendoutListener;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.StatsType;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.util.helpers.CollectionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class GuiPixelmonOverlay
extends Gui {
    public static boolean isGuiMinimized = false;
    public FontRenderer fontRenderer;
    public static int selectedPixelmon;
    public static ResourceLocation selectedMoveSkill;
    public static int targetId;
    public static boolean isVisible;
    private static int sideBarHeight;
    public static List<GuiKeybindIcon> icons;
    protected static GuiKeybindIcon pokedexIcon;
    protected static GuiKeybindIcon wikiIcon;
    protected static GuiKeybindIcon trainerCardIcon;
    static int count;
    private static String messageName;
    private static String oldMessageName;
    private static UUID uuid;
    private static UUID lastUuid;
    private static int fadeInTicks;
    private static int fadeOutTicks;

    public GuiPixelmonOverlay() {
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
        icons = new ArrayList<GuiKeybindIcon>();
        pokedexIcon = new GuiKeybindIcon(ClientProxy.pokedexKeyBind, GuiResources.pokedexItemIcon);
        icons.add(pokedexIcon);
        wikiIcon = new GuiKeybindIcon(ClientProxy.wikiKeyBind, GuiResources.wikiItemIcon);
        icons.add(wikiIcon);
        trainerCardIcon = new GuiKeybindIcon(ClientProxy.trainerCardKeyBind, GuiResources.trainerCardItemIcon);
        icons.add(trainerCardIcon);
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (count++ >= 100) {
            count = 0;
        }
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (mc.field_71462_r != null && !isVisible) {
            return;
        }
        if (mc.field_71462_r instanceof GuiInventory || mc.field_71474_y.field_74319_N || mc.field_71462_r instanceof GuiItemDrops) {
            return;
        }
        if (ClientStorageManager.party == null || ClientStorageManager.party.countAll() == 0) {
            return;
        }
        GuiCameraOverlay.checkCameraOn();
        ScaledResolution var5 = new ScaledResolution(mc);
        int screenWidth = var5.func_78326_a();
        int screenHeight = var5.func_78328_b();
        mc.field_71460_t.func_78478_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        if (GuiCameraOverlay.isCameraGuiOn) {
            GuiCameraOverlay.renderCamera(screenWidth, screenHeight, mc);
        } else {
            int topSideBar = screenHeight / 2 - sideBarHeight / 2;
            int topOffset = topSideBar + 5;
            float slotHeight = 30.0f;
            mc.field_71446_o.func_110577_a(GuiResources.dock);
            this.field_73735_i = -90.0f;
            GuiHelper.drawImageQuad(0.0, topSideBar, 22.0, 203.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
            int leftText = 30;
            this.fontRenderer.func_78264_a(true);
            int i = -1;
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiPixelmonOverlay.checkSelection();
            PlayerPartyStorage party = ClientStorageManager.party;
            for (Pokemon pokemon : party.getAll()) {
                int offset = 0;
                int yPos = topOffset + (int)((float)(++i) * slotHeight) + 9 + offset;
                if (pokemon != null) {
                    boolean isSentOut = SendoutListener.isInWorld(pokemon.getUUID(), (World)mc.field_71441_e);
                    if (!isGuiMinimized) {
                        mc.field_71446_o.func_110577_a(GuiResources.textbox);
                        GuiHelper.drawImageQuad(leftText - 28, yPos - 10, 123.0, 34.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                        float textureX = -1.0f;
                        float textureY = -1.0f;
                        float[] texturePair = StatusType.getTexturePos(pokemon.getStatus().type);
                        textureX = texturePair[0];
                        textureY = texturePair[1];
                        if (textureX != -1.0f && pokemon.getHealth() > 0) {
                            mc.field_71446_o.func_110577_a(GuiResources.status);
                            GuiHelper.drawImageQuad(leftText + 46, yPos + 1, 14.72f, 6.44f, textureX / 299.0f, textureY / 210.0f, (textureX + 147.0f) / 299.0f, (textureY + 68.0f) / 210.0f, this.field_73735_i);
                        }
                    }
                    String displayName = pokemon.getDisplayName();
                    if (!isGuiMinimized) {
                        this.fontRenderer.func_78276_b(displayName, leftText - 2, yPos, 0xFFFFFF);
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        if (pokemon.getGender() == Gender.Male && !pokemon.isEgg()) {
                            mc.field_71446_o.func_110577_a(GuiResources.male);
                            GuiHelper.drawImageQuad(this.fontRenderer.func_78256_a(displayName) + leftText - 1, yPos, 5.0, 8.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                        } else if (pokemon.getGender() == Gender.Female && !pokemon.isEgg()) {
                            mc.field_71446_o.func_110577_a(GuiResources.female);
                            GuiHelper.drawImageQuad(this.fontRenderer.func_78256_a(displayName) + leftText - 1, yPos, 5.0, 8.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                        }
                    }
                    GuiHelper.bindPokeballTexture(pokemon.getCaughtBall());
                    GuiHelper.drawImageQuad(-3.0, yPos - 7, 32.0, 32.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                    if (i == selectedPixelmon) {
                        if (pokemon.getHealth() <= 0) {
                            mc.field_71446_o.func_110577_a(GuiResources.faintedSelected);
                        } else if (isSentOut) {
                            mc.field_71446_o.func_110577_a(GuiResources.releasedSelected);
                        } else {
                            mc.field_71446_o.func_110577_a(GuiResources.selected);
                        }
                    } else if (pokemon.getHealth() <= 0) {
                        mc.field_71446_o.func_110577_a(GuiResources.fainted);
                    } else if (isSentOut) {
                        mc.field_71446_o.func_110577_a(GuiResources.released);
                    } else {
                        mc.field_71446_o.func_110577_a(GuiResources.normal);
                    }
                    GuiHelper.drawImageQuad(-3.0, yPos - 7, 32.0, 32.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                    this.drawPokemonSprite(pokemon, yPos, mc);
                    if (!pokemon.getHeldItem().func_190926_b()) {
                        mc.field_71446_o.func_110577_a(GuiResources.heldItem);
                        GuiHelper.drawImageQuad(18.0, yPos + 13, 6.0, 6.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                    }
                    if (isGuiMinimized || pokemon.isEgg()) continue;
                    String levelString = I18n.func_135052_a((String)"gui.screenpokechecker.lvl", (Object[])new Object[0]) + " " + pokemon.getLevel();
                    this.fontRenderer.func_78276_b(levelString, leftText - 1, yPos + 1 + this.fontRenderer.field_78288_b, 0xFFFFFF);
                    if (pokemon.getHealth() <= 0) {
                        this.fontRenderer.func_78276_b(I18n.func_135052_a((String)"gui.creativeinv.fainted", (Object[])new Object[0]), leftText + 1 + this.fontRenderer.func_78256_a(levelString), yPos + 1 + this.fontRenderer.field_78288_b, 0xFFFFFF);
                        continue;
                    }
                    this.fontRenderer.func_78276_b(I18n.func_135052_a((String)"nbt.hp.name", (Object[])new Object[0]) + " " + pokemon.getHealth() + "/" + pokemon.getStat(StatsType.HP), leftText + 2 + this.fontRenderer.func_78256_a(levelString), yPos + 1 + this.fontRenderer.field_78288_b, 0xFFFFFF);
                    continue;
                }
                mc.field_71446_o.func_110577_a(GuiResources.available);
                GuiHelper.drawImageQuad(5.0, yPos + 1, 16.0, 16.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
            }
            ScaledResolution eventResolution = event.getResolution();
            int scaledWidth = eventResolution.func_78326_a();
            Pokemon pokemon = party.get(selectedPixelmon);
            if (pokemon != null) {
                boolean isSentOut = SendoutListener.isInWorld(pokemon.getUUID(), (World)mc.field_71441_e);
                if (PixelmonConfig.showTarget && isSentOut) {
                    mc.field_71446_o.func_110577_a(GuiResources.targetArea);
                    GuiHelper.drawImageQuad(scaledWidth - 76, 2.0, 24.0, 24.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                    this.fontRenderer.func_78276_b(GameSettings.func_74298_c((int)ClientProxy.actionKeyBind.func_151463_i()), scaledWidth - 50, 0, 0xFFFFFF);
                    if (targetId != -1) {
                        EntityLivingBase entity = (EntityLivingBase)mc.field_71441_e.func_73045_a(targetId);
                        if (entity instanceof EntityPixelmon) {
                            Pokemon target = ((EntityPixelmon)entity).getPokemonData();
                            GuiHelper.bindPokemonSprite(target, mc);
                            GuiHelper.drawImageQuad(scaledWidth - 75, 3.0, 20.0, 20.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                        } else if (entity instanceof EntityPlayer) {
                            mc.func_175598_ae().field_78724_e.func_110577_a(((AbstractClientPlayer)entity).func_110306_p());
                            GuiHelper.drawImageQuad(scaledWidth - 73, 5.0, 18.0, 18.0f, 0.125, 0.125, 0.25, 0.25, this.field_73735_i);
                        } else if (entity instanceof NPCTrainer) {
                            mc.func_175598_ae().field_78724_e.func_110577_a(AbstractClientPlayer.func_110311_f((String)""));
                            GuiHelper.drawImageQuad(scaledWidth - 73, 5.0, 18.0, 18.0f, 0.125, 0.125, 0.25, 0.25, this.field_73735_i);
                        }
                    } else {
                        mc.field_71446_o.func_110577_a(GuiResources.notarget);
                        GuiHelper.drawImageQuad(scaledWidth - 76, 2.0, 24.0, 24.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                    }
                    mc.field_71446_o.func_110577_a(GuiResources.targetAreaOver);
                    GuiHelper.drawImageQuad(scaledWidth - 76, 2.0, 24.0, 24.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                } else {
                    targetId = -1;
                }
                if (isSentOut && PixelmonServerConfig.allowExternalMoves) {
                    MoveSkill selected;
                    ArrayList<MoveSkill> moveSkills = ClientProxy.getMoveSkills(ClientStorageManager.party.get(selectedPixelmon));
                    MoveSkill moveSkill = selected = selectedMoveSkill == null ? null : CollectionHelper.find(moveSkills, ms -> ms.skillId.equals((Object)selectedMoveSkill));
                    if (selected == null && !moveSkills.isEmpty()) {
                        selected = moveSkills.get(0);
                        selectedMoveSkill = selected.skillId;
                    }
                    if (selected != null) {
                        mc.field_71446_o.func_110577_a(selected.sprite);
                        GuiHelper.drawImageQuad(scaledWidth - 42, 2.0, 24.0, 24.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
                        double cooldownRatio = pokemon.getMoveSkillCooldownRatio(selected);
                        if (cooldownRatio != 1.0) {
                            mc.field_71446_o.func_110577_a(GuiResources.cooldown);
                            int pixels = (int)((1.0 - cooldownRatio) * 24.0);
                            GuiHelper.drawImageQuad(scaledWidth - 43, 25 - pixels, 26.0, pixels + 2, 0.0, 1.0f - (float)pixels / 24.0f, 1.0, 1.0, this.field_73735_i);
                        }
                        this.fontRenderer.func_78276_b(GameSettings.func_74298_c((int)ClientProxy.useMoveSkillKeyBind.func_151463_i()), scaledWidth - 17, 0, 0xFFFFFF);
                        this.fontRenderer.func_78276_b(GameSettings.func_74298_c((int)ClientProxy.chooseMoveSkillKey.func_151463_i()), scaledWidth - 17, 18, 0xFFFFFF);
                        String nameString = I18n.func_135052_a((String)selected.name, (Object[])new Object[0]);
                        this.fontRenderer.func_78276_b(nameString, scaledWidth - 30 - this.fontRenderer.func_78256_a(nameString) / 2, 26, 0xFFFFFF);
                    }
                }
            }
            int scaledHeight = eventResolution.func_78328_b();
            for (int icon = 0; icon < icons.size(); ++icon) {
                icons.get(icon).draw(scaledWidth - 30 - icon * 25, scaledHeight - 30, this.field_73735_i);
            }
            this.renderSpectateMessage(screenWidth, screenHeight);
        }
        this.fontRenderer.func_78264_a(false);
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
    }

    private void drawPokemonSprite(Pokemon pokemon, int yPos, Minecraft mc) {
        GuiHelper.bindPokemonSprite(pokemon, mc);
        GuiHelper.drawImageQuad(1.0, yPos - 6, 24.0, 24.0f, 0.0, 0.0, 1.0, 1.0, this.field_73735_i);
    }

    public static void selectNextPixelmon() {
        if (ClientStorageManager.party.countAll() == 0 || ClientStorageManager.party.countPokemon() == 0) {
            return;
        }
        if (++selectedPixelmon >= 6) {
            selectedPixelmon = 0;
        }
        while (ClientStorageManager.party.get(selectedPixelmon) == null || ClientStorageManager.party.get(selectedPixelmon).isEgg()) {
            if (++selectedPixelmon < 6) continue;
            selectedPixelmon = 0;
        }
    }

    public static void selectPreviousPixelmon() {
        if (ClientStorageManager.party.countAll() == 0 || ClientStorageManager.party.countPokemon() == 0) {
            return;
        }
        if (--selectedPixelmon < 0) {
            selectedPixelmon = 5;
        }
        while (ClientStorageManager.party.get(selectedPixelmon) == null || ClientStorageManager.party.get(selectedPixelmon).isEgg()) {
            if (--selectedPixelmon >= 0) continue;
            selectedPixelmon = 5;
        }
    }

    public static void checkSelection() {
        Pokemon current = ClientStorageManager.party.get(selectedPixelmon);
        if ((current == null || current.isEgg()) && !ClientProxy.battleManager.isBattling()) {
            GuiPixelmonOverlay.selectPreviousPixelmon();
        }
    }

    public static void showSpectateMessage(UUID playerUuid) {
        EntityPlayer player = Minecraft.func_71410_x().field_71441_e.func_152378_a(playerUuid);
        if (player == null) {
            return;
        }
        messageName = player.getDisplayNameString();
        uuid = playerUuid;
        fadeInTicks = 20;
    }

    public static void hideSpectateMessage(UUID playerUuid) {
        if (uuid == null) {
            fadeOutTicks = 0;
            messageName = null;
            return;
        }
        EntityPlayer player = Minecraft.func_71410_x().field_71441_e.func_152378_a(uuid);
        if (player == null) {
            fadeOutTicks = 0;
            uuid = null;
            messageName = null;
            return;
        }
        fadeOutTicks = 15;
        oldMessageName = player.getDisplayNameString();
        lastUuid = uuid;
        if (uuid.equals(playerUuid)) {
            messageName = null;
            uuid = null;
        }
    }

    private void renderSpectateMessage(int screenWidth, int screenHeight) {
        int c;
        float alpha;
        int width;
        String spectateString;
        if (messageName != null) {
            spectateString = I18n.func_135052_a((String)"gui.spectate.spectateMessage", (Object[])new Object[]{GameSettings.func_74298_c((int)ClientProxy.spectateKeyBind.func_151463_i()), messageName});
            width = this.fontRenderer.func_78256_a(spectateString);
            alpha = 1.0f - (float)fadeInTicks / 20.0f * 0.7f;
            c = GuiHelper.toColourValue(0.7f, 0.7f, 0.7f, alpha);
            this.fontRenderer.func_78276_b(spectateString, screenWidth / 2 - width / 2, screenHeight / 2 + 30, c);
        }
        if (oldMessageName != null && fadeOutTicks > 0) {
            spectateString = I18n.func_135052_a((String)"gui.spectate.spectateMessage", (Object[])new Object[]{GameSettings.func_74298_c((int)ClientProxy.spectateKeyBind.func_151463_i()), oldMessageName});
            width = this.fontRenderer.func_78256_a(spectateString);
            alpha = (float)fadeOutTicks / 15.0f * 0.7f;
            c = GuiHelper.toColourValue(0.7f, 0.7f, 0.7f, alpha);
            this.fontRenderer.func_78276_b(spectateString, screenWidth / 2 - width / 2, screenHeight / 2 + 30, c);
        }
    }

    public static void onPlayerTick() {
        if (fadeInTicks > 0) {
            --fadeInTicks;
        }
        if (fadeOutTicks > 0) {
            --fadeOutTicks;
        }
    }

    public static UUID getCurrentSpectatingUUID() {
        if (uuid != null) {
            return uuid;
        }
        if (lastUuid != null && fadeOutTicks > 0) {
            return lastUuid;
        }
        return null;
    }

    static {
        targetId = -1;
        isVisible = true;
        sideBarHeight = 200;
        count = 100;
        messageName = null;
        oldMessageName = null;
        fadeInTicks = 0;
        fadeOutTicks = 0;
    }
}

