/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.client;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.pixelmonmod.pixelmon.CommonProxy;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.trading.TradePair;
import com.pixelmonmod.pixelmon.battles.animations.particles.ParticleBreeding;
import com.pixelmonmod.pixelmon.battles.animations.particles.ParticleGastly;
import com.pixelmonmod.pixelmon.blocks.GenericModelBlock;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.blocks.multiBlocks.BlockGenericModelMultiblock;
import com.pixelmonmod.pixelmon.blocks.tileEntities.TileEntityMechanicalAnvil;
import com.pixelmonmod.pixelmon.client.PixelmonStateMapper;
import com.pixelmonmod.pixelmon.client.RenderInvisibleCamera;
import com.pixelmonmod.pixelmon.client.camera.EntityCamera;
import com.pixelmonmod.pixelmon.client.comm.ClientPacketProcessing;
import com.pixelmonmod.pixelmon.client.gui.GuiCameraOverlay;
import com.pixelmonmod.pixelmon.client.gui.GuiChatOverlay;
import com.pixelmonmod.pixelmon.client.gui.GuiDoctor;
import com.pixelmonmod.pixelmon.client.gui.GuiHealer;
import com.pixelmonmod.pixelmon.client.gui.GuiItemDrops;
import com.pixelmonmod.pixelmon.client.gui.GuiMegaItem;
import com.pixelmonmod.pixelmon.client.gui.GuiPixelmonOverlay;
import com.pixelmonmod.pixelmon.client.gui.GuiSelectStat;
import com.pixelmonmod.pixelmon.client.gui.GuiShinyCharm;
import com.pixelmonmod.pixelmon.client.gui.GuiTrading;
import com.pixelmonmod.pixelmon.client.gui.badgecase.GuiBadgecase;
import com.pixelmonmod.pixelmon.client.gui.battles.ClientBattleManager;
import com.pixelmonmod.pixelmon.client.gui.battles.GuiBattle;
import com.pixelmonmod.pixelmon.client.gui.battles.rules.GuiBattleRulesFixed;
import com.pixelmonmod.pixelmon.client.gui.battles.rules.GuiBattleRulesPlayer;
import com.pixelmonmod.pixelmon.client.gui.battles.rules.GuiTeamSelect;
import com.pixelmonmod.pixelmon.client.gui.chooseMoveset.GuiChooseMoveset;
import com.pixelmonmod.pixelmon.client.gui.custom.GuiInputScreen;
import com.pixelmonmod.pixelmon.client.gui.custom.overlays.CustomNoticeOverlay;
import com.pixelmonmod.pixelmon.client.gui.custom.overlays.CustomOverlay;
import com.pixelmonmod.pixelmon.client.gui.custom.overlays.CustomScoreboardOverlay;
import com.pixelmonmod.pixelmon.client.gui.dialogue.GuiDialogue;
import com.pixelmonmod.pixelmon.client.gui.inventory.InventoryDetectionTickHandler;
import com.pixelmonmod.pixelmon.client.gui.machines.mechanicalanvil.GuiMechanicalAnvil;
import com.pixelmonmod.pixelmon.client.gui.mail.GuiMail;
import com.pixelmonmod.pixelmon.client.gui.npc.GuiChattingNPC;
import com.pixelmonmod.pixelmon.client.gui.npc.GuiNPCTrader;
import com.pixelmonmod.pixelmon.client.gui.npc.GuiRelearner;
import com.pixelmonmod.pixelmon.client.gui.npc.GuiShopkeeper;
import com.pixelmonmod.pixelmon.client.gui.npc.GuiTutor;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.GuiChattingNPCEditor;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.GuiChooseNPC;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.GuiShopkeeperEditor;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.GuiTradeEditor;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.GuiTrainerEditor;
import com.pixelmonmod.pixelmon.client.gui.npcEditor.GuiTutorEditor;
import com.pixelmonmod.pixelmon.client.gui.pc.GuiPC;
import com.pixelmonmod.pixelmon.client.gui.pokedex.GuiPokedex;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.GuiEditedPlayer;
import com.pixelmonmod.pixelmon.client.gui.pokemoneditor.GuiPokemonEditorParty;
import com.pixelmonmod.pixelmon.client.gui.ranchblock.GuiExtendRanch;
import com.pixelmonmod.pixelmon.client.gui.ranchblock.GuiRanchBlock;
import com.pixelmonmod.pixelmon.client.gui.selectMove.SelectMoveScreen;
import com.pixelmonmod.pixelmon.client.gui.spawner.GuiPixelmonSpawner;
import com.pixelmonmod.pixelmon.client.gui.starter.GuiChooseStarter;
import com.pixelmonmod.pixelmon.client.gui.statueEditor.GuiStatueEditor;
import com.pixelmonmod.pixelmon.client.gui.vendingmachine.GuiVendingMachine;
import com.pixelmonmod.pixelmon.client.keybindings.ActionKey;
import com.pixelmonmod.pixelmon.client.keybindings.ChooseMoveSkillKey;
import com.pixelmonmod.pixelmon.client.keybindings.Descend;
import com.pixelmonmod.pixelmon.client.keybindings.MinimizeMaximizeOverlayKey;
import com.pixelmonmod.pixelmon.client.keybindings.MovementHandler;
import com.pixelmonmod.pixelmon.client.keybindings.NextPokemonKey;
import com.pixelmonmod.pixelmon.client.keybindings.OptionsKey;
import com.pixelmonmod.pixelmon.client.keybindings.PixelmonMouseHelper;
import com.pixelmonmod.pixelmon.client.keybindings.PokedexKey;
import com.pixelmonmod.pixelmon.client.keybindings.PreviousPokemonKey;
import com.pixelmonmod.pixelmon.client.keybindings.SendPokemonKey;
import com.pixelmonmod.pixelmon.client.keybindings.SpectateKey;
import com.pixelmonmod.pixelmon.client.keybindings.TrainerCardKey;
import com.pixelmonmod.pixelmon.client.keybindings.UseMoveSkillKey;
import com.pixelmonmod.pixelmon.client.keybindings.WikiKey;
import com.pixelmonmod.pixelmon.client.listener.MouseOverPlayer;
import com.pixelmonmod.pixelmon.client.listener.UnderWaterFog;
import com.pixelmonmod.pixelmon.client.listener.WallpapersListener;
import com.pixelmonmod.pixelmon.client.models.items.ItemPixelmonSpriteModel;
import com.pixelmonmod.pixelmon.client.particle.ParticleEvents;
import com.pixelmonmod.pixelmon.client.render.ParticleBlocks;
import com.pixelmonmod.pixelmon.client.render.RenderBike;
import com.pixelmonmod.pixelmon.client.render.RenderBreeding;
import com.pixelmonmod.pixelmon.client.render.RenderHook;
import com.pixelmonmod.pixelmon.client.render.RenderNPC;
import com.pixelmonmod.pixelmon.client.render.RenderPixelmon;
import com.pixelmonmod.pixelmon.client.render.RenderPokeball;
import com.pixelmonmod.pixelmon.client.render.RenderStatue;
import com.pixelmonmod.pixelmon.client.render.blockReveal.BlockRevealRenderer;
import com.pixelmonmod.pixelmon.client.render.custom.RenderPixelmonPainting;
import com.pixelmonmod.pixelmon.client.render.item.ItemRendererShrineOrb;
import com.pixelmonmod.pixelmon.client.render.layers.LayerHat;
import com.pixelmonmod.pixelmon.client.render.layers.LayerMegaItems;
import com.pixelmonmod.pixelmon.client.render.layers.LayerRobe;
import com.pixelmonmod.pixelmon.client.render.layers.LayerSash;
import com.pixelmonmod.pixelmon.client.render.player.PixelRenderPlayer;
import com.pixelmonmod.pixelmon.client.render.player.RenderEvents;
import com.pixelmonmod.pixelmon.client.render.tileEntities.RanchBlockHighlightRender;
import com.pixelmonmod.pixelmon.client.storage.ClientStorageManager;
import com.pixelmonmod.pixelmon.commands.client.RedeemCommand;
import com.pixelmonmod.pixelmon.config.PixelmonBlocks;
import com.pixelmonmod.pixelmon.config.PixelmonBlocksApricornTrees;
import com.pixelmonmod.pixelmon.config.PixelmonItemsLures;
import com.pixelmonmod.pixelmon.config.TileEntityRegistry;
import com.pixelmonmod.pixelmon.entities.EntityWormhole;
import com.pixelmonmod.pixelmon.entities.bikes.EntityBike;
import com.pixelmonmod.pixelmon.entities.custom.EntityPixelmonPainting;
import com.pixelmonmod.pixelmon.entities.npcs.NPCChatting;
import com.pixelmonmod.pixelmon.entities.npcs.NPCNurseJoy;
import com.pixelmonmod.pixelmon.entities.npcs.NPCRelearner;
import com.pixelmonmod.pixelmon.entities.npcs.NPCShopkeeper;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrader;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTutor;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityBreeding;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityStatue;
import com.pixelmonmod.pixelmon.entities.pokeballs.EntityPokeBall;
import com.pixelmonmod.pixelmon.entities.projectiles.EntityHook;
import com.pixelmonmod.pixelmon.enums.EnumBreedingParticles;
import com.pixelmonmod.pixelmon.enums.EnumGuiContainer;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.EnumPixelmonParticles;
import com.pixelmonmod.pixelmon.enums.items.EnumBadgecases;
import com.pixelmonmod.pixelmon.listener.ClientNetworkListener;
import com.pixelmonmod.pixelmon.storage.extras.PlayerExtraDataStore;
import com.pixelmonmod.pixelmon.util.helpers.RCFileHelper;
import com.pixelmonmod.pixelmon.worldGeneration.dimension.ultraspace.wormhole.RenderWormhole;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class ClientProxy
extends CommonProxy {
    public static ClientBattleManager battleManager = new ClientBattleManager();
    public static ArrayList<MoveSkill> moveSkills = new ArrayList();
    public static TradePair currentTradePair = null;
    public static boolean playerHasTradeRequestPokemon = false;
    public static PixelmonMouseHelper mouseHelper = new PixelmonMouseHelper();
    public static EntityCamera camera;
    public static ActionKey actionKeyBind;
    public static UseMoveSkillKey useMoveSkillKeyBind;
    public static ChooseMoveSkillKey chooseMoveSkillKey;
    public static PokedexKey pokedexKeyBind;
    public static TrainerCardKey trainerCardKeyBind;
    public static WikiKey wikiKeyBind;
    public static SpectateKey spectateKeyBind;
    public static KeyBinding pcSearchKeyBind;
    public static KeyBinding pcRenameKeyBind;
    public static KeyBinding pcWallpaperKeyBind;
    ClientPacketProcessing cpp = new ClientPacketProcessing();
    static ConcurrentHashMap<String, ResourceLocation> cachedSkins;
    static List<String> invaildSkins;

    @Override
    public void preInit() {
        super.preInit();
        this.addPokemonRenderers();
        MinecraftForge.EVENT_BUS.register((Object)new ParticleEvents());
    }

    @Override
    public void init() {
        super.init();
        MinecraftForge.EVENT_BUS.register(GuiCameraOverlay.class);
        MinecraftForge.EVENT_BUS.register(ClientNetworkListener.class);
        PlayerExtraDataStore.loadClientData();
        Minecraft.func_71410_x().field_71417_B = mouseHelper;
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)new WallpapersListener());
    }

    @Override
    public void postInit() {
        super.postInit();
        PixelmonItemsLures.registerItemLayers();
    }

    @Override
    public void registerBlockModels() {
        PixelmonBlocks.registerModels();
    }

    @Override
    public void registerRenderers() {
        TileEntityRegistry.registerRenderers();
        MinecraftForge.EVENT_BUS.register((Object)new CustomOverlay());
        MinecraftForge.EVENT_BUS.register((Object)new GuiPixelmonOverlay());
        MinecraftForge.EVENT_BUS.register((Object)new GuiChatOverlay(Minecraft.func_71410_x()));
        MinecraftForge.EVENT_BUS.register((Object)new UnderWaterFog());
        MinecraftForge.EVENT_BUS.register((Object)new RanchBlockHighlightRender());
        MinecraftForge.EVENT_BUS.register((Object)new MouseOverPlayer());
        MinecraftForge.EVENT_BUS.register((Object)new RenderEvents());
        MinecraftForge.EVENT_BUS.register((Object)new BlockRevealRenderer());
        RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        renderManager.field_178636_l.remove("default");
        renderManager.field_178636_l.remove("slim");
        renderManager.field_178636_l.put("default", new PixelRenderPlayer(renderManager));
        renderManager.field_178636_l.put("slim", new PixelRenderPlayer(renderManager, true));
        RenderPlayer rp = (RenderPlayer)renderManager.field_178636_l.get("default");
        rp.func_177094_a((LayerRenderer)new LayerHat(rp));
        rp.func_177094_a((LayerRenderer)new LayerSash(rp));
        rp.func_177094_a((LayerRenderer)new LayerRobe(rp));
        rp.func_177094_a((LayerRenderer)new LayerMegaItems(rp));
        rp = (RenderPlayer)renderManager.field_178636_l.get("slim");
        rp.func_177094_a((LayerRenderer)new LayerHat(rp));
        rp.func_177094_a((LayerRenderer)new LayerSash(rp));
        rp.func_177094_a((LayerRenderer)new LayerRobe(rp));
        rp.func_177094_a((LayerRenderer)new LayerMegaItems(rp));
    }

    @SubscribeEvent
    public void onModelBakeEvent(ModelBakeEvent event) {
        this.bakeOrb(event, ItemRendererShrineOrb.uno);
        this.bakeOrb(event, ItemRendererShrineOrb.dos);
        this.bakeOrb(event, ItemRendererShrineOrb.tres);
        this.bakePixelmonSprites(event);
    }

    private void bakePixelmonSprites(ModelBakeEvent event) {
        IBakedModel existingModel = (IBakedModel)event.getModelRegistry().func_82594_a((Object)ItemPixelmonSpriteModel.modelResourceLocation);
        if (existingModel != null) {
            ItemPixelmonSpriteModel customModel = new ItemPixelmonSpriteModel(existingModel);
            event.getModelRegistry().func_82595_a((Object)ItemPixelmonSpriteModel.modelResourceLocation, (Object)customModel);
        }
    }

    private void bakeOrb(ModelBakeEvent event, ModelResourceLocation resourceLocation) {
        Object resource = event.getModelRegistry().func_82594_a((Object)resourceLocation);
        if (resource != null) {
            IBakedModel existingModel = (IBakedModel)resource;
            ItemRendererShrineOrb customModel = new ItemRendererShrineOrb(existingModel);
            event.getModelRegistry().func_82595_a((Object)resourceLocation, (Object)customModel);
        }
    }

    @SubscribeEvent
    public void stitcherEventPre(TextureStitchEvent.Pre event) {
        event.getMap().func_174942_a(new ResourceLocation("pixelmon:items/back"));
        event.getMap().func_174942_a(new ResourceLocation("pixelmon:items/front"));
        event.getMap().func_174942_a(new ResourceLocation("pixelmon:items/unoorb"));
        event.getMap().func_174942_a(new ResourceLocation("pixelmon:items/dosorb"));
        event.getMap().func_174942_a(new ResourceLocation("pixelmon:items/tresorb"));
        this.loadImagesToAtlas("sprites/eggs", event);
        this.loadImagesToAtlas("sprites/pokemon", event);
        this.loadImagesToAtlas("sprites/shinypokemon", event);
    }

    public void loadImagesToAtlas(String textureSubDir, TextureStitchEvent.Pre event) {
        try {
            Path path = RCFileHelper.pathFromResourceLocation(new ResourceLocation("pixelmon", "textures/" + textureSubDir));
            List<Path> pngPaths = RCFileHelper.listFilesRecursively(path, entry -> entry.getFileName().toString().endsWith(".png"), false);
            for (Path pngPath : pngPaths) {
                String fileName = pngPath.getFileName().toString();
                event.getMap().func_174942_a(new ResourceLocation("pixelmon", textureSubDir + "/" + fileName.substring(0, fileName.length() - 4)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void fixModelDefs() {
        Block block;
        PixelmonStateMapper pixelmonStateMapper = new PixelmonStateMapper();
        ModelLoader.setCustomStateMapper((Block)PixelmonBlocks.hiddenIronDoor, (IStateMapper)pixelmonStateMapper);
        ModelLoader.setCustomStateMapper((Block)PixelmonBlocks.hiddenWoodenDoor, (IStateMapper)pixelmonStateMapper);
        ModelLoader.setCustomStateMapper((Block)PixelmonBlocks.masterChest, (IStateMapper)pixelmonStateMapper);
        ModelLoader.setCustomStateMapper((Block)PixelmonBlocks.pokeChest, (IStateMapper)pixelmonStateMapper);
        ModelLoader.setCustomStateMapper((Block)PixelmonBlocks.ultraChest, (IStateMapper)pixelmonStateMapper);
        ModelLoader.setCustomStateMapper((Block)PixelmonBlocks.beastChest, (IStateMapper)pixelmonStateMapper);
        ModelLoader.setCustomStateMapper((Block)PixelmonBlocks.mechanicalAnvil, (IStateMapper)pixelmonStateMapper);
        ModelLoader.setCustomStateMapper((Block)PixelmonBlocks.hiddenPressurePlate, (IStateMapper)pixelmonStateMapper);
        for (Field field : PixelmonBlocks.class.getFields()) {
            try {
                if (!(field.get(null) instanceof Block) || ((block = (Block)field.get(null)) == null || !(block instanceof MultiBlock)) && block.func_149645_b(block.func_176223_P()) != EnumBlockRenderType.INVISIBLE && !(block instanceof GenericModelBlock) && !(block instanceof BlockGenericModelMultiblock)) continue;
                ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)pixelmonStateMapper);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        for (Field field : PixelmonBlocksApricornTrees.class.getFields()) {
            try {
                if (!(field.get(null) instanceof Block) || ((block = (Block)field.get(null)) == null || !(block instanceof MultiBlock)) && block.func_149645_b(block.func_176223_P()) != EnumBlockRenderType.MODEL) continue;
                ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)pixelmonStateMapper);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void registerKeyBindings() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        SendPokemonKey k1 = new SendPokemonKey();
        ClientRegistry.registerKeyBinding((KeyBinding)k1);
        MinecraftForge.EVENT_BUS.register((Object)k1);
        NextPokemonKey k2 = new NextPokemonKey();
        ClientRegistry.registerKeyBinding((KeyBinding)k2);
        MinecraftForge.EVENT_BUS.register((Object)k2);
        PreviousPokemonKey k3 = new PreviousPokemonKey();
        ClientRegistry.registerKeyBinding((KeyBinding)k3);
        MinecraftForge.EVENT_BUS.register((Object)k3);
        MinimizeMaximizeOverlayKey k4 = new MinimizeMaximizeOverlayKey();
        ClientRegistry.registerKeyBinding((KeyBinding)k4);
        MinecraftForge.EVENT_BUS.register((Object)k4);
        Descend k5 = new Descend();
        ClientRegistry.registerKeyBinding((KeyBinding)k5);
        MinecraftForge.EVENT_BUS.register((Object)k5);
        spectateKeyBind = new SpectateKey();
        ClientRegistry.registerKeyBinding((KeyBinding)spectateKeyBind);
        MinecraftForge.EVENT_BUS.register((Object)spectateKeyBind);
        actionKeyBind = new ActionKey();
        ClientRegistry.registerKeyBinding((KeyBinding)actionKeyBind);
        MinecraftForge.EVENT_BUS.register((Object)actionKeyBind);
        useMoveSkillKeyBind = new UseMoveSkillKey();
        ClientRegistry.registerKeyBinding((KeyBinding)useMoveSkillKeyBind);
        MinecraftForge.EVENT_BUS.register((Object)useMoveSkillKeyBind);
        chooseMoveSkillKey = new ChooseMoveSkillKey();
        ClientRegistry.registerKeyBinding((KeyBinding)chooseMoveSkillKey);
        MinecraftForge.EVENT_BUS.register((Object)chooseMoveSkillKey);
        pokedexKeyBind = new PokedexKey();
        ClientRegistry.registerKeyBinding((KeyBinding)pokedexKeyBind);
        MinecraftForge.EVENT_BUS.register((Object)pokedexKeyBind);
        trainerCardKeyBind = new TrainerCardKey();
        ClientRegistry.registerKeyBinding((KeyBinding)trainerCardKeyBind);
        MinecraftForge.EVENT_BUS.register((Object)trainerCardKeyBind);
        wikiKeyBind = new WikiKey();
        ClientRegistry.registerKeyBinding((KeyBinding)wikiKeyBind);
        MinecraftForge.EVENT_BUS.register((Object)wikiKeyBind);
        pcSearchKeyBind = new KeyBinding("key.pcsearch", 31, "key.categories.pixelmon");
        ClientRegistry.registerKeyBinding((KeyBinding)pcSearchKeyBind);
        pcRenameKeyBind = new KeyBinding("key.pcrename", 19, "key.categories.pixelmon");
        ClientRegistry.registerKeyBinding((KeyBinding)pcRenameKeyBind);
        pcWallpaperKeyBind = new KeyBinding("key.pcwallpaper", 17, "key.categories.pixelmon");
        ClientRegistry.registerKeyBinding((KeyBinding)pcWallpaperKeyBind);
        MinecraftForge.EVENT_BUS.register(MovementHandler.class);
        OptionsKey k6 = new OptionsKey();
        ClientRegistry.registerKeyBinding((KeyBinding)k6);
        MinecraftForge.EVENT_BUS.register((Object)k6);
    }

    @Override
    public void registerCommands() {
        ClientCommandHandler.instance.func_71560_a((ICommand)new RedeemCommand());
    }

    private void addPokemonRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityPokeBall.class, RenderPokeball::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityHook.class, RenderHook::new);
        RenderingRegistry.registerEntityRenderingHandler(NPCTrainer.class, RenderNPC::new);
        RenderingRegistry.registerEntityRenderingHandler(NPCChatting.class, RenderNPC::new);
        RenderingRegistry.registerEntityRenderingHandler(NPCTrader.class, RenderNPC::new);
        RenderingRegistry.registerEntityRenderingHandler(NPCRelearner.class, RenderNPC::new);
        RenderingRegistry.registerEntityRenderingHandler(NPCTutor.class, RenderNPC::new);
        RenderingRegistry.registerEntityRenderingHandler(NPCNurseJoy.class, RenderNPC::new);
        RenderingRegistry.registerEntityRenderingHandler(NPCShopkeeper.class, RenderNPC::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityStatue.class, RenderStatue::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityPixelmon.class, RenderPixelmon::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityBreeding.class, RenderBreeding::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityCamera.class, RenderInvisibleCamera::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityWormhole.class, RenderWormhole::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityBike.class, RenderBike::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityPixelmonPainting.class, RenderPixelmonPainting::new);
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        EnumGuiContainer container = EnumGuiContainer.getFromOrdinal(ID);
        if (container == null) {
            return null;
        }
        if (!Minecraft.func_71410_x().func_152345_ab()) {
            System.out.println("Dodgy gui call from non-main thread for " + (Object)((Object)container));
        }
        switch (container) {
            case MechanicalAnvil: {
                return new GuiMechanicalAnvil(player.field_71071_by, (TileEntityMechanicalAnvil)world.func_175625_s(new BlockPos(x, y, z)));
            }
        }
        return null;
    }

    public static GuiScreen createScreen(EntityPlayer player, EnumGuiScreen gui, int[] data) {
        switch (gui) {
            case ChooseStarter: {
                return new GuiChooseStarter();
            }
            case Dialogue: {
                return new GuiDialogue();
            }
            case Healer: {
                return new GuiHealer();
            }
            case Pokedex: {
                return new GuiPokedex(data[0]);
            }
            case PC: {
                return new GuiPC();
            }
            case ChooseRelearnMove: 
            case ChooseTutor: 
            case Battle: {
                return new GuiBattle();
            }
            case Trading: {
                return new GuiTrading(data[0], data[1], data[2]);
            }
            case Doctor: {
                return new GuiDoctor();
            }
            case ItemDrops: {
                return new GuiItemDrops();
            }
            case PixelmonSpawner: {
                return new GuiPixelmonSpawner(data[0], data[1], data[2]);
            }
            case TrainerEditor: {
                return new GuiTrainerEditor(data[0]);
            }
            case ChooseMoveset: {
                return new GuiChooseMoveset(ClientStorageManager.party.get(data[0]));
            }
            case RanchBlock: {
                return new GuiRanchBlock(player.field_70170_p, data[0], data[1], data[2]);
            }
            case NPCTrade: {
                return new GuiTradeEditor(data[0]);
            }
            case NPCTraderGui: {
                return new GuiNPCTrader(data[0]);
            }
            case StatueEditor: {
                return new GuiStatueEditor(data[0]);
            }
            case ExtendRanch: {
                return new GuiExtendRanch(player.field_70170_p, data[0], data[1], data[2]);
            }
            case InputScreen: {
                return new GuiInputScreen();
            }
            case SelectNPCType: {
                return new GuiChooseNPC(new BlockPos(data[0], data[1], data[2]));
            }
            case NPCChatEditor: {
                return new GuiChattingNPCEditor(data[0]);
            }
            case NPCChat: {
                return new GuiChattingNPC(data[0]);
            }
            case Relearner: {
                return new GuiRelearner(ClientStorageManager.party.get(data[0]));
            }
            case Tutor: {
                return new GuiTutor(ClientStorageManager.party.get(data[0]));
            }
            case TutorEditor: {
                return new GuiTutorEditor(data[0]);
            }
            case HealerNurseJoy: {
                return new GuiHealer(data[0]);
            }
            case Shopkeeper: {
                return new GuiShopkeeper(data[0]);
            }
            case ShopkeeperEditor: {
                return new GuiShopkeeperEditor(data[0]);
            }
            case VendingMachine: {
                return new GuiVendingMachine(new BlockPos(data[0], data[1], data[2]));
            }
            case PokemonEditor: {
                return new GuiPokemonEditorParty();
            }
            case EditedPlayer: {
                return new GuiEditedPlayer();
            }
            case MegaItem: {
                return new GuiMegaItem();
            }
            case BattleRulesPlayer: {
                return new GuiBattleRulesPlayer(data[0], data[1] == 1);
            }
            case BattleRulesFixed: {
                return new GuiBattleRulesFixed();
            }
            case TeamSelect: {
                return new GuiTeamSelect();
            }
            case Mail: {
                return new GuiMail(player.func_184586_b(EnumHand.values()[data[0]]));
            }
            case Badgecase: {
                return new GuiBadgecase(player.func_184586_b(EnumHand.values()[data[0]]), EnumBadgecases.values()[data[1]]);
            }
            case SelectMove: {
                return new SelectMoveScreen(data[0], data[1]);
            }
            case ShinyCharm: {
                return new GuiShinyCharm();
            }
            case BottleCap: {
                return new GuiSelectStat(data);
            }
        }
        return null;
    }

    public static File getMinecraftDir() {
        return Minecraft.func_71410_x().field_71412_D;
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        CustomNoticeOverlay.resetNotice();
        CustomScoreboardOverlay.resetBoard();
    }

    @SubscribeEvent
    public void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        ClientProxy.battleManager.battleEnded = true;
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        Pixelmon.freeze = false;
        CustomNoticeOverlay.resetNotice();
        CustomScoreboardOverlay.resetBoard();
    }

    public static void spawnParticle(World w, double d1, double d2, double d3, Block stone) {
        ParticleBlocks fx = new ParticleBlocks(w, d1, d2, d3, 0.0, 0.0, 0.0, w.func_180495_p(new BlockPos(d1, d2, d3)));
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((Particle)fx);
    }

    public static void spawnParticle(EnumPixelmonParticles particle, World worldObj, double posX, double posY, double posZ, boolean isShiny) {
        try {
            ParticleGastly fx = particle.particleClass == ParticleGastly.class ? new ParticleGastly(worldObj, posX, posY, posZ, 0.0, 0.0, 0.0, isShiny) : particle.particleClass.getConstructor(World.class, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE).newInstance(worldObj, posX, posY, posZ, 0.0, 0.0, 0.0);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void spawnParticle(EnumBreedingParticles particle, World worldObj, double posX, double posY, double posZ, boolean isShiny) {
        try {
            ParticleBreeding fx = new ParticleBreeding(worldObj, posX, posY, posZ, 0.0, 0.0, 0.0, particle);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void registerTickHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)new InventoryDetectionTickHandler());
        MinecraftForge.EVENT_BUS.register((Object)battleManager);
    }

    @Override
    public ClientPacketProcessing getClientPacketProcessor() {
        return this.cpp;
    }

    public static ResourceLocation bindPlayerTexture(String username) {
        if (username.isEmpty() || invaildSkins.contains(username)) {
            return DefaultPlayerSkin.func_177335_a();
        }
        if (cachedSkins.containsKey(username)) {
            return cachedSkins.get(username);
        }
        GameProfile profile = new GameProfile(null, username);
        if ((profile = TileEntitySkull.func_174884_b((GameProfile)profile)).isComplete() && profile.getId().version() == 4 && profile.getProperties().containsKey((Object)"textures")) {
            ResourceLocation resourcelocation;
            Minecraft minecraft = Minecraft.func_71410_x();
            Map map = minecraft.func_152342_ad().func_152788_a(profile);
            if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                resourcelocation = minecraft.func_152342_ad().func_152792_a((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN);
                cachedSkins.put(username, resourcelocation);
            } else {
                resourcelocation = DefaultPlayerSkin.func_177335_a();
            }
            return resourcelocation;
        }
        invaildSkins.add(username);
        return DefaultPlayerSkin.func_177335_a();
    }

    @Override
    public boolean resourceLocationExists(ResourceLocation resourceLocation) {
        try {
            return Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation).func_110527_b() != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public BufferedInputStream getStreamForResourceLocation(ResourceLocation resourceLocation) {
        try {
            return new BufferedInputStream(Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation).func_110527_b());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void resetMouseOver() {
        Minecraft.func_71410_x().field_71476_x = null;
    }

    public static void spawnBoostedTreeParticles(World worldObj, int x, int y, int z, int stage) {
        for (int i = 0; i < 20; ++i) {
            float yplus = worldObj.field_73012_v.nextFloat();
            if (stage <= 3) {
                yplus *= 2.0f;
            }
            ClientProxy.spawnParticle(EnumPixelmonParticles.shiny, worldObj, (double)((float)x + worldObj.field_73012_v.nextFloat()), (double)((float)y + yplus), (double)((float)z + worldObj.field_73012_v.nextFloat()), true);
        }
    }

    @Override
    public List<MoveSkill> loadDefaultMoveSkills() {
        moveSkills = new ArrayList();
        List<MoveSkill> s = super.loadDefaultMoveSkills();
        moveSkills.addAll(s);
        return s;
    }

    public static ArrayList<MoveSkill> getMoveSkills(Pokemon pokemon) {
        ClientProxy cfr_ignored_0 = (ClientProxy)Pixelmon.proxy;
        ArrayList moveSkills = Lists.newArrayList(ClientProxy.moveSkills);
        moveSkills.removeIf(moveSkill -> !moveSkill.hasMoveSkill(pokemon));
        return moveSkills;
    }

    static {
        cachedSkins = new ConcurrentHashMap();
        invaildSkins = Lists.newArrayList();
    }
}

