/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.status.Burn;
import com.pixelmonmod.pixelmon.battles.status.Freeze;
import com.pixelmonmod.pixelmon.battles.status.Paralysis;
import com.pixelmonmod.pixelmon.battles.status.Poison;
import com.pixelmonmod.pixelmon.battles.status.PoisonBadly;
import com.pixelmonmod.pixelmon.battles.status.Sleep;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import java.util.HashMap;
import java.util.Map;

public enum StatusType {
    Burn,
    Confusion,
    Cursed,
    Infatuated,
    Flee,
    Flinch,
    Flying,
    Freeze,
    Leech,
    LightScreen,
    Mist,
    Paralysis,
    Poison,
    PoisonBadly,
    Protect,
    SafeGuard,
    Sleep,
    SmackedDown,
    Substitute,
    Sunny,
    Wait,
    TrickRoom,
    Perish,
    Yawn,
    Disable,
    Immobilize,
    Recharge,
    AquaRing,
    UnderGround,
    Transformed,
    MeanLook,
    FutureSight,
    MagnetRise,
    Spikes,
    ToxicSpikes,
    StealthRock,
    PartialTrap,
    Reflect,
    Submerged,
    Raging,
    Telekinesis,
    Tailwind,
    DestinyBond,
    Taunt,
    TempMoveset,
    HealingWish,
    Roosting,
    Wish,
    Encore,
    Focus,
    MagicCoat,
    Ingrain,
    Stockpile,
    Snatch,
    Minimize,
    Gravity,
    Hail,
    Rainy,
    Sandstorm,
    Torment,
    Foresight,
    GastroAcid,
    GuardSplit,
    PowerSplit,
    WonderRoom,
    LockOn,
    Endure,
    WideGuard,
    Charge,
    Nightmare,
    MeFirst,
    PowerTrick,
    Autotomize,
    DefenseCurl,
    SkyDropping,
    SkyDropped,
    FollowMe,
    Imprison,
    HealBlock,
    MudSport,
    WaterSport,
    FirePledge,
    GrassPledge,
    WaterPledge,
    HelpingHand,
    QuickGuard,
    Embargo,
    Grudge,
    LuckyChant,
    MagicRoom,
    LunarDance,
    Vanish,
    MultiTurn,
    Bide,
    Uproar,
    EchoedVoice,
    FuryCutter,
    DarkAura,
    FairyAura,
    CraftyShield,
    None,
    ElectricTerrain,
    Electrify,
    FairyLock,
    GrassyTerrain,
    IonDeluge,
    KingsShield,
    BanefulBunker,
    MatBlock,
    MistyTerrain,
    Powder,
    SpikyShield,
    StickyWeb,
    PsychicTerrain,
    MysteriousAirCurrent,
    AuroraVeil,
    BeakBlast,
    SpeedSwap;

    static Map<StatusType, StatusPersist> restoreStatusList;

    public boolean isStatus(StatusType ... statuses) {
        for (StatusType status : statuses) {
            if (this != status) continue;
            return true;
        }
        return false;
    }

    public static StatusType getStatusEffect(String string) {
        for (StatusType t : StatusType.values()) {
            if (!t.toString().equalsIgnoreCase(string)) continue;
            return t;
        }
        return null;
    }

    public static boolean isStatusEffect(String string) {
        return StatusType.getStatusEffect(string) != null;
    }

    public static StatusType getEffect(int integer) {
        StatusType[] statuses = StatusType.values();
        if (integer >= 0 && integer < statuses.length) {
            return statuses[integer];
        }
        return null;
    }

    public static StatusPersist getEffectInstance(int integer) {
        StatusType type = StatusType.getEffect(integer);
        if (type != null) {
            return restoreStatusList.get((Object)type);
        }
        return null;
    }

    public static boolean isPrimaryStatus(StatusType status) {
        return status.isStatus(Poison, Burn, PoisonBadly, Freeze, Sleep, Paralysis);
    }

    public boolean isPrimaryStatus() {
        return StatusType.isPrimaryStatus(this);
    }

    public static float[] getTexturePos(StatusType type) {
        if (type == Burn) {
            return new float[]{1.0f, 1.0f};
        }
        if (type == Freeze) {
            return new float[]{1.0f, 72.0f};
        }
        if (type == Paralysis) {
            return new float[]{152.0f, 1.0f};
        }
        if (type == Poison || type == PoisonBadly) {
            return new float[]{152.0f, 72.0f};
        }
        if (type == Sleep) {
            return new float[]{152.0f, 142.0f};
        }
        return new float[]{-1.0f, -1.0f};
    }

    static {
        restoreStatusList = new HashMap<StatusType, StatusPersist>(6);
        restoreStatusList.put(Burn, new Burn());
        restoreStatusList.put(Freeze, new Freeze());
        restoreStatusList.put(Paralysis, new Paralysis());
        restoreStatusList.put(Poison, new Poison());
        restoreStatusList.put(PoisonBadly, new PoisonBadly());
        restoreStatusList.put(Sleep, new Sleep());
    }
}

