/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.DamageTypeEnum;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusPersist;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.AbilityBase;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Guts;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.MagicGuard;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.MarvelScale;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.PoisonHeal;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.QuickFeet;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Synchronize;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.ToxicBoost;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.battle.AttackCategory;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextComponentTranslation;

public class Poison
extends StatusPersist {
    private static final transient float AI_WEIGHT = 25.0f;

    public Poison() {
        this(StatusType.Poison);
    }

    public Poison(StatusType type) {
        super(type);
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        if (this.checkChance()) {
            Poison.poison(user, target, user.attack, true);
        }
    }

    public static boolean poison(PixelmonWrapper user, PixelmonWrapper target, Attack attack, boolean showMessage) {
        if (Poison.canPoison(user, target, attack, showMessage)) {
            boolean result;
            TextComponentTranslation message = null;
            if (showMessage) {
                message = ChatHandler.getMessage("pixelmon.effect.poisoned", target.getNickname());
            }
            if (!(result = target.addStatus(new Poison(), user, message)) && attack != null && attack.getAttackCategory() == AttackCategory.STATUS) {
                user.setAttackFailed();
            }
            return result;
        }
        return false;
    }

    public static boolean canPoison(PixelmonWrapper user, PixelmonWrapper target, Attack attack, boolean showMessage) {
        boolean isStatusMove;
        boolean bl = isStatusMove = attack != null && attack.getAttackCategory() == AttackCategory.STATUS;
        if (target.hasStatus(StatusType.Poison) || target.hasStatus(StatusType.PoisonBadly)) {
            if (showMessage && isStatusMove) {
                user.bc.sendToAll("pixelmon.effect.alreadypoisoned", target.getNickname());
                user.setAttackFailed();
            }
            return false;
        }
        if (target.hasType(EnumType.Poison, EnumType.Steel)) {
            if (showMessage && isStatusMove) {
                user.bc.sendToAll("pixelmon.battletext.noeffect", target.getNickname());
                user.setAttackFailed();
            }
            return false;
        }
        if (target.hasPrimaryStatus()) {
            if (showMessage && isStatusMove) {
                user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
                user.setAttackFailed();
            }
            return false;
        }
        return true;
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        AbilityBase ability = pw.getBattleAbility();
        if (ability instanceof MagicGuard) {
            return;
        }
        if (ability instanceof PoisonHeal) {
            if (pw.hasFullHealth() || pw.hasStatus(StatusType.HealBlock)) {
                return;
            }
            pw.bc.sendToAll("pixelmon.abilities.poisonheal", pw.getNickname());
            pw.healByPercent(12.5f);
        } else {
            pw.bc.sendToAll("pixelmon.status.hurtbypoison", pw.getNickname());
            pw.doBattleDamage(pw, this.getPoisonDamage(pw), DamageTypeEnum.STATUS);
        }
    }

    protected float getPoisonDamage(PixelmonWrapper pw) {
        return pw.getPercentMaxHealth(12.5f);
    }

    @Override
    public StatusPersist restoreFromNBT(NBTTagCompound nbt) {
        return new Poison();
    }

    @Override
    public boolean isImmune(PixelmonWrapper pokemon) {
        return pokemon.hasType(EnumType.Poison, EnumType.Steel);
    }

    @Override
    public String getCureMessage() {
        return "pixelmon.status.poisoncure";
    }

    @Override
    public String getCureMessageItem() {
        return "pixelmon.status.poisoncureitem";
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        boolean offensive = userChoice.isOffensiveMove();
        float weight = this.getWeightWithChance(25.0f);
        if (!offensive || userChoice.isMiddleTier()) {
            boolean hitsAlly = userChoice.hitsAlly();
            if (offensive && hitsAlly) {
                return;
            }
            for (PixelmonWrapper target : userChoice.targets) {
                boolean beneficial;
                AbilityBase ability = target.getBattleAbility();
                boolean bl = beneficial = ability instanceof Guts || ability instanceof MarvelScale || ability instanceof PoisonHeal || ability instanceof QuickFeet || ability instanceof ToxicBoost || Attack.hasAttack(pw.getBattleAI().getMoveset(target), "Facade");
                if (beneficial && hitsAlly) {
                    userChoice.raiseWeight(weight);
                    continue;
                }
                if (beneficial ^ hitsAlly) {
                    userChoice.raiseWeight(-weight);
                    continue;
                }
                if (ability instanceof MagicGuard || ability instanceof Synchronize) continue;
                userChoice.raiseWeight(weight);
            }
        }
    }
}

