/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.status;

import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.StatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Overcoat;
import java.util.ArrayList;

public class FollowMe
extends StatusBase {
    private transient boolean isPowder;

    public FollowMe() {
        this(false);
    }

    public FollowMe(boolean isPowder) {
        super(StatusType.FollowMe);
        this.isPowder = isPowder;
    }

    @Override
    public void applyEffect(PixelmonWrapper user, PixelmonWrapper target) {
        user.bc.sendToAll("pixelmon.status.followme", user.getNickname());
        user.addStatus(new FollowMe(Overcoat.isPowderMove(user.attack)), user);
    }

    @Override
    public boolean redirectAttack(PixelmonWrapper user, PixelmonWrapper targetAlly, Attack attack) {
        return attack.getMove().getTargetingInfo().hitsAdjacentFoe && (!this.isPowder || !user.isImmuneToPowder()) && !attack.isAttack("Bide", "Bounce", "Dig", "Dive", "Fly", "Freeze Shock", "Ice Burn", "Phantom Force", "Razor Wind", "Shadow Force", "Skull Bash", "Sky attack", "Sky Drop", "SolarBeam");
    }

    @Override
    public void applyRepeatedEffect(PixelmonWrapper pw) {
        pw.removeStatus(this);
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        if (pw.bc.rules.battleType.numPokemon == 1) {
            return;
        }
        for (PixelmonWrapper ally : pw.getTeamPokemonExcludeSelf()) {
            if (MoveChoice.hasSpreadMove(bestOpponentChoices) || MoveChoice.getTargetedChoices(ally, bestOpponentChoices).isEmpty()) continue;
            userChoice.raiseWeight(25.0f);
            break;
        }
    }
}

