/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.rules.teamselection;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PartyStorage;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.TrainerParticipant;
import com.pixelmonmod.pixelmon.battles.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.rules.clauses.BattleClause;
import com.pixelmonmod.pixelmon.battles.rules.clauses.BattleClauseRegistry;
import com.pixelmonmod.pixelmon.battles.rules.teamselection.ParticipantSelection;
import com.pixelmonmod.pixelmon.battles.rules.teamselection.TeamSelectPokemon;
import com.pixelmonmod.pixelmon.battles.rules.teamselection.TeamSelectionList;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.CancelTeamSelect;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.CheckRulesVersionFixed;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.RejectTeamSelect;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.rules.ShowTeamSelect;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.storage.TrainerPartyStorage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TeamSelection {
    final int id;
    private BattleRules rules;
    private ParticipantSelection[] participants;
    private boolean showRules;
    public static final String FAINT_KEY = "f";
    public static final String EGG_KEY = "e";
    public static final String NONE_KEY = "n";

    TeamSelection(int id, BattleRules rules, boolean showRules, PartyStorage ... storages) {
        this.id = id;
        this.rules = rules;
        this.showRules = showRules;
        this.participants = new ParticipantSelection[storages.length];
        for (int i = 0; i < this.participants.length; ++i) {
            this.participants[i] = new ParticipantSelection(storages[i]);
        }
    }

    boolean hasPlayer(EntityPlayerMP player) {
        for (ParticipantSelection p : this.participants) {
            if (!(p.storage instanceof PlayerPartyStorage) || ((PlayerPartyStorage)p.storage).getPlayer() != player) continue;
            return true;
        }
        return false;
    }

    void initializeClient() {
        PartyStorage storage;
        ParticipantSelection cancelPart = null;
        boolean hasNPC = false;
        for (ParticipantSelection p : this.participants) {
            if (p.isNPC) {
                hasNPC = true;
                continue;
            }
            storage = p.storage;
            boolean hasPokemon = false;
            for (int i = 0; i < storage.getAll().length; ++i) {
                Pokemon current = storage.get(i);
                if (current == null) {
                    p.disabled[i] = NONE_KEY;
                } else if (current.isEgg()) {
                    p.disabled[i] = EGG_KEY;
                } else if (current.getHealth() <= 0 && !this.rules.fullHeal) {
                    p.disabled[i] = FAINT_KEY;
                }
                if (p.disabled[i] != null) continue;
                p.disabled[i] = this.rules.validateSingle(current);
                hasPokemon = hasPokemon || p.disabled[i] == null;
            }
            if (hasPokemon) continue;
            cancelPart = p;
        }
        if (cancelPart != null && !hasNPC) {
            this.cancelBattle(cancelPart);
            return;
        }
        for (ParticipantSelection p : this.participants) {
            if (p.isNPC) continue;
            storage = (PlayerPartyStorage)p.storage;
            EntityPlayerMP player = ((PlayerPartyStorage)storage).getPlayer();
            ParticipantSelection otherPart = this.getOther(p);
            List<Pokemon> opponentPokemon = otherPart.storage.findAll(pokemon -> pokemon != null);
            ArrayList<TeamSelectPokemon> opponentTeam = new ArrayList<TeamSelectPokemon>();
            for (Pokemon pokemon2 : opponentPokemon) {
                opponentTeam.add(new TeamSelectPokemon(pokemon2));
            }
            Object packet = otherPart.isNPC ? new ShowTeamSelect(this.id, p.disabled, opponentTeam, ((TrainerPartyStorage)otherPart.storage).getTrainer().getId(), ((TrainerPartyStorage)otherPart.storage).getTrainer().getName(player.field_71148_cg), this.rules, this.showRules) : new ShowTeamSelect(this.id, p.disabled, opponentTeam, ((PlayerPartyStorage)otherPart.storage).getPlayerUUID(), this.rules, this.showRules);
            if (this.showRules) {
                packet = new CheckRulesVersionFixed(BattleClauseRegistry.getClauseVersion(), (ShowTeamSelect)packet);
            }
            Pixelmon.network.sendTo((IMessage)packet, player);
        }
    }

    void startBattle() {
        PlayerParticipant part2;
        BattleParticipant part1;
        ParticipantSelection npc = null;
        ParticipantSelection cancelPart = null;
        for (ParticipantSelection p : this.participants) {
            if (p.isNPC) {
                npc = p;
                int[] teamIndices = this.rules.teamPreview || this.rules.numPokemon < 6 ? RandomHelper.getRandomDistinctNumbersBetween(0, 5, 6) : new int[]{0, 1, 2, 3, 4, 5};
                for (int index : teamIndices) {
                    p.addTeamMember(index);
                    if (this.rules.validateTeam(p.team) != null) {
                        p.removeTeamMember();
                    }
                    if (p.team.size() == this.rules.numPokemon) break;
                }
                if (!p.team.isEmpty()) continue;
                cancelPart = p;
                break;
            }
            String initValidate = this.rules.validateTeam(p.team);
            if (!p.team.isEmpty() && initValidate == null) continue;
            EntityPlayerMP player = ((PlayerPartyStorage)p.storage).getPlayer();
            if (player != null && initValidate != null) {
                ChatHandler.sendChat((Entity)player, "gui.battlerules.teamviolatedforce", BattleClause.getLocalizedName(initValidate));
            }
            while (!p.team.isEmpty()) {
                p.removeTeamMember();
                if (this.rules.validateTeam(p.team) != null) continue;
            }
            if (p.team.isEmpty()) {
                int[] teamIndices;
                for (int index : teamIndices = RandomHelper.getRandomDistinctNumbersBetween(0, 5, 6)) {
                    p.addTeamMember(index);
                    if (p.team.isEmpty()) continue;
                    if (this.rules.validateTeam(p.team) == null) break;
                    p.removeTeamMember();
                }
            }
            if (!p.team.isEmpty()) continue;
            cancelPart = p;
            break;
        }
        if (cancelPart != null) {
            this.cancelBattle(cancelPart);
            return;
        }
        if (npc == null) {
            part1 = this.getPlayerPart(this.participants[0]);
            part2 = this.getPlayerPart(this.participants[1]);
        } else {
            TrainerPartyStorage storage = (TrainerPartyStorage)npc.storage;
            ParticipantSelection other = this.getOther(npc);
            EntityPlayerMP player = ((PlayerPartyStorage)other.storage).getPlayer();
            if (!storage.getTrainer().canStartBattle((EntityPlayer)player, true)) {
                this.removeTeamSelect();
                return;
            }
            part1 = new TrainerParticipant(storage.getTrainer(), (EntityPlayer)player, this.rules.battleType.numPokemon, npc.team);
            part2 = new PlayerParticipant(player, other.team, this.rules.battleType.numPokemon);
        }
        BattleRegistry.startBattle(new BattleParticipant[]{part1}, new BattleParticipant[]{part2}, this.rules);
        this.removeTeamSelect();
    }

    private void cancelBattle(ParticipantSelection cancelPart) {
        if (cancelPart != null) {
            String cancelName;
            if (cancelPart.isNPC) {
                EntityPlayerMP player = null;
                ParticipantSelection[] participantSelectionArray = this.participants;
                int n = participantSelectionArray.length;
                for (int i = 0; i < n; ++i) {
                    ParticipantSelection p = participantSelectionArray[i];
                    if (p.isNPC) continue;
                    player = ((PlayerPartyStorage)p.storage).getPlayer();
                    break;
                }
                String langCode = player == null ? "en_US" : player.field_71148_cg;
                cancelName = ((TrainerPartyStorage)cancelPart.storage).getTrainer().getName(langCode);
            } else {
                cancelName = ((PlayerPartyStorage)cancelPart.storage).getPlayerName();
            }
            for (ParticipantSelection p : this.participants) {
                if (p.isNPC) continue;
                CancelTeamSelect packet = new CancelTeamSelect();
                EntityPlayerMP player = ((PlayerPartyStorage)p.storage).getPlayer();
                Pixelmon.network.sendTo((IMessage)packet, player);
                if (p == cancelPart) {
                    ChatHandler.sendChat((Entity)player, "gui.battlerules.cancelselectyou", new Object[0]);
                    continue;
                }
                ChatHandler.sendChat((Entity)player, "gui.battlerules.cancelselect", cancelName);
            }
            this.removeTeamSelect();
        }
    }

    private PlayerParticipant getPlayerPart(ParticipantSelection p) {
        return new PlayerParticipant(((PlayerPartyStorage)p.storage).getPlayer(), p.team, this.rules.battleType.numPokemon);
    }

    private ParticipantSelection getOther(ParticipantSelection selection) {
        for (ParticipantSelection other : this.participants) {
            if (other == selection) continue;
            return other;
        }
        return selection;
    }

    private ParticipantSelection getPlayer(EntityPlayerMP player) {
        for (ParticipantSelection p : this.participants) {
            if (p.isNPC || ((PlayerPartyStorage)p.storage).getPlayer() != player) continue;
            return p;
        }
        return null;
    }

    private boolean isReady() {
        for (ParticipantSelection p : this.participants) {
            if (p.confirmed) continue;
            return false;
        }
        return true;
    }

    public void registerTeamSelect(EntityPlayerMP player, int[] selection, boolean force) {
        ParticipantSelection ps = this.getPlayer(player);
        if (ps == null) {
            return;
        }
        ps.setTeam(selection);
        while (ps.team.size() > this.rules.numPokemon) {
            ps.team.remove(ps.team.size() - 1);
        }
        String clauseID = this.rules.validateTeam(ps.team);
        if (ps.team.isEmpty()) {
            clauseID = FAINT_KEY;
        }
        if (clauseID == null || force) {
            ps.confirmed = true;
            if (this.isReady()) {
                this.startBattle();
            }
        } else {
            Pixelmon.network.sendTo((IMessage)new RejectTeamSelect(clauseID), player);
        }
    }

    public void unregisterTeamSelect(EntityPlayerMP player) {
        ParticipantSelection ps = this.getPlayer(player);
        if (ps != null) {
            ps.confirmed = false;
        }
    }

    private void removeTeamSelect() {
        TeamSelectionList.removeSelection(this.id);
    }

    public static String[] getReservedKeys() {
        return new String[]{FAINT_KEY, EGG_KEY, NONE_KEY};
    }
}

