/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.rules.teamselection;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.entities.npcs.registry.PokemonForm;
import com.pixelmonmod.pixelmon.util.IEncodeable;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class TeamSelectPokemon
implements IEncodeable {
    public PokemonForm pokemon;
    public int specialTexture;
    public String customTexture = "";
    public int pokeBall;
    public boolean isShiny;
    public boolean isEgg;
    public int eggCycles;

    public TeamSelectPokemon(Pokemon pokemon) {
        this.pokemon = new PokemonForm(pokemon.getSpecies(), pokemon.getForm(), pokemon.getGender());
        this.specialTexture = pokemon.getSpecialTexture().id;
        this.customTexture = pokemon.getCustomTexture();
        this.pokeBall = pokemon.getCaughtBall().getIndex();
        this.isShiny = pokemon.isShiny();
        this.isEgg = pokemon.isEgg();
        this.eggCycles = pokemon.getEggCycles();
    }

    public TeamSelectPokemon(ByteBuf buffer) {
        this.decodeInto(buffer);
    }

    @Override
    public void encodeInto(ByteBuf buffer) {
        this.pokemon.encodeInto(buffer);
        buffer.writeInt(this.specialTexture);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.customTexture);
        buffer.writeInt(this.pokeBall);
        buffer.writeBoolean(this.isShiny);
        buffer.writeBoolean(this.isEgg);
        buffer.writeInt(this.eggCycles);
    }

    @Override
    public void decodeInto(ByteBuf buffer) {
        this.pokemon = new PokemonForm(buffer);
        this.specialTexture = buffer.readInt();
        this.customTexture = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.pokeBall = buffer.readInt();
        this.isShiny = buffer.readBoolean();
        this.isEgg = buffer.readBoolean();
        this.eggCycles = buffer.readInt();
    }
}

