/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.controller.participants;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.PixelmonMethods;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.TerrainExamine;
import com.pixelmonmod.pixelmon.battles.controller.BattleControllerBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.ai.RandomAI;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.ParticipantType;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.Spectator;
import com.pixelmonmod.pixelmon.client.gui.battles.PixelmonInGui;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.OpenScreen;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.BackToMainMenu;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.EnforcedSwitch;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.ExitBattle;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetAllBattlingPokemon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetBattlingPokemon;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetPokemonBattleData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.SetPokemonTeamData;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.StartBattle;
import com.pixelmonmod.pixelmon.comm.packetHandlers.battles.gui.HPPacket;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumGuiScreen;
import com.pixelmonmod.pixelmon.enums.battle.EnumBattleEndCause;
import com.pixelmonmod.pixelmon.enums.forms.EnumBurmy;
import com.pixelmonmod.pixelmon.items.ItemShrineOrb;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.util.AirSaver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextComponentBase;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PlayerParticipant
extends BattleParticipant {
    public EntityPlayerMP player;
    public PlayerPartyStorage party;
    long guiCheck = 0L;
    public boolean hasAmuletCoin = false;
    public boolean hasHappyHour = false;
    public int payDay = 0;
    private AirSaver airSaver;

    public PlayerParticipant(EntityPlayerMP p, EntityPixelmon ... startingPixelmon) {
        super(startingPixelmon.length);
        this.player = p;
        this.loadParty(this.getStorage());
        this.initialize(p, startingPixelmon);
    }

    public PlayerParticipant(EntityPlayerMP p, List<Pokemon> teamSelection, int numControlledPokemon) {
        super(numControlledPokemon);
        this.loadParty(teamSelection);
        EntityPixelmon[] startingPixelmon = new EntityPixelmon[numControlledPokemon];
        for (int i = 0; i < numControlledPokemon; ++i) {
            if (teamSelection.size() <= i) continue;
            startingPixelmon[i] = teamSelection.get(i).getOrSpawnPixelmon((Entity)p);
        }
        this.initialize(p, startingPixelmon);
    }

    private void initialize(EntityPlayerMP p, EntityPixelmon ... startingPixelmon) {
        this.player = p;
        this.party = this.getStorage();
        int positionIndex = 0;
        for (EntityPixelmon pokemon : startingPixelmon) {
            PixelmonWrapper pw;
            if (pokemon == null || (pw = this.getPokemonFromParty(pokemon)) == null) continue;
            this.controlledPokemon.add(pw);
            pw.battlePosition = positionIndex++;
        }
        this.airSaver = new AirSaver(p);
        p.func_70637_d(false);
        p.field_191988_bg = 0.0f;
        p.field_70702_br = 0.0f;
        p.func_70095_a(false);
    }

    private void enableReturnHeldItems() {
        for (PixelmonWrapper pw : this.allPokemon) {
            pw.enableReturnHeldItem();
        }
    }

    @Override
    public ParticipantType getType() {
        return ParticipantType.Player;
    }

    @Override
    public boolean canGainXP() {
        return true;
    }

    @Override
    public boolean hasMorePokemonReserve() {
        return this.countAblePokemon() > this.getActiveUnfaintedPokemon().size() + this.switchingOut.size();
    }

    @Override
    public void startBattle(BattleControllerBase bc) {
        super.startBattle(bc);
        this.setBattleAI(new RandomAI(this));
        this.player.field_71075_bZ.field_75102_a = true;
        boolean useTurnTime = false;
        int activateTime = 0;
        int turnTime = 0;
        if (bc.rules.turnTime > 0) {
            useTurnTime = true;
            activateTime = bc.rules.turnTime;
            turnTime = bc.rules.turnTime;
        } else if (PixelmonServerConfig.afkHandlerOn) {
            useTurnTime = true;
            activateTime = PixelmonServerConfig.afkTimerActivateSeconds;
            turnTime = PixelmonConfig.afkTimerTurnSeconds;
        }
        ParticipantType[][] battleType = bc.getBattleType(this);
        StartBattle startPacket = useTurnTime ? new StartBattle(bc.battleIndex, battleType, activateTime, turnTime, bc.rules) : new StartBattle(bc.battleIndex, battleType, bc.rules);
        Pixelmon.network.sendTo((IMessage)startPacket, this.player);
        this.party.pokedex.update();
        if (bc.rules.fullHeal || PixelmonConfig.returnHeldItems && bc.isPvP()) {
            this.enableReturnHeldItems();
        }
        Pixelmon.network.sendTo((IMessage)new SetAllBattlingPokemon(PixelmonInGui.convertToGUI(Arrays.asList(this.allPokemon))), this.player);
        Pixelmon.network.sendTo((IMessage)new SetBattlingPokemon(this.getTeamPokemonList()), this.player);
        PixelmonMethods.getAllActivePokemon(this.player).forEach(EntityPixelmon::retrieve);
        for (PixelmonWrapper pw : this.controlledPokemon) {
            if (pw.pokemon.getPixelmonIfExists() == null) {
                pw.entity.func_70012_b(this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, this.player.field_70177_z, 0.0f);
                pw.entity.releaseFromPokeball();
            }
            pw.entity.field_70128_L = false;
            pw.entity.battleController = bc;
        }
    }

    public ArrayList<PixelmonWrapper> getTeamPokemonList() {
        ArrayList<BattleParticipant> team = this.bc.getTeam(this);
        ArrayList<PixelmonWrapper> teamPokemon = new ArrayList<PixelmonWrapper>();
        for (BattleParticipant p : team) {
            teamPokemon.addAll(p.controlledPokemon);
        }
        return teamPokemon;
    }

    @Override
    public void endBattle() {
        if (!this.player.field_71075_bZ.field_75098_d) {
            this.player.field_71075_bZ.field_75102_a = false;
        }
        int burmyForm = -1;
        for (PixelmonWrapper pixelmonWrapper : this.allPokemon) {
            if (!pixelmonWrapper.changeBurmy || this.controlledPokemon.isEmpty()) continue;
            if (burmyForm == -1) {
                burmyForm = EnumBurmy.getFromType(TerrainExamine.getTerrain((PixelmonWrapper)this.controlledPokemon.get(0))).ordinal();
            }
            pixelmonWrapper.pokemon.setForm(burmyForm);
        }
        for (PixelmonWrapper pw : this.controlledPokemon) {
            pw.resetOnSwitch();
            if (pw.pokemon.getFormEnum().isTemporary()) {
                pw.setForm(pw.pokemon.getFormEnum().getDefaultFromTemporary(pw.pokemon).getForm());
            }
            if (pw.entity == null) continue;
            pw.entity.endBattle();
            pw.entity.retrieve();
        }
        for (PixelmonWrapper pixelmonWrapper : this.allPokemon) {
            if (pixelmonWrapper.pokemon.getFormEnum() != null && pixelmonWrapper.pokemon.getFormEnum().isTemporary()) {
                pixelmonWrapper.setForm(pixelmonWrapper.pokemon.getFormEnum().getDefaultFromTemporary(pixelmonWrapper.pokemon).getForm());
            }
            pixelmonWrapper.resetBattleEvolution();
            pixelmonWrapper.writeToNBT();
        }
        if (this.payDay > 0 && this.hasMorePokemon()) {
            this.payDay *= this.getPrizeMoneyMultiplier();
            Pixelmon.moneyManager.getBankAccount(this.player).ifPresent(account -> {
                account.changeMoney(this.payDay);
                ChatHandler.sendBattleMessage((Entity)this.getEntity(), "pixelmon.effect.paydayend", this.getName(), this.payDay);
            });
        }
        Pixelmon.network.sendTo((IMessage)new ExitBattle(), this.player);
        if (this.bc != null && this.bc.participants.size() == 2 && this.bc.otherParticipant(this) instanceof PlayerParticipant) {
            if (!this.hasMorePokemon()) {
                this.party.stats.addLoss();
            } else {
                this.party.stats.addWin();
            }
        }
    }

    @Override
    public void getNextPokemon(int position) {
        if (position >= this.controlledPokemon.size()) {
            this.wait = false;
            return;
        }
        boolean switching = false;
        PixelmonWrapper switchingPokemon = (PixelmonWrapper)this.controlledPokemon.get(position);
        switchingPokemon.isSwitching = true;
        switching = true;
        switchingPokemon.wait = true;
        if (switchingPokemon.newPokemonUUID == null) {
            Pixelmon.network.sendTo((IMessage)new EnforcedSwitch(position), this.player);
        }
        if (!switching) {
            this.wait = false;
        }
    }

    public int getPrizeMoneyMultiplier() {
        int multiplier = 1;
        if (this.hasAmuletCoin) {
            multiplier *= 2;
        }
        if (this.hasHappyHour) {
            multiplier *= 2;
        }
        return multiplier;
    }

    @Override
    public UUID getNextPokemonUUID() {
        Pokemon first = this.party.findOne(pokemon -> pokemon.getHealth() > 0 && !pokemon.isEgg() && pokemon.getPixelmonIfExists() == null);
        if (first == null) {
            return null;
        }
        return first.getUUID();
    }

    @Override
    public TextComponentBase getName() {
        return new TextComponentString(this.player.func_145748_c_().func_150260_c());
    }

    @Override
    public void selectAction() {
        this.getMove(null);
    }

    @Override
    public MoveChoice getMove(PixelmonWrapper pokemon) {
        if (this.bc == null) {
            return null;
        }
        boolean canSwitch = true;
        boolean canFlee = true;
        ArrayList<PixelmonWrapper> pokemonToChoose = new ArrayList<PixelmonWrapper>();
        for (PixelmonWrapper p : this.controlledPokemon) {
            if (p.getMoveset().isEmpty()) {
                this.bc.endBattle(EnumBattleEndCause.FORCE);
                return null;
            }
            boolean[] canExit = PlayerParticipant.canSwitch(p);
            canSwitch = canExit[0];
            canFlee = canExit[1];
            if (p.attack == null || !p.attack.doesPersist(p)) {
                pokemonToChoose.add(p);
                p.wait = true;
                continue;
            }
            p.wait = false;
        }
        if (!pokemonToChoose.isEmpty()) {
            Pixelmon.network.sendTo((IMessage)new BackToMainMenu(canSwitch, canFlee, pokemonToChoose), this.player);
            ArrayList<Spectator> playerSpectators = this.bc.getPlayerSpectators(this);
            playerSpectators.forEach(spectator -> spectator.sendMessage(new BackToMainMenu(true, true, pokemonToChoose)));
        }
        return null;
    }

    @Override
    public PixelmonWrapper switchPokemon(PixelmonWrapper pw, UUID newPixelmonUUID) {
        double x = this.player.field_70165_t;
        double y = this.player.field_70163_u;
        double z = this.player.field_70161_v;
        String beforeName = pw.getNickname();
        pw.beforeSwitch();
        if (!pw.isFainted() && !pw.nextSwitchIsMove) {
            ChatHandler.sendBattleMessage((Entity)this.player, "playerparticipant.enough", pw.getNickname());
            this.bc.sendToOthers("playerparticipant.withdrew", this, this.player.func_145748_c_().func_150260_c(), beforeName);
        }
        PixelmonWrapper newWrapper = this.getPokemonFromParty(newPixelmonUUID);
        if (!this.bc.simulateMode) {
            pw.entity.retrieve();
            pw.entity = null;
            EntityPixelmon pixelmon = this.party.find(newPixelmonUUID).getOrSpawnPixelmon((Entity)this.player);
            pixelmon.field_70179_y = 0.0;
            pixelmon.field_70181_x = 0.0;
            pixelmon.field_70159_w = 0.0;
            pixelmon.func_70012_b(x, y, z, this.player.field_70177_z, 0.0f);
            newWrapper.entity = pixelmon;
        }
        newWrapper.battlePosition = pw.battlePosition;
        newWrapper.getBattleAbility().beforeSwitch(newWrapper);
        String newNickname = newWrapper.getNickname();
        ChatHandler.sendBattleMessage((Entity)this.player, "playerparticipant.go", newNickname);
        this.bc.sendToOthers("battlecontroller.sendout", this, this.player.func_145748_c_().func_150260_c(), newNickname);
        int index = this.controlledPokemon.indexOf(pw);
        this.controlledPokemon.set(index, newWrapper);
        this.bc.participants.forEach(BattleParticipant::updateOtherPokemon);
        newWrapper.afterSwitch();
        return newWrapper;
    }

    @Override
    public boolean checkPokemon() {
        for (Pokemon pokemon : this.party.getTeam()) {
            if (!pokemon.getMoveset().isEmpty()) continue;
            ChatHandler.sendChat((Entity)this.player, "playerparticipant.load", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public void updatePokemon(PixelmonWrapper pw) {
        pw.update(EnumUpdateType.HP);
    }

    @Override
    public EntityLivingBase getEntity() {
        return this.player;
    }

    @Override
    public void updateOtherPokemon() {
        ArrayList<Spectator> playerSpectators;
        if (this.bc == null) {
            this.endBattle();
            return;
        }
        if (this.bc.simulateMode) {
            return;
        }
        ArrayList<PixelmonWrapper> opponents = this.bc.getOpponentPokemon(this);
        for (int i = 0; i < opponents.size(); ++i) {
            if (opponents.get(i) != null) continue;
            opponents.remove(i);
            --i;
        }
        if (this.bc.battleTurn == -1) {
            this.updateOpponentPokemon();
            if (this.bc.getTeam(this).size() > 1) {
                ArrayList<PixelmonWrapper> otherTeamPokemon = this.getAllyData();
                Pixelmon.network.sendTo((IMessage)new SetPokemonTeamData(otherTeamPokemon), this.player);
                playerSpectators = this.bc.getPlayerSpectators(this);
                playerSpectators.forEach(spectator -> spectator.sendMessage(new SetPokemonTeamData(otherTeamPokemon)));
            }
        }
        if (!this.bc.battleEnded) {
            ArrayList<PixelmonWrapper> teamPokemon = this.getTeamPokemonList();
            Pixelmon.network.sendTo((IMessage)new SetBattlingPokemon(teamPokemon), this.player);
            playerSpectators = this.bc.getPlayerSpectators(this);
            playerSpectators.forEach(spectator -> spectator.sendMessage(new SetBattlingPokemon(teamPokemon)));
        }
    }

    public ArrayList<PixelmonWrapper> getAllyData() {
        ArrayList<BattleParticipant> team = this.bc.getTeam(this);
        ArrayList<PixelmonWrapper> otherTeamPokemon = new ArrayList<PixelmonWrapper>(6);
        team.stream().filter(p -> p != this).forEach(p -> otherTeamPokemon.addAll(p.controlledPokemon));
        return otherTeamPokemon;
    }

    public PixelmonInGui[] getOpponentData() {
        ArrayList<PixelmonWrapper> opponents = this.bc.getOpponentPokemon(this);
        return PixelmonInGui.convertToGUI(opponents);
    }

    public void updateOpponentPokemon() {
        PixelmonInGui[] data = this.getOpponentData();
        Pixelmon.network.sendTo((IMessage)new SetPokemonBattleData(data), this.player);
        ArrayList<Spectator> playerSpectators = this.bc.getPlayerSpectators(this);
        playerSpectators.forEach(spectator -> spectator.sendMessage(new SetPokemonBattleData(data)));
    }

    public void updatePokemonHealth() {
        this.updateOtherPokemon();
    }

    public void checkPlayerItems() {
        for (int i = 0; i < this.player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack item;
            int dmg;
            if (this.player.field_71071_by.field_70462_a.get(i) == null || !(((ItemStack)this.player.field_71071_by.field_70462_a.get(i)).func_77973_b() instanceof ItemShrineOrb) || (dmg = (item = (ItemStack)this.player.field_71071_by.field_70462_a.get(i)).func_77952_i()) >= ItemShrineOrb.full) continue;
            item.func_77964_b(dmg + 1);
            break;
        }
    }

    public int getHighestLevel() {
        int lvl = -1;
        for (PixelmonWrapper pw : this.allPokemon) {
            lvl = Math.max(lvl, pw.getLevelNum());
        }
        return lvl;
    }

    @Override
    public void tick() {
        this.airSaver.tick();
        if (this.party != null && !this.party.guiOpened) {
            this.openGui();
        }
        if (this.player.func_110143_aJ() <= 0.0f) {
            this.bc.endBattle(EnumBattleEndCause.FORCE);
            BattleRegistry.deRegisterBattle(this.bc);
        }
    }

    public void givePlayerExp(PixelmonWrapper pixelmon) {
        int opponentPixelmonLevel = pixelmon.getLevelNum();
        int expAmount = 0;
        int divisor = 5;
        if (opponentPixelmonLevel >= 75) {
            expAmount = opponentPixelmonLevel / (divisor * 5);
            this.player.func_71023_q(expAmount);
        } else if (opponentPixelmonLevel >= 50) {
            expAmount = opponentPixelmonLevel / (divisor * 4);
            this.player.func_71023_q(expAmount);
        } else if (opponentPixelmonLevel >= 35) {
            expAmount = opponentPixelmonLevel / (divisor * 2);
            this.player.func_71023_q(expAmount);
        } else if (opponentPixelmonLevel > divisor) {
            expAmount = opponentPixelmonLevel / divisor;
            this.player.func_71023_q(expAmount);
        } else {
            this.player.func_71023_q(1);
        }
    }

    public void openGui() {
        if (this.guiCheck == 0L || System.currentTimeMillis() - this.guiCheck > 1000L) {
            OpenScreen.open((EntityPlayer)this.player, EnumGuiScreen.Battle, this.bc.battleIndex);
            this.guiCheck = System.currentTimeMillis();
        }
    }

    @Override
    public void setPosition(double[] ds) {
        this.player.field_71135_a.func_147364_a(ds[0], ds[1], ds[2], this.player.field_70177_z, this.player.field_70125_A);
    }

    @Override
    public void sendDamagePacket(PixelmonWrapper user, int damage) {
        Pixelmon.network.sendTo((IMessage)new HPPacket(user, -damage), this.player);
    }

    @Override
    public void sendHealPacket(PixelmonWrapper target, int amount) {
        Pixelmon.network.sendTo((IMessage)new HPPacket(target, amount), this.player);
    }

    @Override
    public String getDisplayName() {
        return this.player.getDisplayNameString();
    }

    @Override
    public PlayerPartyStorage getStorage() {
        return Pixelmon.storageManager.getParty(this.player);
    }

    @Override
    public boolean canMegaEvolve() {
        return this.getStorage().getMegaItem().canEvolve();
    }
}

