/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.specialAttacks.basic.SpecialAttackBase;
import com.pixelmonmod.pixelmon.battles.controller.ai.MoveChoice;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.enums.EnumType;
import java.util.ArrayList;

public class Conversion2
extends SpecialAttackBase {
    @Override
    public AttackResult applyEffectDuring(PixelmonWrapper user, PixelmonWrapper target) {
        if (target.lastAttack == null) {
            user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
            return AttackResult.failed;
        }
        ArrayList<EnumType> ableTypes = this.getPossibleTypes(user, target);
        if (!ableTypes.isEmpty()) {
            EnumType chosenType = RandomHelper.getRandomElementFromList(ableTypes);
            user.setTempType(chosenType);
            user.bc.sendToAll("pixelmon.effect.changetype", user.getNickname(), chosenType.getLocalizedName());
            return AttackResult.succeeded;
        }
        user.bc.sendToAll("pixelmon.effect.effectfailed", new Object[0]);
        return AttackResult.failed;
    }

    private ArrayList<EnumType> getPossibleTypes(PixelmonWrapper user, PixelmonWrapper target) {
        ArrayList<EnumType> ableTypes = new ArrayList<EnumType>();
        for (EnumType type : EnumType.values()) {
            if (!(EnumType.getEffectiveness(target.lastAttack.getType(), type) < 1.0f)) continue;
            ableTypes.add(type);
        }
        if (user.type.size() == 1) {
            ableTypes.remove((Object)user.type.get(0));
        }
        return ableTypes;
    }

    @Override
    public void weightEffect(PixelmonWrapper pw, MoveChoice userChoice, ArrayList<MoveChoice> userChoices, ArrayList<MoveChoice> bestUserChoices, ArrayList<MoveChoice> opponentChoices, ArrayList<MoveChoice> bestOpponentChoices) {
        for (PixelmonWrapper target : userChoice.targets) {
            pw.getBattleAI().weightTypeChange(pw, userChoice, this.getPossibleTypes(pw, target), bestUserChoices, bestOpponentChoices);
        }
    }
}

