/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.battles.attacks.animations.particles;

import com.pixelmonmod.pixelmon.battles.attacks.AttackBase;
import com.pixelmonmod.pixelmon.battles.attacks.animations.StandardParticleAnimationData;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.AttackSystemBase;
import com.pixelmonmod.pixelmon.battles.attacks.animations.particles.EnumEffectType;
import com.pixelmonmod.pixelmon.client.particle.ParticleArcanery;
import com.pixelmonmod.pixelmon.client.particle.ParticleMathHelper;
import com.pixelmonmod.pixelmon.client.particle.particles.AttackEffect;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.enums.EnumType;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class AttackRain
extends AttackSystemBase<RainData> {
    @Override
    @SideOnly(value=Side.CLIENT)
    public void execute(Minecraft mc, World w, double x, double y, double z, float scale, boolean shiny, double ... args) {
        float height = ((RainData)this.data).heightAboveTarget;
        EntityPixelmon pixelmon = (EntityPixelmon)w.func_73045_a(this.endID);
        height += pixelmon == null ? 2.0f : pixelmon.field_70131_O;
        int particlesPerWave = Math.round(1.0f * (float)((RainData)this.data).power / (float)((RainData)this.data).durationTicks);
        for (int tick = 0; tick < ((RainData)this.data).durationTicks; ++tick) {
            for (int i = 0; i < particlesPerWave; ++i) {
                AttackEffect effect = ((RainData)this.data).makeEffect(this).setHideTicks(tick + 1, true);
                double offsetX = 0.0;
                double offsetZ = 0.0;
                Vec3d startOffset = ParticleMathHelper.generatePointInSphere(height / 1.5f, w.field_73012_v);
                double startOffsetX = startOffset.field_72450_a;
                double startOffsetZ = startOffset.field_72448_b;
                if (((RainData)this.data).maxHorizontalDisplacement > 0.0f) {
                    Vec3d offset = ParticleMathHelper.generatePointInSphere(((RainData)this.data).maxHorizontalDisplacement, w.field_73012_v);
                    offsetX = startOffsetX + offset.field_72450_a;
                    offsetZ = startOffsetZ + offset.field_72448_b;
                } else {
                    offsetX = startOffsetX;
                    offsetZ = startOffsetZ;
                }
                effect.startX = effect.endX + startOffsetX;
                effect.startY = effect.endY + (double)height;
                effect.startZ = effect.endZ + startOffsetZ;
                effect.endX += offsetX;
                effect.endY = effect.startY - (double)height;
                effect.endZ += offsetZ;
                effect.setHeading();
                mc.field_71452_i.func_78873_a((Particle)new ParticleArcanery(w, effect.startX, effect.startY, effect.startZ, 0.0, 0.0, 0.0, effect));
            }
        }
    }

    @Override
    public void onConstruct(AttackEffect effect) {
    }

    @Override
    public void onInit(ParticleArcanery particle, AttackEffect effect) {
    }

    @Override
    public void onEnable(ParticleArcanery particle, AttackEffect effect) {
    }

    @Override
    public void onUpdate(ParticleArcanery particle, AttackEffect effect) {
    }

    @Override
    public void onTarget(ParticleArcanery particle, AttackEffect effect) {
    }

    @Override
    public void onUpdateEol(ParticleArcanery particle, AttackEffect effect) {
    }

    @Override
    public void onUpdateLast(ParticleArcanery particle, AttackEffect effect) {
    }

    @Override
    public void onPreRender(ParticleArcanery particle, float partialTicks, AttackEffect effect) {
    }

    @Override
    public void onPostRender(ParticleArcanery particle, float partialTicks, AttackEffect effect) {
    }

    @Override
    public boolean hasCustomRenderer(AttackEffect effect) {
        return false;
    }

    @Override
    public void onRender(ParticleArcanery particle, Tessellator tessellator, float partialTicks, AttackEffect effect) {
    }

    public static class RainData
    extends StandardParticleAnimationData {
        public int durationTicks;
        public float maxHorizontalDisplacement = 0.0f;
        public int heightAboveTarget = 2;

        @Override
        public void initFromAttack(AttackBase attackBase, int effectivePower, EnumType effectiveType) {
            if (this.power == -1) {
                this.power = effectivePower / 2;
            }
            super.initFromAttack(attackBase, effectivePower, effectiveType);
            if (this.durationTicks == 0) {
                this.durationTicks = (int)Math.ceil(Math.sqrt(effectivePower) * 3.0);
            }
        }

        @Override
        public void writeToByteBuffer(ByteBuf buf) {
            super.writeToByteBuffer(buf);
            buf.writeByte(this.durationTicks);
            buf.writeBoolean(this.maxHorizontalDisplacement != 0.0f);
            if (this.maxHorizontalDisplacement != 0.0f) {
                buf.writeFloat(this.maxHorizontalDisplacement);
            }
            buf.writeByte(this.heightAboveTarget);
        }

        @Override
        public RainData readFromByteBuffer(ByteBuf buf) {
            super.readFromByteBuffer(buf);
            this.durationTicks = buf.readByte();
            if (buf.readBoolean()) {
                this.maxHorizontalDisplacement = buf.readFloat();
            }
            this.heightAboveTarget = buf.readByte();
            return this;
        }

        @Override
        public EnumEffectType getEffectEnum() {
            return EnumEffectType.RAIN;
        }

        public RainData setDurationTicks(int durationTicks) {
            this.durationTicks = durationTicks;
            return this;
        }

        public RainData setMaxHorizontalDisplacement(float maxHorizontalDisplacement) {
            this.maxHorizontalDisplacement = maxHorizontalDisplacement;
            return this;
        }

        public RainData setHeightAboveTarget(int heightAboveTarget) {
            this.heightAboveTarget = heightAboveTarget;
            return this;
        }
    }
}

