/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.world;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import net.minecraft.client.resources.I18n;
import net.minecraft.world.World;

public enum WorldTime {
    DAWN(tick -> tick >= 22500 || tick <= 300),
    MORNING(tick -> tick <= 6000 || tick >= 22550),
    DAY(tick -> tick <= 12000),
    MIDDAY(tick -> tick >= 5500 && tick <= 6500),
    AFTERNOON(tick -> tick >= 6000 && tick <= 12000),
    DUSK(tick -> tick >= 12000 && tick <= 13800),
    NIGHT(tick -> tick >= 13450 && tick <= 22550),
    MIDNIGHT(tick -> tick >= 17500 && tick <= 18500);

    public Predicate<Integer> tickCondition;
    public static ConcurrentMap<Integer, ArrayList<WorldTime>> worldTimes;
    private static final WorldTime[] ALL_TIMES;

    private WorldTime(Predicate<Integer> tickCondition) {
        this.tickCondition = tickCondition;
    }

    public String getUnlocalizedName() {
        return this.name().charAt(0) + this.name().toLowerCase().substring(1);
    }

    public String getLocalizedName() {
        return I18n.func_135052_a((String)("time." + this.name().toLowerCase()), (Object[])new Object[0]);
    }

    public static ArrayList<WorldTime> getCurrent(World world) {
        return (ArrayList)worldTimes.get(world.field_73011_w.getDimension());
    }

    private static ArrayList<WorldTime> getCurrent(int ticks) {
        ArrayList<WorldTime> current = new ArrayList<WorldTime>();
        for (WorldTime time : ALL_TIMES) {
            if (!time.tickCondition.test(ticks)) continue;
            current.add(time);
        }
        return current;
    }

    public static void updateWorldTime(World world) {
        Objects.requireNonNull(world, "null world supplied");
        worldTimes.put(world.field_73011_w.getDimension(), WorldTime.getCurrent((int)(world.func_72820_D() % 24000L)));
    }

    static {
        worldTimes = Maps.newConcurrentMap();
        ALL_TIMES = WorldTime.values();
    }
}

