/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.trading;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.api.trading.NPCTrades;
import com.pixelmonmod.pixelmon.api.trading.TradePair;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.util.helpers.CollectionHelper;
import com.pixelmonmod.pixelmon.util.helpers.RCFileHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Scanner;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Level;

public class PossibleTradeList {
    private ArrayList<TradePair> allPossibleTrades = new ArrayList();
    private static PossibleTradeList INSTANCE;
    private static final String PATH = "npcs/trades.json";
    private static final Gson GSON;

    public static void registerTrades() {
        try {
            NPCTrades.UNTRADEABLE = new PokemonSpec("untradeable");
            File file = new File("pixelmon/npcs/trades.json");
            if (!PixelmonConfig.useExternalJSONFilesNPCs || !file.exists()) {
                Path path = RCFileHelper.pathFromResourceLocation(new ResourceLocation("pixelmon", PATH));
                InputStream iStream = PossibleTradeList.class.getResourceAsStream("/assets/pixelmon/npcs/trades.json");
                if (iStream == null) {
                    Pixelmon.LOGGER.log(Level.WARN, "Couldn't find the trade list JSON: " + path.toString());
                }
                Scanner s = new Scanner(iStream);
                s.useDelimiter("\\A");
                String json = s.hasNext() ? s.next() : "";
                INSTANCE = (PossibleTradeList)GSON.fromJson(json, PossibleTradeList.class);
                s.close();
                if (PixelmonConfig.useExternalJSONFilesNPCs) {
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                    PrintWriter pw = new PrintWriter(file);
                    pw.write(json);
                    pw.flush();
                    pw.close();
                }
            } else {
                file.getParentFile().mkdirs();
                INSTANCE = (PossibleTradeList)GSON.fromJson((Reader)new FileReader(file), PossibleTradeList.class);
            }
            Pixelmon.LOGGER.info("Registered NPC trades.");
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
            Pixelmon.LOGGER.error("Unable to register NPC trades.");
            INSTANCE = new PossibleTradeList();
            PossibleTradeList.INSTANCE.allPossibleTrades.add(new TradePair(new PokemonSpec("Magikarp"), new PokemonSpec("Magikarp")));
        }
    }

    public static void save() {
        try {
            new File("pixelmon/npcs/trades.json").getParentFile().mkdirs();
            PrintWriter pw = new PrintWriter(new File("pixelmon/npcs/trades.json"));
            String json = GSON.toJson((Object)INSTANCE);
            pw.write(json);
            pw.flush();
            pw.close();
            Pixelmon.LOGGER.info("Saved NPC trades.");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static ArrayList<TradePair> getAllPossibleTrades() {
        return PossibleTradeList.INSTANCE.allPossibleTrades;
    }

    public static TradePair getRandomTrade() {
        return CollectionHelper.getRandomElement(PossibleTradeList.getAllPossibleTrades());
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(PokemonSpec.class, (Object)PokemonSpec.SPEC_ADAPTER).create();
    }
}

