/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.storage;

import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;

public abstract class StorageSort
implements Comparator<Pokemon> {
    public static StorageSort SPECIES = new StorageSort(){

        @Override
        public int compare(Pokemon p1, Pokemon p2) {
            return Integer.compare(p1.getSpecies().getNationalPokedexInteger(), p2.getSpecies().getNationalPokedexInteger());
        }
    };
    public static StorageSort LEVEL = new StorageSort(){

        @Override
        public int compare(Pokemon p1, Pokemon p2) {
            return Integer.compare(p1.getLevel(), p2.getLevel());
        }
    };

    public void apply(PokemonStorage storage, boolean ascending) {
        Pokemon pokemon1;
        int i;
        ArrayList<StoragePosition> startPositions = new ArrayList<StoragePosition>();
        ArrayList<Pokemon> unsorted = new ArrayList<Pokemon>();
        HashMap<Pokemon, StoragePosition> beforePositions = new HashMap<Pokemon, StoragePosition>();
        HashMap afterPositions = new HashMap();
        Pokemon[] allWithNulls = storage.getAll();
        ArrayList<Pokemon> all = new ArrayList<Pokemon>();
        for (Pokemon pokemon : allWithNulls) {
            if (pokemon == null) continue;
            StoragePosition position = storage.getPosition(pokemon);
            startPositions.add(position);
            unsorted.add(pokemon);
            all.add(pokemon);
            beforePositions.put(pokemon, position);
        }
        if (all.size() <= 1) {
            return;
        }
        int sign = ascending ? 1 : -1;
        boolean clearPass = true;
        do {
            clearPass = true;
            for (i = 0; i < all.size() - 1; ++i) {
                Pokemon pokemon2;
                pokemon1 = (Pokemon)all.get(i);
                int compare = this.compare(pokemon1, pokemon2 = (Pokemon)all.get(i + 1)) * sign;
                if (compare >= 0) continue;
                all.set(i, pokemon2);
                all.set(i + 1, pokemon1);
                clearPass = false;
            }
        } while (!clearPass);
        for (i = 0; i < all.size(); ++i) {
            pokemon1 = (Pokemon)all.get(i);
            storage.set((StoragePosition)startPositions.get(i), pokemon1);
        }
    }
}

