/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.conditions;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.world.WeatherType;
import com.pixelmonmod.pixelmon.api.world.WorldTime;
import com.pixelmonmod.pixelmon.config.BetterSpawnerConfig;
import com.pixelmonmod.pixelmon.util.helpers.CollectionHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;

public class SpawnCondition {
    public static Class<? extends SpawnCondition> targetedSpawnCondition = SpawnCondition.class;
    public ArrayList<WorldTime> times = null;
    public ArrayList<WeatherType> weathers = null;
    public transient ArrayList<Block> cachedBaseBlocks = new ArrayList();
    public transient ArrayList<Block> cachedNeededNearbyBlocks = new ArrayList();
    public transient ArrayList<Biome> biomes = new ArrayList();
    private ArrayList<String> stringBiomes = null;
    private ArrayList<String> baseBlocks = null;
    private ArrayList<String> neededNearbyBlocks = null;
    public ArrayList<String> variant = null;
    public String tag = null;
    public Boolean seesSky = null;
    public Biome.TempCategory temperature = null;
    public ArrayList<Integer> dimensions = null;
    public ArrayList<String> worlds = null;
    public Integer minX = null;
    public Integer maxX = null;
    public Integer minY = null;
    public Integer maxY = null;
    public Integer minZ = null;
    public Integer maxZ = null;
    public Integer moonPhase = null;
    public Integer minLightLevel = null;
    public Integer maxLightLevel = null;
    static ArrayList<WorldTime> currentTimes = new ArrayList();

    public void onExport() {
        this.stringBiomes = new ArrayList();
        for (Biome biome : this.biomes) {
            this.stringBiomes.add(biome.getRegistryName().toString());
        }
        for (Block block : this.cachedBaseBlocks) {
            this.baseBlocks.add(block.getRegistryName().toString());
        }
        for (Block block : this.cachedNeededNearbyBlocks) {
            this.neededNearbyBlocks.add(block.getRegistryName().toString());
        }
    }

    public static <T extends IForgeRegistryEntry<T>> void cacheRegistry(Class<T> clazz, ArrayList<String> from, ArrayList<T> to, HashMap<String, ArrayList<T>> categories) {
        if (from == null) {
            return;
        }
        IForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(clazz);
        block0: for (String id : from) {
            if (categories.containsKey(id)) {
                to.addAll((Collection)categories.get(id));
                continue;
            }
            for (Map.Entry entry : registry.getEntries()) {
                if (!((ResourceLocation)entry.getKey()).toString().equalsIgnoreCase(id) && !((ResourceLocation)entry.getKey()).func_110623_a().equalsIgnoreCase(id)) continue;
                to.add(entry.getValue());
                continue block0;
            }
        }
    }

    public void onImport() {
        if (this.stringBiomes == null) {
            this.stringBiomes = new ArrayList();
        }
        SpawnCondition.cacheRegistry(Biome.class, this.stringBiomes, this.biomes, BetterSpawnerConfig.INSTANCE.cachedBiomeCategories);
        SpawnCondition.cacheRegistry(Block.class, this.baseBlocks, this.cachedBaseBlocks, BetterSpawnerConfig.INSTANCE.cachedBlockCategories);
        SpawnCondition.cacheRegistry(Block.class, this.neededNearbyBlocks, this.cachedNeededNearbyBlocks, BetterSpawnerConfig.INSTANCE.cachedBlockCategories);
    }

    public boolean fits(SpawnInfo spawnInfo, SpawnLocation spawnLocation) {
        boolean timeFits = false;
        ArrayList<WorldTime> times = WorldTime.getCurrent(spawnLocation.location.world);
        if (this.times == null || this.times.isEmpty()) {
            timeFits = true;
        } else {
            for (WorldTime time : times) {
                if (!this.times.contains((Object)time)) continue;
                timeFits = true;
            }
        }
        if (!timeFits) {
            return false;
        }
        if (!(this.tag == null || spawnInfo.tags != null && spawnInfo.tags.contains(this.tag))) {
            return false;
        }
        if (this.seesSky != null && this.seesSky != spawnLocation.seesSky) {
            return false;
        }
        if (this.temperature != null && this.temperature != spawnLocation.biome.func_150561_m()) {
            return false;
        }
        if (this.dimensions != null && !this.dimensions.isEmpty() && !this.dimensions.contains(spawnLocation.location.world.field_73011_w.getDimension())) {
            return false;
        }
        if (this.worlds != null && !this.worlds.isEmpty() && !this.worlds.contains(spawnLocation.location.world.func_72912_H().func_76065_j())) {
            return false;
        }
        if (this.minX != null && spawnLocation.location.pos.func_177958_n() < this.minX) {
            return false;
        }
        if (this.maxX != null && spawnLocation.location.pos.func_177958_n() > this.maxX) {
            return false;
        }
        if (this.minY != null && spawnLocation.location.pos.func_177956_o() < this.minY) {
            return false;
        }
        if (this.maxY != null && spawnLocation.location.pos.func_177956_o() > this.maxY) {
            return false;
        }
        if (this.minZ != null && spawnLocation.location.pos.func_177952_p() < this.minZ) {
            return false;
        }
        if (this.maxZ != null && spawnLocation.location.pos.func_177952_p() > this.maxZ) {
            return false;
        }
        if (this.weathers != null && !this.weathers.isEmpty() && !this.weathers.contains((Object)WeatherType.get(spawnLocation.location.world))) {
            return false;
        }
        if (!(spawnLocation.location.world.func_175624_G() == WorldType.field_77138_c && Pixelmon.devEnvironment || this.biomes == null || this.biomes.isEmpty() || this.biomes.contains(spawnLocation.biome))) {
            return false;
        }
        if (this.moonPhase != null && spawnLocation.location.world.field_73011_w.func_76559_b(spawnLocation.location.world.func_72820_D()) != this.moonPhase.intValue()) {
            return false;
        }
        if (this.minLightLevel != null && spawnLocation.light < this.minLightLevel) {
            return false;
        }
        if (this.maxLightLevel != null && spawnLocation.light > this.maxLightLevel) {
            return false;
        }
        if (this.cachedBaseBlocks != null && !this.cachedBaseBlocks.isEmpty() && !this.cachedBaseBlocks.contains(spawnLocation.baseBlock)) {
            return false;
        }
        if (this.cachedNeededNearbyBlocks != null && !this.cachedNeededNearbyBlocks.isEmpty() && !CollectionHelper.containsAll(spawnLocation.uniqueSurroundingBlocks, this.cachedNeededNearbyBlocks)) {
            return false;
        }
        if (spawnInfo.condition.variant != null && !spawnInfo.condition.variant.isEmpty()) {
            IBlockState state = spawnLocation.location.world.func_180495_p((BlockPos)spawnLocation.location.pos);
            int meta = spawnLocation.baseBlock.func_176201_c(state);
            Collection iProperties = spawnLocation.baseBlock.func_176194_O().func_177623_d();
            for (int i = 0; i < iProperties.size(); ++i) {
                IProperty property = (IProperty)iProperties.toArray()[i];
                if (!property.func_177701_a().equalsIgnoreCase("variant")) continue;
                if (meta >= property.func_177700_c().size()) {
                    meta -= 4;
                }
                String name = property.func_177700_c().toArray()[meta].toString();
                for (String variant : spawnInfo.condition.variant) {
                    if (!name.equalsIgnoreCase(variant)) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }
}

