/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.npcs.trainers;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import com.pixelmonmod.pixelmon.api.spawning.SpawnAction;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.npcs.trainers.SpawnInfoNPCTrainer;
import com.pixelmonmod.pixelmon.config.PixelmonEntityList;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.npcs.registry.ServerNPCRegistry;
import com.pixelmonmod.pixelmon.entities.npcs.registry.TrainerData;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.util.helpers.CollectionHelper;
import java.util.ArrayList;
import java.util.function.Function;

public class SpawnActionNPCTrainer
extends SpawnAction<NPCTrainer> {
    public String trainerType = "Youngster";

    public SpawnActionNPCTrainer(SpawnInfoNPCTrainer spawnInfo, SpawnLocation spawnLocation) {
        super(spawnInfo, spawnLocation);
        this.trainerType = spawnInfo.trainerType;
    }

    @Override
    protected NPCTrainer createEntity() {
        NPCTrainer trainer = (NPCTrainer)PixelmonEntityList.createEntityByName(this.trainerType, this.spawnLocation.location.world);
        if (trainer != null) {
            Pokemon pokemon;
            SpawnInfoNPCTrainer spawnInfo = (SpawnInfoNPCTrainer)this.spawnInfo;
            if (spawnInfo.winMoney != -1) {
                trainer.winMoney = spawnInfo.winMoney;
            }
            int level = RandomHelper.getRandomNumberBetween(spawnInfo.minLevel, spawnInfo.maxLevel);
            trainer.setLevel(level);
            for (int i = 0; i < 6; ++i) {
                trainer.getPokemonStorage().set(i, null);
            }
            if (spawnInfo.name != null) {
                trainer.setName(spawnInfo.name);
                trainer.usingDefaultName = false;
            }
            Function<PokemonSpec, Pokemon> createPoke = spec -> {
                Pokemon pokemon = spec.create();
                if (spec.level == null) {
                    pokemon.getLevelContainer().setLevel(level);
                }
                return pokemon;
            };
            int pokemonCount = 0;
            if (spawnInfo.guaranteedPokemon != null && !spawnInfo.guaranteedPokemon.isEmpty()) {
                for (PokemonSpec spec2 : spawnInfo.guaranteedPokemon) {
                    if (!EnumSpecies.hasPokemonAnyCase(spec2.name)) continue;
                    pokemon = createPoke.apply(spec2);
                    ++pokemonCount;
                    trainer.getPokemonStorage().add(pokemon);
                }
            }
            int chosenPartyCount = RandomHelper.getRandomNumberBetween(spawnInfo.minPartySize, spawnInfo.maxPartySize);
            while (chosenPartyCount > pokemonCount && spawnInfo.possiblePokemon != null && !spawnInfo.possiblePokemon.isEmpty()) {
                PokemonSpec randomSpec = CollectionHelper.getRandomElement(spawnInfo.possiblePokemon);
                if (!EnumSpecies.hasPokemonAnyCase(randomSpec.name)) continue;
                pokemon = createPoke.apply(randomSpec);
                trainer.getPokemonStorage().add(pokemon);
                ++pokemonCount;
            }
            if (trainer.getPokemonStorage().countPokemon() == 0) {
                TrainerData data = ServerNPCRegistry.trainers.getRandomData(this.trainerType);
                if (data != null) {
                    ArrayList<Pokemon> randomParty = data.getRandomParty();
                    trainer.loadPokemon(randomParty);
                } else {
                    trainer.getPokemonStorage().add(new PokemonSpec("random", "lvl:" + spawnInfo.minLevel).create());
                }
                block3: while (trainer.getPokemonStorage().countPokemon() > spawnInfo.maxPartySize) {
                    for (int i = 5; i >= 0; --i) {
                        if (trainer.getPokemonStorage().get(i) == null) continue;
                        trainer.getPokemonStorage().set(i, null);
                        continue block3;
                    }
                }
            }
            if (spawnInfo.greeting != null) {
                trainer.usingDefaultGreeting = false;
                trainer.greeting = spawnInfo.greeting;
            }
            if (spawnInfo.winMessage != null) {
                trainer.winMessage = spawnInfo.winMessage;
                trainer.usingDefaultWin = false;
            }
            if (spawnInfo.loseMessage != null) {
                trainer.loseMessage = spawnInfo.loseMessage;
                trainer.usingDefaultLose = false;
            }
            if (spawnInfo.bossMode != null) {
                trainer.setBossMode(spawnInfo.bossMode);
            }
            return trainer;
        }
        return null;
    }
}

