/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.advancements.triggers;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonSpec;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.advancements.PlayerAdvancements;
import net.minecraft.advancements.critereon.AbstractCriterionInstance;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

public class SpecTrigger
implements ICriterionTrigger<Instance> {
    private static final ResourceLocation ID = new ResourceLocation("pixelmon:spec_trigger");
    private final Map<PlayerAdvancements, Listeners> listeners = Maps.newHashMap();

    public ResourceLocation func_192163_a() {
        return ID;
    }

    public void func_192165_a(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        Listeners spectrigger$Listeners = this.listeners.get(playerAdvancementsIn);
        if (spectrigger$Listeners == null) {
            spectrigger$Listeners = new Listeners(playerAdvancementsIn);
            this.listeners.put(playerAdvancementsIn, spectrigger$Listeners);
        }
        spectrigger$Listeners.add(listener);
    }

    public void func_192164_b(PlayerAdvancements playerAdvancementsIn, ICriterionTrigger.Listener<Instance> listener) {
        Listeners spectrigger$Listeners = this.listeners.get(playerAdvancementsIn);
        if (spectrigger$Listeners != null) {
            spectrigger$Listeners.remove(listener);
            if (spectrigger$Listeners.isEmpty()) {
                this.listeners.remove(playerAdvancementsIn);
            }
        }
    }

    public void func_192167_a(PlayerAdvancements playerAdvancementsIn) {
        this.listeners.remove(playerAdvancementsIn);
    }

    public Instance deserializeInstance(JsonObject json, JsonDeserializationContext context) {
        String specJson = json.has("spec") ? JsonUtils.func_151200_h((JsonObject)json, (String)"spec") : "";
        PokemonSpec spec = PokemonSpec.from(specJson);
        return new Instance(this.func_192163_a(), spec, specJson);
    }

    public void trigger(EntityPlayerMP player, Pokemon pokemon) {
        Listeners spectrigger$Listeners = this.listeners.get(player.func_192039_O());
        if (spectrigger$Listeners != null) {
            spectrigger$Listeners.trigger(pokemon);
        }
    }

    static class Listeners {
        private final PlayerAdvancements playerAdvancements;
        private final Set<ICriterionTrigger.Listener<Instance>> listeners = Sets.newHashSet();

        public Listeners(PlayerAdvancements playerAdvancementsIn) {
            this.playerAdvancements = playerAdvancementsIn;
        }

        public boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        public void add(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.add(listener);
        }

        public void remove(ICriterionTrigger.Listener<Instance> listener) {
            this.listeners.remove(listener);
        }

        public void trigger(Pokemon pokemon) {
            List list = null;
            for (ICriterionTrigger.Listener<Instance> listener : this.listeners) {
                if (list == null) {
                    list = Lists.newArrayList();
                }
                list.add(listener);
            }
            if (list != null) {
                for (ICriterionTrigger.Listener listener : list) {
                    if (!((Instance)listener.func_192158_a()).test(pokemon)) continue;
                    listener.func_192159_a(this.playerAdvancements);
                }
            }
        }
    }

    public static class Instance
    extends AbstractCriterionInstance {
        PokemonSpec spec;
        String name;

        public Instance(ResourceLocation criterionIn, PokemonSpec spec, String name) {
            super(criterionIn);
            this.spec = spec;
            this.name = name;
        }

        public boolean test(Pokemon pokemon) {
            if (pokemon != null) {
                return this.spec.matches(pokemon);
            }
            return false;
        }
    }
}

