/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;

public class PixelmonMethods {
    public static ArrayList<EntityPixelmon> getAllActivePokemon(EntityPlayerMP player) {
        ArrayList<EntityPixelmon> list = new ArrayList<EntityPixelmon>(6);
        PlayerPartyStorage party = Pixelmon.storageManager.getParty(player);
        party.getTeam().forEach(pokemon -> pokemon.ifEntityExists(list::add));
        return list;
    }

    public static void toBytesUUID(ByteBuf buf, UUID uuid) {
        buf.writeLong(uuid.getMostSignificantBits());
        buf.writeLong(uuid.getLeastSignificantBits());
    }

    public static UUID fromBytesUUID(ByteBuf buf) {
        return new UUID(buf.readLong(), buf.readLong());
    }

    public static int[] getID(NBTTagCompound nbt) {
        return new int[]{nbt.func_74762_e("pixelmonID1"), nbt.func_74762_e("pixelmonID2")};
    }

    public static boolean isIDSame(int[] id1, int[] id2) {
        if (id1 == null || id2 == null) {
            return false;
        }
        return (id1.length == 2 || id1.length == id2.length) && id1[0] == id2[0] && id1[1] == id2[1];
    }

    public static boolean displacePokemonIfShouldered(EntityPlayerMP player, UUID uuid) {
        NBTTagCompound nbt;
        if (player.func_192023_dk() != null && !(nbt = player.func_192023_dk()).func_82582_d() && nbt.func_186857_a("UUID").equals(uuid)) {
            player.func_192029_h(new NBTTagCompound());
            return true;
        }
        if (player.func_192025_dl() != null && !(nbt = player.func_192025_dl()).func_82582_d() && nbt.func_186857_a("UUID").equals(uuid)) {
            player.func_192031_i(new NBTTagCompound());
            return true;
        }
        return false;
    }
}

