/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.advancements.PixelmonAdvancements;
import com.pixelmonmod.pixelmon.api.events.BattleStartedEvent;
import com.pixelmonmod.pixelmon.api.events.BeatWildPixelmonEvent;
import com.pixelmonmod.pixelmon.api.events.EvolveEvent;
import com.pixelmonmod.pixelmon.api.events.HeldItemChangedEvent;
import com.pixelmonmod.pixelmon.api.events.PixelmonReceivedEvent;
import com.pixelmonmod.pixelmon.api.events.PixelmonSendOutEvent;
import com.pixelmonmod.pixelmon.api.events.battles.BattleEndEvent;
import com.pixelmonmod.pixelmon.api.events.pokemon.MovesetEvent;
import com.pixelmonmod.pixelmon.api.events.spawning.SpawnEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.spawning.archetypes.entities.pokemon.SpawnActionPokemon;
import com.pixelmonmod.pixelmon.api.spawning.conditions.LocationType;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.config.PixelmonItemsHeld;
import com.pixelmonmod.pixelmon.entities.pixelmon.EntityPixelmon;
import com.pixelmonmod.pixelmon.entities.pixelmon.EnumSpecialTexture;
import com.pixelmonmod.pixelmon.entities.pixelmon.abilities.Competitive;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.Gender;
import com.pixelmonmod.pixelmon.entities.pixelmon.stats.extraStats.MeltanStats;
import com.pixelmonmod.pixelmon.enums.EnumSpecies;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.enums.forms.EnumArceus;
import com.pixelmonmod.pixelmon.enums.forms.EnumCherrim;
import com.pixelmonmod.pixelmon.enums.forms.EnumGenesect;
import com.pixelmonmod.pixelmon.enums.forms.EnumGiratina;
import com.pixelmonmod.pixelmon.enums.forms.EnumHoopa;
import com.pixelmonmod.pixelmon.enums.forms.EnumKeldeo;
import com.pixelmonmod.pixelmon.enums.forms.EnumShaymin;
import com.pixelmonmod.pixelmon.enums.forms.EnumSilvally;
import com.pixelmonmod.pixelmon.enums.forms.EnumVivillon;
import com.pixelmonmod.pixelmon.items.ItemMemory;
import com.pixelmonmod.pixelmon.items.ItemPixelmonSprite;
import com.pixelmonmod.pixelmon.items.heldItems.ItemPlate;
import com.pixelmonmod.pixelmon.items.heldItems.ItemZCrystal;
import com.pixelmonmod.pixelmon.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.util.helpers.CollectionHelper;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class PixelmonEventHandler {
    @SubscribeEvent
    public void onBeatPokemon(BeatWildPixelmonEvent event) {
        PixelmonAdvancements.throwBattleTriggers(event.player);
        if (!PixelmonConfig.awardTokens) {
            return;
        }
        for (PixelmonWrapper wrapper : event.wpp.controlledPokemon) {
            EntityPixelmon pokemon = wrapper.entity;
            event.player.field_71071_by.func_70441_a(ItemPixelmonSprite.getPhoto(pokemon.getPokemonData()));
        }
    }

    @SubscribeEvent
    public void christmasGifts(BeatWildPixelmonEvent event) {
        String pokename = event.wpp.getName().func_150260_c();
        if (pokename.equalsIgnoreCase("delibird")) {
            PlayerPartyStorage party = Pixelmon.storageManager.getParty(event.player);
            String[] date = party.playerData.getDate();
            int day = Integer.parseInt(date[2]);
            if (date[1].equalsIgnoreCase("12")) {
                if (day >= 20 && day <= 31 && !party.playerData.getWasGifted()) {
                    ChatHandler.sendChat((Entity)event.player, "christmas.received", new Object[0]);
                    event.player.field_71071_by.func_70441_a(new ItemStack(PixelmonItems.gift));
                    party.playerData.receivedGift();
                }
            } else {
                return;
            }
        }
    }

    @SubscribeEvent
    public void onHeldItemChanged(HeldItemChangedEvent event) {
        if (event.getSpecies() == EnumSpecies.Giratina) {
            EnumGiratina curForm;
            EnumGiratina newForm = curForm = (EnumGiratina)event.pokemon.getFormEnum();
            if (curForm == EnumGiratina.ALTERED && event.newHeldItem.func_77973_b() == PixelmonItemsHeld.griseous_orb) {
                newForm = EnumGiratina.ORIGIN;
            } else if (curForm == EnumGiratina.ORIGIN && (event.newHeldItem.func_190926_b() || event.newHeldItem.func_77973_b() != PixelmonItemsHeld.griseous_orb)) {
                newForm = EnumGiratina.ALTERED;
            }
            if (curForm != newForm) {
                event.pokemon.setForm(newForm);
                if (event.player != null) {
                    ChatHandler.sendChat((Entity)event.player, "pixelmon.abilities.changeform", "Giratina");
                }
            }
        } else if (event.getSpecies() == EnumSpecies.Arceus) {
            EnumType type;
            EnumArceus newForm;
            EnumArceus curForm = (EnumArceus)event.pokemon.getFormEnum();
            if (curForm != (newForm = EnumArceus.getForm(type = event.newHeldItem.func_190926_b() || !(event.newHeldItem.func_77973_b() instanceof ItemPlate) && !(event.newHeldItem.func_77973_b() instanceof ItemZCrystal) ? EnumType.Normal : (event.newHeldItem.func_77973_b() instanceof ItemPlate ? ((ItemPlate)event.newHeldItem.func_77973_b()).getType() : ((ItemZCrystal)event.newHeldItem.func_77973_b()).type.affiliatedType)))) {
                event.pokemon.setForm(newForm);
            }
        } else if (event.getSpecies() == EnumSpecies.Silvally) {
            Item item;
            EnumSilvally curForm = (EnumSilvally)event.pokemon.getFormEnum();
            EnumSilvally newForm = EnumSilvally.NORMAL;
            if (!event.newHeldItem.func_190926_b() && (item = event.newHeldItem.func_77973_b()) instanceof ItemMemory) {
                newForm = EnumSilvally.getForm(((ItemMemory)item).type);
            }
            if (curForm != newForm) {
                event.pokemon.setForm(newForm);
            }
        } else if (event.getSpecies() == EnumSpecies.Genesect) {
            EnumGenesect curForm = (EnumGenesect)event.pokemon.getFormEnum();
            EnumGenesect newForm = EnumGenesect.NORMAL;
            if (!event.newHeldItem.func_190926_b()) {
                Item item = event.newHeldItem.func_77973_b();
                if (item == PixelmonItemsHeld.burnDrive) {
                    newForm = EnumGenesect.BURN;
                } else if (item == PixelmonItemsHeld.chillDrive) {
                    newForm = EnumGenesect.CHILL;
                } else if (item == PixelmonItemsHeld.douseDrive) {
                    newForm = EnumGenesect.DOUSE;
                } else if (item == PixelmonItemsHeld.shockDrive) {
                    newForm = EnumGenesect.SHOCK;
                }
            }
            if (curForm != newForm) {
                event.pokemon.setForm(newForm);
                if (event.player != null) {
                    ChatHandler.sendChat((Entity)event.player, "pixelmon.abilities.changeform", "Genesect");
                }
            }
        }
    }

    @SubscribeEvent
    public void onSentOut(PixelmonSendOutEvent event) {
        if (event.pokemon.getSpecies() == EnumSpecies.Shaymin) {
            if (event.pokemon.getFormEnum() == EnumShaymin.SKY && !event.player.func_71121_q().func_72935_r()) {
                event.pokemon.setForm(EnumShaymin.LAND);
                ChatHandler.sendChat((Entity)event.player, "pixelmon.abilities.changeform", event.pokemon.getDisplayName());
            }
        } else if (event.pokemon.getSpecies() == EnumSpecies.Cherrim) {
            if (event.pokemon.getFormEnum() == EnumCherrim.SUNSHINE) {
                event.pokemon.setForm(EnumCherrim.OVERCAST);
            }
        } else if (event.pokemon.getSpecies() == EnumSpecies.Hoopa && event.pokemon.getFormEnum() == EnumHoopa.UNBOUND && System.currentTimeMillis() > event.pokemon.getPersistentData().func_74763_f("unboundTime") + 3600000L) {
            event.pokemon.setForm(EnumHoopa.CONFINED);
            event.pokemon.getPersistentData().func_82580_o("unboundTime");
            ChatHandler.sendChat((Entity)event.player, "pixelmon.abilities.changeform", event.pokemon.getDisplayName());
        }
    }

    @SubscribeEvent
    public void onBattleEnd(BattleEndEvent event) {
        for (BattleParticipant bp : event.bc.participants) {
            if (bp.getStorage() == null) continue;
            for (Pokemon pokemon : bp.getStorage().getTeam()) {
                if (!pokemon.isPokemon(EnumSpecies.Meloetta, EnumSpecies.Xerneas, EnumSpecies.Kyogre, EnumSpecies.Groudon, EnumSpecies.Aegislash, EnumSpecies.Darmanitan)) continue;
                pokemon.setForm(0);
            }
        }
    }

    @SubscribeEvent
    public void onBattleStart(BattleStartedEvent event) {
        event.bc.participants.forEach(bp -> {
            if (bp.getStorage() != null) {
                for (Pokemon pokemon : bp.getStorage().getTeam()) {
                    if (pokemon.getSpecies() != EnumSpecies.Xerneas) continue;
                    pokemon.setForm(1);
                }
            }
            for (PixelmonWrapper pw : bp.controlledPokemon) {
                if (pw == null || pw.getSpecies() != EnumSpecies.Xerneas) continue;
                pw.setForm(1);
            }
        });
    }

    @SubscribeEvent
    public void onMoveLearned(MovesetEvent.LearntMoveEvent event) {
        if (event.pokemon.getSpecies() == EnumSpecies.Keldeo) {
            if (event.learntAttack.isAttack("Secret Sword") && event.pokemon.getForm() != EnumKeldeo.RESOLUTE.getForm()) {
                event.pokemon.setForm(EnumKeldeo.RESOLUTE.getForm());
            } else if (!event.moveset.hasAttack("Secret Sword") && event.pokemon.getForm() == EnumKeldeo.RESOLUTE.getForm()) {
                event.pokemon.setForm(EnumKeldeo.ORDINARY.getForm());
            }
        }
    }

    @SubscribeEvent
    public void onMoveForgot(MovesetEvent.ForgotMoveEvent event) {
        if (event.pokemon.getSpecies() == EnumSpecies.Keldeo && event.forgottenAttack.isAttack("Secret Sword")) {
            event.pokemon.setForm(EnumKeldeo.ORDINARY.getForm());
        }
    }

    @SubscribeEvent
    public void onPostEvo(EvolveEvent.PostEvolve event) {
        if (event.pokemon.getSpecies() == EnumSpecies.Vivillon) {
            Biome biome = event.pokemon.func_130014_f_().func_180494_b(event.pokemon.func_180425_c());
            EnumVivillon vivillon = EnumVivillon.findFormForBiome(biome);
            event.pokemon.setForm(vivillon.getForm());
        } else if (event.pokemon.getSpecies() == EnumSpecies.Meowstic && event.pokemon.getPokemonData().getGender() == Gender.Female) {
            event.pokemon.setForm(1);
            if (event.pokemon.getPokemonData().getAbilitySlot() == 2) {
                event.pokemon.getPokemonData().setAbility(new Competitive());
            }
        }
    }

    @SubscribeEvent
    public void onPokemonSpawn(SpawnEvent event) {
        if (event.action instanceof SpawnActionPokemon) {
            EntityPixelmon pokemon;
            SpawnActionPokemon spawnPokemon = (SpawnActionPokemon)event.action;
            if (EnumSpecies.Magikarp.name.equals(spawnPokemon.usingSpec.name) && CollectionHelper.anyMatch(event.action.spawnLocation.types, Arrays.asList(LocationType.LAVA, LocationType.OLD_ROD_LAVA, LocationType.GOOD_ROD_LAVA, LocationType.SUPER_ROD_LAVA)) && (pokemon = (EntityPixelmon)((Object)spawnPokemon.getOrCreateEntity())) != null) {
                pokemon.getPokemonData().setSpecialTexture(EnumSpecialTexture.Roasted);
                pokemon.update(EnumUpdateType.Texture);
            }
        }
    }

    @SubscribeEvent
    public void onReceive(PixelmonReceivedEvent event) {
        EntityPlayerMP player = event.player;
        PixelmonAdvancements.POKEDEX_TRIGGER.trigger(player);
    }

    @SubscribeEvent
    public void onSmelt(PlayerEvent.ItemSmeltedEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            Item item = event.smelting.func_77973_b();
            if (item == Items.field_151042_j || item == Items.field_151043_k || item == PixelmonItems.aluminiumIngot || item == PixelmonItems.siliconItem) {
                PlayerPartyStorage pps = Pixelmon.storageManager.getParty(player);
                if (pps != null) {
                    for (Pokemon pokemon : pps.getTeam()) {
                        if (pokemon.getSpecies() != EnumSpecies.Meltan) continue;
                        MeltanStats meltanStats = (MeltanStats)pokemon.getExtraStats();
                        meltanStats.oresSmelted += event.smelting.func_190916_E();
                        pokemon.markDirty(EnumUpdateType.Stats);
                        break;
                    }
                }
                for (int i = 0; i < event.smelting.func_190916_E(); ++i) {
                    Pokemon pokemon;
                    if (!PixelmonConfig.allowLegendariesSpawn || player.field_70170_p.field_73012_v.nextInt(PixelmonConfig.meltanSpawnChance) != 0) continue;
                    pokemon = Pixelmon.pokemonFactory.create(EnumSpecies.Meltan);
                    int meltanRadius = 5;
                    pokemon.getOrSpawnPixelmon((World)player.func_71121_q(), player.field_70165_t + (double)RandomHelper.getRandomNumberBetween(-meltanRadius, meltanRadius), player.field_70163_u + 0.5, player.field_70161_v + (double)RandomHelper.getRandomNumberBetween(-meltanRadius, meltanRadius));
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    public static void structureVoid(PlayerInteractEvent.RightClickBlock event) {
        if (Pixelmon.devEnvironment && event.getEntityPlayer() instanceof EntityPlayerMP && event.getHand() == EnumHand.MAIN_HAND && event.getFace() != null && event.getItemStack().func_77973_b() == Item.func_150898_a((Block)Blocks.field_189881_dj) && event.getWorld().func_180495_p(new BlockPos(event.getHitVec())).func_177230_c() == Blocks.field_189881_dj) {
            BlockPos pos = event.getPos().func_177972_a(event.getFace());
            for (int i = 0; i < event.getItemStack().func_190916_E(); ++i) {
                event.getWorld().func_175656_a(pos, Blocks.field_189881_dj.func_176223_P());
                event.getWorld().func_184133_a(null, pos, SoundEvents.field_187845_fY, SoundCategory.BLOCKS, 1.0f, 1.0f);
                pos = pos.func_177972_a(event.getFace());
            }
        }
    }
}

