/*
 * Decompiled with CFR 0.152.
 */
package com.mcbans.plugin.util;

import com.mcbans.plugin.MCBans;
import com.mcbans.plugin.permission.Perms;
import com.mcbans.plugin.util.VaultStuff;
import java.util.Collection;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.RegisteredServiceProvider;

public class Util {
    private static final String IP_PATTERN = "^([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])$";

    public static void message(CommandSender target, String msg) {
        if (msg != null) {
            msg = MCBans.getPrefix() + ChatColor.WHITE + msg;
            if (target != null && target instanceof Player) {
                target.sendMessage(msg);
            } else {
                Bukkit.getServer().getConsoleSender().sendMessage(msg);
            }
        }
    }

    public static void message(String playerName, String msg) {
        Player target = Bukkit.getServer().getPlayer(playerName);
        Util.message((CommandSender)target, msg);
    }

    public static void broadcastMessage(String msg) {
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            if (!Perms.ANNOUNCE.has((Permissible)player) && !MCBans.AnnounceAll) continue;
            player.sendMessage(MCBans.getPrefix() + msg);
        }
    }

    public static String color(String msg) {
        return msg.replaceAll("&([0-9a-fA-Fk-oK-OrR])", "\u00a7$1");
    }

    public static String join(Collection<?> s, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        Iterator<?> iter = s.iterator();
        while (iter.hasNext()) {
            buffer.append(iter.next());
            if (!iter.hasNext()) continue;
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    public static boolean isValidName(String name) {
        if (name == null) {
            return false;
        }
        String regex = "^[A-Za-z0-9_]{2,16}$";
        return Pattern.compile("^[A-Za-z0-9_]{2,16}$").matcher(name).matches();
    }

    public static boolean isValidUUID(String name) {
        if (name == null) {
            return false;
        }
        String regex = "^[A-Za-z0-9_]{32}$";
        return Pattern.compile("^[A-Za-z0-9_]{32}$").matcher(name.replaceAll("(?im)-", "")).matches();
    }

    public static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean isDouble(String str) {
        try {
            Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public static boolean isValidIP(String str) {
        if (str == null) {
            return false;
        }
        Matcher matcher = Pattern.compile(IP_PATTERN).matcher(str);
        return matcher.matches();
    }

    public static boolean checkVault(Player sender, OfflinePlayer victim) {
        if (!VaultStuff.hasVault()) {
            return true;
        }
        try {
            Chat c = (Chat)((RegisteredServiceProvider)VaultStuff.getChat()).getProvider();
            Permission p = (Permission)((RegisteredServiceProvider)VaultStuff.getPerms()).getProvider();
            int gpri = c.getGroupInfoInteger("", p.getPrimaryGroup(sender), "mcbansPriority", 0);
            int gpri2 = c.getGroupInfoInteger("", p.getPrimaryGroup("", victim), "mcbansPriority", 0);
            if (gpri > gpri2) {
                return true;
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return true;
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            return true;
        }
        return false;
    }
}

