/*
 * Decompiled with CFR 0.152.
 */
package com.mcbans.plugin.util;

import com.mcbans.plugin.ActionLog;
import com.mcbans.plugin.MCBans;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;

public class FileStructure {
    public static void createDir(File dir) {
        if (dir.isDirectory()) {
            return;
        }
        if (!dir.mkdir()) {
            ActionLog.getInstance().warning("Cannot create directory: " + dir.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyTransfer(String srcPath, String destPath) throws IOException {
        AbstractInterruptibleChannel srcChannel = null;
        AbstractInterruptibleChannel destChannel = null;
        try {
            srcChannel = new FileInputStream(srcPath).getChannel();
            destChannel = new FileOutputStream(destPath).getChannel();
            ((FileChannel)srcChannel).transferTo(0L, ((FileChannel)srcChannel).size(), (WritableByteChannel)((Object)destChannel));
        }
        finally {
            srcChannel.close();
            destChannel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractResource(String from, File to, boolean force, boolean lang) {
        File of = to;
        if (to.isDirectory()) {
            String filename = new File(from).getName();
            of = new File(to, filename);
        } else if (!of.isFile()) {
            ActionLog.getInstance().warning("Not a file:" + of);
            return;
        }
        if (of.exists() && !force) {
            return;
        }
        OutputStream out = null;
        InputStream in = null;
        InputStreamReader reader = null;
        OutputStreamWriter writer = null;
        try {
            URL res = MCBans.class.getResource(from);
            if (res == null) {
                ActionLog.getInstance().warning("Can't find " + from + " in plugin jar file");
                return;
            }
            URLConnection resConn = res.openConnection();
            resConn.setUseCaches(false);
            in = resConn.getInputStream();
            if (in == null) {
                ActionLog.getInstance().warning("Can't get input stream from " + res);
            } else if (lang) {
                int text;
                reader = new InputStreamReader(in, "UTF-8");
                writer = new OutputStreamWriter(new FileOutputStream(of));
                while ((text = reader.read()) != -1) {
                    writer.write(text);
                }
            } else {
                out = new FileOutputStream(of);
                byte[] buf = new byte[1024];
                int len = 0;
                while ((len = in.read(buf)) >= 0) {
                    out.write(buf, 0, len);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static File getPluginDir() {
        return MCBans.getInstance().getDataFolder();
    }
}

