/*
 * Decompiled with CFR 0.152.
 */
package com.mcbans.plugin.rollback;

import com.mcbans.plugin.ActionLog;
import com.mcbans.plugin.MCBans;
import com.mcbans.plugin.rollback.BaseRollback;
import com.mcbans.plugin.rollback.CpRollback;
import com.mcbans.plugin.rollback.HeRollback;
import com.mcbans.plugin.rollback.LbRollback;
import de.diddiz.LogBlock.LogBlock;
import net.coreprotect.CoreProtect;
import net.coreprotect.CoreProtectAPI;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import uk.co.oliwali.HawkEye.HawkEye;

public class RollbackHandler {
    private final MCBans plugin;
    private final ActionLog log;
    private BaseRollback method = null;

    public RollbackHandler(MCBans plugin) {
        this.plugin = plugin;
        this.log = plugin.getLog();
    }

    public boolean setupHandler() {
        PluginManager pm = this.plugin.getServer().getPluginManager();
        Plugin check = pm.getPlugin("LogBlock");
        if (check != null && check instanceof LogBlock && check.isEnabled()) {
            this.method = new LbRollback(this.plugin);
            if (this.method.setPlugin(check)) {
                this.log.info("LogBlock found. Using LogBlock for rollbacks.");
                return true;
            }
        }
        if ((check = pm.getPlugin("HawkEye")) != null && check instanceof HawkEye && check.isEnabled()) {
            this.method = new HeRollback(this.plugin);
            this.log.info("HawkEye found. Using HawkEye for rollbacks.");
            return true;
        }
        check = pm.getPlugin("CoreProtect");
        if (check != null && check instanceof CoreProtect && check.isEnabled()) {
            CoreProtectAPI cpAPI = ((CoreProtect)check).getAPI();
            if (cpAPI.isEnabled()) {
                this.method = new CpRollback(this.plugin);
                this.method.setPlugin(check);
                this.log.info("CoreProtect found. Using CoreProtect for rollback.");
                return true;
            }
            this.log.info("CoreProtect plugin found but the API is disabled.");
            this.log.info("Change 'api-enabled' value of CoreProtect config.yml and restart your server.");
        }
        this.log.info("Rollback plugin not found.");
        this.method = null;
        return false;
    }

    public boolean rollback(String senderName, String target) {
        if (this.method == null) {
            return false;
        }
        Player sender = this.plugin.getServer().getPlayer(senderName);
        if (sender == null) {
            sender = this.plugin.getServer().getPlayer(target);
        }
        if (sender == null) {
            sender = this.plugin.getServer().getConsoleSender();
        }
        return this.method.rollback((CommandSender)sender, senderName, target);
    }

    public boolean hasRollbackMethod() {
        return this.method != null;
    }
}

