/*
 * Decompiled with CFR 0.152.
 */
package com.mcbans.plugin.rollback;

import com.mcbans.plugin.MCBans;
import com.mcbans.plugin.rollback.BaseRollback;
import com.mcbans.plugin.util.Util;
import de.diddiz.LogBlock.CommandsHandler;
import de.diddiz.LogBlock.LogBlock;
import de.diddiz.LogBlock.QueryParams;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class LbRollback
extends BaseRollback {
    private LogBlock logblock;

    public LbRollback(MCBans plugin) {
        super(plugin);
    }

    @Override
    public boolean rollback(CommandSender sender, String senderName, String target) {
        if (this.logblock == null) {
            return false;
        }
        Util.message(senderName, ChatColor.GREEN + "Starting rollback...");
        for (String world : this.worlds) {
            QueryParams params = null;
            try {
                params = new QueryParams(this.logblock);
                params.setPlayer(target);
                if (this.plugin.getConfigs().getBackDaysAgo() > 0) {
                    params.since = 1440 * this.plugin.getConfigs().getBackDaysAgo();
                }
                params.world = this.plugin.getServer().getWorld(world);
                params.silent = false;
                CommandsHandler commandsHandler = this.logblock.getCommandsHandler();
                commandsHandler.getClass();
                new CommandsHandler.CommandRollback(commandsHandler, sender, params, true);
            }
            catch (Exception e) {
                Util.message(senderName, ChatColor.RED + "Unable to rollback player.");
                if (this.plugin.getConfigs().isDebug()) {
                    e.printStackTrace();
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean setPlugin(Plugin plugin) {
        if (plugin == null) {
            return false;
        }
        if (plugin instanceof LogBlock) {
            this.logblock = (LogBlock)plugin;
            return true;
        }
        return false;
    }
}

