/*
 * Decompiled with CFR 0.152.
 */
package com.mcbans.plugin.rollback;

import com.mcbans.plugin.MCBans;
import com.mcbans.plugin.rollback.BaseRollback;
import com.mcbans.plugin.util.Util;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import uk.co.oliwali.HawkEye.PlayerSession;
import uk.co.oliwali.HawkEye.Rollback;
import uk.co.oliwali.HawkEye.SearchParser;
import uk.co.oliwali.HawkEye.SessionManager;
import uk.co.oliwali.HawkEye.callbacks.BaseCallback;
import uk.co.oliwali.HawkEye.callbacks.RollbackCallback;
import uk.co.oliwali.HawkEye.database.SearchQuery;

public class HeRollback
extends BaseRollback {
    public HeRollback(MCBans plugin) {
        super(plugin);
    }

    @Override
    public boolean rollback(CommandSender sender, String senderName, String target) {
        PlayerSession session = SessionManager.getSession((CommandSender)sender);
        if (session.doingRollback()) {
            Util.message(senderName, ChatColor.RED + "Unable to rollback player. You already have a rollback processing.");
            return false;
        }
        SearchParser parser = null;
        try {
            parser = new SearchParser();
            parser.players.add(target);
            parser.worlds = this.worlds;
            if (this.plugin.getConfigs().getBackDaysAgo() > 0) {
                Calendar cal = Calendar.getInstance();
                cal.add(5, -1 * this.plugin.getConfigs().getBackDaysAgo());
                parser.dateFrom = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(cal.getTime());
            }
            Util.message(senderName, ChatColor.GREEN + "Starting rollback...");
            new SearchQuery((BaseCallback)new RollbackCallback(session, Rollback.RollbackType.GLOBAL), parser, SearchQuery.SearchDir.DESC);
        }
        catch (Exception e) {
            Util.message(senderName, ChatColor.RED + "Unable to rollback player.");
            if (this.plugin.getConfigs().isDebug()) {
                e.printStackTrace();
            }
            return false;
        }
        return true;
    }
}

