/*
 * Decompiled with CFR 0.152.
 */
package com.mcbans.plugin.request;

import com.mcbans.plugin.ActionLog;
import com.mcbans.plugin.MCBans;
import com.mcbans.plugin.callBacks.PreviousCallback;
import com.mcbans.plugin.org.json.JSONException;
import com.mcbans.plugin.org.json.JSONObject;
import com.mcbans.plugin.request.BaseRequest;
import org.bukkit.ChatColor;

public class PreviousNames
extends BaseRequest<PreviousCallback> {
    public String target = "";

    public PreviousNames(MCBans plugin, PreviousCallback callback, String target, String targetUUID, String sender) {
        super(plugin, callback);
        this.items.put("player", target);
        this.items.put("player_uuid", targetUUID);
        this.items.put("admin", sender);
        this.items.put("exec", "uuidLookup");
        this.target = !target.equals("") ? target : targetUUID;
    }

    @Override
    protected void execute() {
        block9: {
            if (((PreviousCallback)this.callback).getSender() != null) {
                this.log.info(((PreviousCallback)this.callback).getSender().getName() + " performed a player history lookup for " + this.target + "!");
            }
            JSONObject result = this.request_JOBJ();
            try {
                ((PreviousCallback)this.callback).success(result.getString("player"), result.getString("players"));
            }
            catch (JSONException ex) {
                if (result.toString().contains("error")) {
                    if (result.toString().contains("dne")) {
                        ((PreviousCallback)this.callback).error("Player record not found: " + this.target);
                        return;
                    }
                    if (result.toString().contains("Server Disabled")) {
                        ActionLog.getInstance().severe("This server has been disabled by MCBans staff.");
                        ActionLog.getInstance().severe("To appeal this decision, please file ticket on forums.mcbans.com");
                        ((PreviousCallback)this.callback).error("This server has been disabled by MCBans staff.");
                        return;
                    }
                }
                ActionLog.getInstance().severe("A JSON error occurred while trying to localize player name history data.");
                ((PreviousCallback)this.callback).error("An error occurred while parsing JSON data.");
            }
            catch (NullPointerException ex) {
                ActionLog.getInstance().severe("Unable to reach MCBans API server!");
                ((PreviousCallback)this.callback).error(ChatColor.RED + "Unable to reach MCBans API server!");
                if (this.plugin.getConfigs().isDebug()) {
                    ex.printStackTrace();
                }
            }
            catch (Exception ex) {
                ((PreviousCallback)this.callback).error("Unknown Error: " + ex.getMessage());
                if (!this.plugin.getConfigs().isDebug()) break block9;
                ex.printStackTrace();
            }
        }
    }
}

