/*
 * Decompiled with CFR 0.152.
 */
package com.mcbans.plugin.request;

import com.mcbans.plugin.ActionLog;
import com.mcbans.plugin.MCBans;
import com.mcbans.plugin.callBacks.MCBansSettingsCallback;
import com.mcbans.plugin.org.json.JSONException;
import com.mcbans.plugin.org.json.JSONObject;
import com.mcbans.plugin.request.BaseRequest;
import org.bukkit.ChatColor;

public class MCBansSettings
extends BaseRequest<MCBansSettingsCallback> {
    public String commands = "";
    public String sender = "";

    public MCBansSettings(MCBans plugin, MCBansSettingsCallback callback, String sender, String commands) {
        super(plugin, callback);
        this.commands = commands;
        this.sender = sender;
        this.items.put("admin", sender);
        this.items.put("setting", commands);
        this.items.put("exec", "setting");
    }

    @Override
    protected void execute() {
        block9: {
            if (((MCBansSettingsCallback)this.callback).getSender() != null) {
                this.log.info(((MCBansSettingsCallback)this.callback).getSender().getName() + " executed setting change <" + this.commands + ">!");
            }
            JSONObject result = this.request_JOBJ();
            try {
                ((MCBansSettingsCallback)this.callback).success(result.getString("result"), result.getString("reason"));
            }
            catch (JSONException ex) {
                if (result.toString().contains("error")) {
                    if (result.toString().contains("dne")) {
                        ((MCBansSettingsCallback)this.callback).error("Could not execute settings change: <" + this.commands + ">");
                        return;
                    }
                    if (result.toString().contains("Server Disabled")) {
                        ActionLog.getInstance().severe("This server has been disabled by MCBans staff.");
                        ActionLog.getInstance().severe("To appeal this decision, please file a ticket at forums.mcbans.com.");
                        ((MCBansSettingsCallback)this.callback).error("This server has been disabled by MCBans staff.");
                        return;
                    }
                }
                ActionLog.getInstance().severe("A JSON error occurred while trying to change server settings.");
                ((MCBansSettingsCallback)this.callback).error("An error occurred while parsing JSON data.");
            }
            catch (NullPointerException ex) {
                ActionLog.getInstance().severe("Unable to reach the MCBans API server!");
                ((MCBansSettingsCallback)this.callback).error(ChatColor.RED + "Unable to reach the MCBans API server!");
                if (this.plugin.getConfigs().isDebug()) {
                    ex.printStackTrace();
                }
            }
            catch (Exception ex) {
                ((MCBansSettingsCallback)this.callback).error("Unknown Error: " + ex.getMessage());
                if (!this.plugin.getConfigs().isDebug()) break block9;
                ex.printStackTrace();
            }
        }
    }
}

