/*
 * Decompiled with CFR 0.152.
 */
package com.mcbans.plugin.request;

import com.mcbans.plugin.ActionLog;
import com.mcbans.plugin.MCBans;
import com.mcbans.plugin.api.data.PlayerLookupData;
import com.mcbans.plugin.callBacks.LookupCallback;
import com.mcbans.plugin.org.json.JSONException;
import com.mcbans.plugin.org.json.JSONObject;
import com.mcbans.plugin.request.BaseRequest;
import org.bukkit.ChatColor;

public class LookupRequest
extends BaseRequest<LookupCallback> {
    private String targetName;

    public LookupRequest(MCBans plugin, LookupCallback callback, String playerName, String playerUUID, String senderName, String senderUUID) {
        super(plugin, callback);
        if (!playerUUID.equals("")) {
            this.items.put("player_uuid", playerUUID);
        } else {
            this.items.put("player", playerName);
        }
        this.items.put("admin", senderName);
        this.items.put("admin_uuid", senderUUID);
        this.items.put("exec", "playerLookup");
        this.targetName = playerName;
    }

    public LookupRequest(MCBans plugin, LookupCallback callback, String playerName, String senderName) {
        super(plugin, callback);
        this.items.put("player", playerName);
        this.items.put("admin", senderName);
        this.items.put("exec", "playerLookup");
        this.targetName = playerName;
    }

    @Override
    protected void execute() {
        block7: {
            if (((LookupCallback)this.callback).getSender() != null) {
                this.log.info(((LookupCallback)this.callback).getSender().getName() + " has looked up the " + this.targetName + "!");
            }
            JSONObject result = this.request_JOBJ();
            try {
                ((LookupCallback)this.callback).success(new PlayerLookupData(this.targetName, result));
            }
            catch (JSONException ex) {
                if (result.toString().contains("error") && result.toString().contains("Server Disabled")) {
                    ActionLog.getInstance().severe("This server has been disabled by MCBans staff.");
                    ActionLog.getInstance().severe("To appeal this decision, please file a ticket at forums.mcbans.com.");
                    ((LookupCallback)this.callback).error("This server has been disabled by MCBans staff.");
                    return;
                }
                ActionLog.getInstance().severe("A JSON error occurred while trying to localize lookup data.");
                ((LookupCallback)this.callback).error("An error occurred while parsing JSON data.");
            }
            catch (NullPointerException ex) {
                ActionLog.getInstance().severe("Unable to reach the MCBans API!");
                ((LookupCallback)this.callback).error(ChatColor.RED + "Unable to reach the MCBans API!");
                if (this.plugin.getConfigs().isDebug()) {
                    ex.printStackTrace();
                }
            }
            catch (Exception ex) {
                ((LookupCallback)this.callback).error("Unknown Error: " + ex.getMessage());
                if (!this.plugin.getConfigs().isDebug()) break block7;
                ex.printStackTrace();
            }
        }
    }
}

