/*
 * Decompiled with CFR 0.152.
 */
package com.mcbans.plugin.request;

import com.mcbans.plugin.I18n;
import com.mcbans.plugin.MCBans;
import com.mcbans.plugin.events.PlayerKickEvent;
import com.mcbans.plugin.permission.Perms;
import com.mcbans.plugin.util.Util;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class Kick {
    private final MCBans plugin;
    private final String playerName;
    private final String senderName;
    private String reason;
    private String senderUUID;
    private String playerUUID;
    private final boolean useExactName;

    public Kick(MCBans plugin, String playerName, String playerUUID, String senderName, String senderUUID, String reason, boolean useExactName) {
        this.plugin = plugin;
        this.playerName = playerName;
        this.senderName = senderName;
        this.reason = reason;
        this.useExactName = useExactName;
        this.senderUUID = senderUUID;
        this.playerUUID = playerUUID;
    }

    @Deprecated
    public Kick(MCBans plugin, String playerName, String senderName, String reason) {
        this(plugin, playerName, "", senderName, "", reason, false);
    }

    public void run() {
        Player playertmp = null;
        playertmp = !this.playerUUID.equals("") ? MCBans.getPlayer((Plugin)this.plugin, this.playerUUID) : (this.useExactName ? this.plugin.getServer().getPlayerExact(this.playerName) : this.plugin.getServer().getPlayer(this.playerName));
        final Player player = playertmp;
        if (player != null) {
            if (Perms.EXEMPT_KICK.has((Permissible)player)) {
                Util.message(this.senderName, ChatColor.RED + I18n.localize("kickExemptPlayer", "%PLAYER%", player.getName()));
                return;
            }
            PlayerKickEvent kickEvent = new PlayerKickEvent(player.getName(), this.playerUUID, this.senderName, this.senderUUID, this.reason);
            this.plugin.getServer().getPluginManager().callEvent((Event)kickEvent);
            if (kickEvent.isCancelled()) {
                return;
            }
            this.reason = kickEvent.getReason();
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    player.kickPlayer(I18n.localize("kickPlayer", "%PLAYER%", player.getName(), "%ADMIN%", Kick.this.senderName, "%REASON%", Kick.this.reason));
                }
            }, 0L);
            Util.broadcastMessage(ChatColor.GREEN + I18n.localize("kickSuccess", "%PLAYER%", player.getName(), "%ADMIN%", this.senderName, "%REASON%", this.reason));
            this.plugin.getLog().info(this.senderName + " has kicked " + player.getName() + " [" + this.reason + "]");
        } else {
            Util.message(this.senderName, ChatColor.RED + I18n.localize("kickNoPlayer", "%PLAYER%", this.playerName));
        }
    }
}

