/*
 * Decompiled with CFR 0.152.
 */
package com.mcbans.plugin.request;

import com.mcbans.plugin.ActionLog;
import com.mcbans.plugin.ConfigurationManager;
import com.mcbans.plugin.MCBans;
import com.mcbans.plugin.org.json.JSONException;
import com.mcbans.plugin.org.json.JSONObject;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class JsonHandler {
    private final MCBans plugin;
    private final ActionLog log;
    private final ConfigurationManager config;

    public JsonHandler(MCBans plugin) {
        this.plugin = plugin;
        this.log = plugin.getLog();
        this.config = plugin.getConfigs();
    }

    public JSONObject get_data(String json_text) {
        try {
            return new JSONObject(json_text);
        }
        catch (JSONException e) {
            if (this.config.isDebug()) {
                e.printStackTrace();
            }
            return null;
        }
    }

    public HashMap<String, String> mainRequest(HashMap<String, String> items) {
        Iterator i;
        HashMap<String, String> out = new HashMap<String, String>();
        String url_req = this.urlparse(items);
        String json_text = this.request_from_api(url_req);
        if (this.config.isDebug()) {
            this.log.info("Requested: '" + url_req + "'");
            this.log.info("Converting response '" + json_text + "'");
        }
        if (json_text == null || json_text.length() <= 0) {
            if (this.config.isDebug()) {
                this.log.severe("Null Response. Please contact an MCBans developer.");
            }
            out.clear();
            return out;
        }
        JSONObject output = this.get_data(json_text);
        if (output != null && (i = output.keys()) != null) {
            while (i.hasNext()) {
                String next = (String)i.next();
                try {
                    out.put(next, output.getString(next));
                }
                catch (JSONException e) {
                    if (!this.config.isDebug()) continue;
                    this.log.severe("JSON Error On Retrieval!");
                    e.printStackTrace();
                }
            }
        }
        return out;
    }

    public JSONObject hdl_jobj(HashMap<String, String> items) {
        String urlReq = this.urlparse(items);
        String jsonText = this.request_from_api(urlReq);
        return this.get_data(jsonText);
    }

    public String request_from_api(String data) {
        return this.request_from_api(data, this.plugin.apiServer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String request_from_api(String data, String server) {
        String string;
        OutputStreamWriter wr = null;
        BufferedReader rd = null;
        try {
            String line;
            if (!this.config.isValidApiKey()) {
                String string2 = "";
                return string2;
            }
            if (this.config.isDebug()) {
                this.log.info("Sending API request: '" + data + "'");
            }
            URL url = new URL("http://" + server + "/v3/" + this.config.getApiKey());
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(25000);
            conn.setReadTimeout(25000);
            conn.setDoOutput(true);
            wr = new OutputStreamWriter(conn.getOutputStream());
            wr.write(data);
            wr.flush();
            StringBuilder buf = new StringBuilder();
            rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = rd.readLine()) != null) {
                buf.append(line);
            }
            if (this.plugin.getConfigs().isDebug()) {
                this.log.info("Result: " + buf.toString());
            }
            string = buf.toString();
        }
        catch (Exception e) {
            if (this.config.isDebug()) {
                this.log.severe("Error fetching data!");
                e.printStackTrace();
            }
            String string3 = "";
            return string3;
        }
        finally {
            if (wr != null) {
                try {
                    wr.close();
                }
                catch (Exception exception) {}
            }
            if (rd != null) {
                try {
                    rd.close();
                }
                catch (Exception exception) {}
            }
        }
        return string;
    }

    public String urlparse(HashMap<String, String> items) {
        String data;
        block4: {
            data = "";
            try {
                for (Map.Entry<String, String> entry : items.entrySet()) {
                    String key = entry.getKey();
                    String val = entry.getValue();
                    if (val == null || val.equals("")) continue;
                    if (data.equals("")) {
                        data = URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(val, "UTF-8");
                        continue;
                    }
                    data = data + "&" + URLEncoder.encode(key, "UTF-8") + "=" + URLEncoder.encode(val, "UTF-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                if (!this.config.isDebug()) break block4;
                e.printStackTrace();
            }
        }
        return data;
    }
}

