/*
 * Decompiled with CFR 0.152.
 */
package com.mcbans.plugin.request;

import com.mcbans.plugin.ActionLog;
import com.mcbans.plugin.MCBans;
import com.mcbans.plugin.callBacks.BaseCallback;
import com.mcbans.plugin.org.json.JSONObject;
import com.mcbans.plugin.request.JsonHandler;
import java.util.HashMap;

public abstract class BaseRequest<Callback extends BaseCallback>
implements Runnable {
    protected final MCBans plugin;
    protected final ActionLog log;
    protected HashMap<String, String> items;
    protected Callback callback;

    public BaseRequest(MCBans plugin, Callback callback) {
        this.plugin = plugin;
        this.log = plugin.getLog();
        this.callback = callback;
        this.items = new HashMap();
    }

    @Override
    public void run() {
        if (!this.checkServer()) {
            ((BaseCallback)this.callback).error("&cCould not select or detect the MCBans API server.");
            return;
        }
        this.execute();
    }

    protected abstract void execute();

    private boolean checkServer() {
        while (this.plugin.apiServer == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.plugin.apiServer != null;
    }

    protected void request() {
        JsonHandler webHandle = new JsonHandler(this.plugin);
        webHandle.mainRequest(this.items);
    }

    protected String request_String() {
        JsonHandler webHandle = new JsonHandler(this.plugin);
        String urlReq = webHandle.urlparse(this.items);
        return webHandle.request_from_api(urlReq);
    }

    protected JSONObject request_JOBJ() {
        JsonHandler webHandle = new JsonHandler(this.plugin);
        return webHandle.hdl_jobj(this.items);
    }
}

