/*
 * Decompiled with CFR 0.152.
 */
package com.mcbans.plugin.request;

import com.mcbans.plugin.ActionLog;
import com.mcbans.plugin.MCBans;
import com.mcbans.plugin.api.data.BanLookupData;
import com.mcbans.plugin.callBacks.BanLookupCallback;
import com.mcbans.plugin.org.json.JSONException;
import com.mcbans.plugin.org.json.JSONObject;
import com.mcbans.plugin.request.BaseRequest;
import org.bukkit.ChatColor;

public class BanLookupRequest
extends BaseRequest<BanLookupCallback> {
    private int banID;

    public BanLookupRequest(MCBans plugin, BanLookupCallback callback, int banID) {
        super(plugin, callback);
        this.items.put("ban", String.valueOf(banID));
        this.items.put("exec", "banLookup");
        this.banID = banID;
    }

    @Override
    protected void execute() {
        block9: {
            if (((BanLookupCallback)this.callback).getSender() != null) {
                this.log.info(((BanLookupCallback)this.callback).getSender().getName() + " has performed a ban lookup for ID " + this.banID + "!");
            }
            JSONObject result = this.request_JOBJ();
            try {
                ((BanLookupCallback)this.callback).success(new BanLookupData(this.banID, result));
            }
            catch (JSONException ex) {
                if (result.toString().contains("error")) {
                    if (result.toString().contains("dne")) {
                        ((BanLookupCallback)this.callback).error("Ban record not found: " + this.banID);
                        return;
                    }
                    if (result.toString().contains("Server Disabled")) {
                        ActionLog.getInstance().severe("This server has been disabled by MCBans staff.");
                        ActionLog.getInstance().severe("To appeal this decision, please file a ticket at forums.mcbans.com.");
                        ((BanLookupCallback)this.callback).error("This server has been disabled by MCBans staff.");
                        return;
                    }
                }
                ActionLog.getInstance().severe("A JSON error occurred while trying to localize ban lookup data.");
                ((BanLookupCallback)this.callback).error("An error occurred while parsing JSON data.");
            }
            catch (NullPointerException ex) {
                ActionLog.getInstance().severe("Unable to reach MCBans API.");
                ((BanLookupCallback)this.callback).error(ChatColor.RED + "Unable to reach MCBans API.");
                if (this.plugin.getConfigs().isDebug()) {
                    ex.printStackTrace();
                }
            }
            catch (Exception ex) {
                ((BanLookupCallback)this.callback).error("Unknown Error: " + ex.getMessage());
                if (!this.plugin.getConfigs().isDebug()) break block9;
                ex.printStackTrace();
            }
        }
    }
}

