/*
 * Decompiled with CFR 0.152.
 */
package com.mcbans.plugin.request;

import com.mcbans.plugin.ActionLog;
import com.mcbans.plugin.I18n;
import com.mcbans.plugin.MCBans;
import com.mcbans.plugin.callBacks.MessageCallback;
import com.mcbans.plugin.events.PlayerIPBanEvent;
import com.mcbans.plugin.events.PlayerIPBannedEvent;
import com.mcbans.plugin.org.json.JSONException;
import com.mcbans.plugin.org.json.JSONObject;
import com.mcbans.plugin.request.BaseRequest;
import com.mcbans.plugin.util.Util;
import java.util.Locale;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class BanIpRequest
extends BaseRequest<MessageCallback> {
    private String ip;
    private String reason;
    private String issuedBy;
    private String issuedByUUID;

    public BanIpRequest(MCBans plugin, MessageCallback callback, String ip, String reason, String issuedBy, String issuedByUUID) {
        super(plugin, callback);
        this.items.put("exec", "ipBan");
        this.items.put("ip", ip);
        this.items.put("reason", reason);
        this.items.put("admin", issuedBy);
        this.items.put("admin_uuid", issuedByUUID);
        this.ip = ip;
        this.reason = reason;
        this.issuedBy = issuedBy;
        this.issuedByUUID = issuedByUUID;
    }

    @Override
    protected void execute() {
        PlayerIPBanEvent ipBanEvent = new PlayerIPBanEvent(this.ip, this.issuedBy, this.issuedByUUID, this.reason);
        this.plugin.getServer().getPluginManager().callEvent((Event)ipBanEvent);
        if (ipBanEvent.isCancelled()) {
            return;
        }
        this.issuedBy = ipBanEvent.getSenderName();
        this.reason = ipBanEvent.getReason();
        if (Util.isValidIP(this.ip)) {
            Bukkit.getServer().banIP(this.ip);
        }
        new Thread(() -> {
            block13: {
                JSONObject response = this.request_JOBJ();
                try {
                    if (response != null && response.has("result")) {
                        String result = response.getString("result").trim().toLowerCase(Locale.ENGLISH);
                        if (result.equals("y")) {
                            ((MessageCallback)this.callback).setBroadcastMessage(ChatColor.GREEN + I18n.localize("ipBanSuccess", "%IP%", this.ip, "%ADMIN%", this.issuedBy, "%REASON%", this.reason));
                            ((MessageCallback)this.callback).success();
                            this.kickPlayerByIP(this.ip, this.reason);
                            this.log.info("IP " + this.ip + " has been banned [" + this.reason + "] [" + this.issuedBy + "]!");
                            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getServer().getPluginManager().callEvent((Event)new PlayerIPBannedEvent(this.ip, this.issuedBy, this.issuedByUUID, this.reason)), 0L);
                        } else if (result.equals("a")) {
                            ((MessageCallback)this.callback).error(ChatColor.RED + I18n.localize("ipBanAlready", "%IP%", this.ip, "%ADMIN%", this.issuedBy, "%REASON%", this.reason));
                            this.log.info(this.issuedBy + " tried to IPBan " + this.ip + "!");
                        } else if (result.equals("n")) {
                            ((MessageCallback)this.callback).error(ChatColor.RED + I18n.localize("invalidIP", new Object[0]));
                            this.log.info(this.issuedBy + " tried to IPBan " + this.ip + "!");
                        } else if (result.equals("e")) {
                            ((MessageCallback)this.callback).error(ChatColor.RED + I18n.localize("invalidIP", new Object[0]));
                            this.log.info(this.issuedBy + " tried to IPBan " + this.ip + "!");
                        } else {
                            this.log.severe("Invalid response result: " + result);
                        }
                    } else {
                        ((MessageCallback)this.callback).error(ChatColor.RED + "MCBans API appears to be down or unreachable!");
                    }
                }
                catch (JSONException ex) {
                    if (response.toString().contains("error") && response.toString().contains("Server Disabled")) {
                        ActionLog.getInstance().severe("This server has been disabled by MCBans staff.");
                        ActionLog.getInstance().severe("To appeal this decision, please file a ticket at forums.mcbans.com.");
                        ((MessageCallback)this.callback).error("This server has been disabled by MCBans staff.");
                        return;
                    }
                    ActionLog.getInstance().severe("A JSON error occurred while trying to localize lookup data.");
                    ((MessageCallback)this.callback).error("An error occurred while parsing JSON data.");
                    if (!this.plugin.getConfigs().isDebug()) break block13;
                    ex.printStackTrace();
                }
            }
        }).start();
    }

    private void kickPlayerByIP(String ip, String kickReason) {
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!ip.equals(p.getAddress().getAddress().getHostAddress())) continue;
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> p.kickPlayer(kickReason), 0L);
        }
    }
}

