/*
 * Decompiled with CFR 0.152.
 */
package com.mcbans.plugin.request;

import com.mcbans.plugin.ActionLog;
import com.mcbans.plugin.I18n;
import com.mcbans.plugin.MCBans;
import com.mcbans.plugin.bukkitListeners.PlayerListener;
import com.mcbans.plugin.events.PlayerBanEvent;
import com.mcbans.plugin.events.PlayerGlobalBanEvent;
import com.mcbans.plugin.events.PlayerLocalBanEvent;
import com.mcbans.plugin.events.PlayerTempBanEvent;
import com.mcbans.plugin.events.PlayerUnbanEvent;
import com.mcbans.plugin.events.PlayerUnbannedEvent;
import com.mcbans.plugin.org.json.JSONException;
import com.mcbans.plugin.org.json.JSONObject;
import com.mcbans.plugin.permission.Perms;
import com.mcbans.plugin.request.JsonHandler;
import com.mcbans.plugin.util.Util;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class Ban {
    private final MCBans plugin;
    private final ActionLog log;
    private String playerName;
    private String playerIP;
    private String senderName;
    private String reason;
    private String action;
    private String duration;
    private String measure;
    private String badword;
    private String playerUUID;
    private String senderUUID = null;
    private boolean rollback = false;
    private JSONObject actionData = null;
    private HashMap<String, Integer> responses = new HashMap();
    private int action_id;

    public Ban(MCBans plugin, String action, String playerName, String playerUUID, String playerIP, String senderName, String senderUUID, String reason, String duration, String measure, JSONObject actionData, boolean rollback) {
        this(plugin, action, playerName, playerIP, senderName, reason, duration, measure, actionData, rollback);
        this.playerUUID = playerUUID;
        this.senderUUID = senderUUID;
    }

    public Ban(MCBans plugin, String action, String playerName, String playerIP, String senderName, String reason, String duration, String measure, JSONObject actionData, boolean rollback) {
        this.plugin = plugin;
        this.log = plugin.getLog();
        this.playerName = playerName;
        this.playerIP = playerIP;
        this.senderName = senderName;
        this.reason = reason;
        this.rollback = rollback;
        this.duration = duration;
        this.measure = measure;
        this.action = action;
        this.actionData = actionData != null ? actionData : new JSONObject();
        String res = (String)PlayerListener.cache.getIfPresent((Object)playerName.toLowerCase());
        if (res != null) {
            PlayerListener.cache.invalidate((Object)playerName.toLowerCase());
        }
        this.responses.put("globalBan", 0);
        this.responses.put("localBan", 1);
        this.responses.put("tempBan", 2);
        this.responses.put("unBan", 3);
    }

    public Ban(MCBans plugin, String action, String playerName, String playerIP, String senderName, String reason, String duration, String measure) {
        this(plugin, action, playerName, playerIP, senderName, reason, duration, measure, null, false);
    }

    public void kickPlayer(String playerName, String playerUUID, String kickReason) {
        Player targettmp = null;
        targettmp = !playerUUID.equals("") ? MCBans.getPlayer((Plugin)this.plugin, playerUUID) : this.plugin.getServer().getPlayerExact(playerName);
        Player target = targettmp;
        if (target != null) {
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> target.kickPlayer(kickReason), 1L);
        }
    }

    public void run() {
        try {
            while (this.plugin.apiServer == null) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.responses.containsKey(this.action)) {
                this.action_id = this.responses.get(this.action);
                if (this.action_id != 3) {
                    PlayerBanEvent banEvent = new PlayerBanEvent(this.playerName, this.playerUUID, this.playerIP, this.senderName, this.senderUUID, this.reason, this.action_id, this.duration, this.measure);
                    this.plugin.getServer().getPluginManager().callEvent((Event)banEvent);
                    if (banEvent.isCancelled()) {
                        return;
                    }
                    this.senderName = banEvent.getSenderName();
                    this.reason = banEvent.getReason();
                    this.action_id = banEvent.getActionID();
                    this.duration = banEvent.getDuration();
                    this.measure = banEvent.getMeasure();
                }
                Player targettmp = null;
                targettmp = !this.playerUUID.equals("") ? MCBans.getPlayer((Plugin)this.plugin, this.playerUUID) : this.plugin.getServer().getPlayerExact(this.playerName);
                if (targettmp != null && this.action_id != 3) {
                    if (Perms.EXEMPT_BAN.has((Permissible)targettmp)) {
                        Util.message(this.senderName, ChatColor.RED + I18n.localize("banExemptPlayer", "%PLAYER%", targettmp.getName()));
                        return;
                    }
                } else if (this.playerName != null && this.action_id != 3 && Perms.EXEMPT_BAN.has(this.playerName)) {
                    Util.message(this.senderName, ChatColor.RED + I18n.localize("banExemptPlayer", "%PLAYER%", this.playerName));
                    return;
                }
                switch (this.action_id) {
                    case 0: {
                        this.globalBan();
                        break;
                    }
                    case 1: {
                        this.localBan();
                        break;
                    }
                    case 2: {
                        this.tempBan();
                        break;
                    }
                    case 3: {
                        this.unBan();
                    }
                }
            } else {
                this.err();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.err();
        }
    }

    public void unBan() {
        PlayerUnbanEvent unBanEvent = new PlayerUnbanEvent(this.playerName, this.playerUUID, this.senderName, this.senderUUID);
        this.plugin.getServer().getPluginManager().callEvent((Event)unBanEvent);
        if (unBanEvent.isCancelled()) {
            return;
        }
        this.senderName = unBanEvent.getSenderName();
        if (!Util.isValidIP(this.playerName)) {
            this.bukkitBan(false);
        } else {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> Bukkit.getServer().unbanIP(this.playerName), 1L);
        }
        JsonHandler webHandle = new JsonHandler(this.plugin);
        HashMap<String, String> url_items = new HashMap<String, String>();
        url_items.put("player", this.playerName);
        url_items.put("player_uuid", this.playerUUID);
        url_items.put("admin", this.senderName);
        url_items.put("admin_uuid", this.senderUUID);
        url_items.put("exec", "unBan");
        new Thread(() -> {
            HashMap<String, String> response = webHandle.mainRequest(url_items);
            if (response.containsKey("error")) {
                Util.message(this.senderName, ChatColor.RED + "Error: " + response.get("error"));
                return;
            }
            if (!response.containsKey("result")) {
                Util.message(this.senderName, ChatColor.RED + I18n.localize("unBanError", "%PLAYER%", this.playerName, "%ADMIN%", this.senderName));
                return;
            }
            if (response.get("result").equals("y")) {
                if (response.containsKey("player")) {
                    this.playerName = response.get("player");
                }
                if (!Util.isValidIP(this.playerName)) {
                    // empty if block
                }
                Util.broadcastMessage(ChatColor.GREEN + I18n.localize("unBanSuccess", "%PLAYER%", this.playerName, "%ADMIN%", this.senderName));
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.plugin.getServer().getPluginManager().callEvent((Event)new PlayerUnbannedEvent(this.playerName, this.playerUUID, this.senderName, this.senderUUID)), 1L);
                this.log.info(this.senderName + " unbanned " + this.playerName + "!");
                return;
            }
            if (response.get("result").equals("e")) {
                Util.message(this.senderName, ChatColor.RED + I18n.localize("unBanError", "%PLAYER%", this.playerName, "%ADMIN%", this.senderName));
            } else if (response.get("result").equals("s")) {
                Util.message(this.senderName, ChatColor.RED + I18n.localize("unBanGroup", "%PLAYER%", this.playerName, "%ADMIN%", this.senderName));
            } else if (response.get("result").equals("n")) {
                Util.message(this.senderName, ChatColor.RED + I18n.localize("unBanNot", "%PLAYER%", this.playerName, "%ADMIN%", this.senderName));
            }
            this.log.info(this.senderName + " tried to unban " + this.playerName + "!");
        }).start();
    }

    public void localBan() {
        PlayerLocalBanEvent lBanEvent = new PlayerLocalBanEvent(this.playerName, this.playerUUID, this.playerIP, this.senderName, this.senderUUID, this.reason);
        this.plugin.getServer().getPluginManager().callEvent((Event)lBanEvent);
        if (lBanEvent.isCancelled()) {
            return;
        }
        this.senderName = lBanEvent.getSenderName();
        this.reason = lBanEvent.getReason();
        this.bukkitBan(true);
        new Thread(() -> {
            JsonHandler webHandle = new JsonHandler(this.plugin);
            HashMap<String, String> url_items = new HashMap<String, String>();
            url_items.put("player", this.playerName);
            url_items.put("player_uuid", this.playerUUID);
            url_items.put("playerip", this.playerIP);
            url_items.put("reason", this.reason);
            url_items.put("admin", this.senderName);
            url_items.put("admin_uuid", this.senderUUID);
            if (this.rollback) {
                this.plugin.getRbHandler().rollback(this.senderName, this.playerName);
            }
            if (this.actionData != null) {
                url_items.put("actionData", this.actionData.toString());
            }
            url_items.put("exec", "localBan");
            HashMap<String, String> response = webHandle.mainRequest(url_items);
            try {
                if (response.containsKey("error")) {
                    Util.message(this.senderName, ChatColor.RED + "Error: " + response.get("error"));
                    return;
                }
                if (response.containsKey("player")) {
                    this.playerName = response.get("player");
                }
                if (!response.containsKey("result")) {
                    Util.message(this.senderName, ChatColor.RED + " MCBans API is down or unreachable. We added a default ban for you. To unban, use /pardon.");
                    return;
                }
                if (response.get("result").equals("y")) {
                    this.kickPlayer(this.playerName, this.playerUUID, I18n.localize("localBanPlayer", "%PLAYER%", this.playerName, "%ADMIN%", this.senderName, "%REASON%", this.reason, "%IP%", this.playerIP));
                    Util.broadcastMessage(ChatColor.GREEN + I18n.localize("localBanSuccess", "%PLAYER%", this.playerName, "%ADMIN%", this.senderName, "%REASON%", this.reason, "%IP%", this.playerIP));
                    Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.plugin.getServer().getPluginManager().callEvent((Event)new PlayerBanEvent(this.playerName, this.playerUUID, this.playerIP, this.senderName, this.senderUUID, this.reason, this.action_id, this.duration, this.measure)), 1L);
                    this.log.info(this.playerName + " has been banned with a local type ban [" + this.reason + "] [" + this.senderName + "]!");
                    return;
                }
                if (response.get("result").equals("e")) {
                    Util.message(this.senderName, ChatColor.RED + I18n.localize("localBanError", "%PLAYER%", this.playerName, "%ADMIN%", this.senderName, "%REASON%", this.reason, "%IP%", this.playerIP));
                } else if (response.get("result").equals("s")) {
                    Util.message(this.senderName, ChatColor.RED + I18n.localize("localBanGroup", "%PLAYER%", this.playerName, "%ADMIN%", this.senderName, "%REASON%", this.reason, "%IP%", this.playerIP));
                } else if (response.get("result").equals("a")) {
                    Util.message(this.senderName, ChatColor.RED + I18n.localize("localBanAlready", "%PLAYER%", this.playerName, "%ADMIN%", this.senderName, "%REASON%", this.reason, "%IP%", this.playerIP));
                }
                this.log.info(this.senderName + " tried to ban " + this.playerName + " with a local type ban [" + this.reason + "]!");
            }
            catch (Exception ex) {
                Util.message(this.senderName, ChatColor.RED + " MCBans API is down or unreachable. We added a default ban for you. To unban, use /pardon.");
                this.log.warning("Error occurred with local banning. Please report this to an MCBans developer.");
                ex.printStackTrace();
            }
        }).start();
    }

    public void globalBan() {
        PlayerGlobalBanEvent gBanEvent = new PlayerGlobalBanEvent(this.playerName, this.playerUUID, this.playerIP, this.senderName, this.senderUUID, this.reason);
        this.plugin.getServer().getPluginManager().callEvent((Event)gBanEvent);
        if (gBanEvent.isCancelled()) {
            return;
        }
        this.senderName = gBanEvent.getSenderName();
        this.reason = gBanEvent.getReason();
        this.bukkitBan(true);
        new Thread(() -> {
            JsonHandler webHandle = new JsonHandler(this.plugin);
            HashMap<String, String> url_items = new HashMap<String, String>();
            url_items.put("player", this.playerName);
            url_items.put("player_uuid", this.playerUUID);
            url_items.put("playerip", this.playerIP);
            url_items.put("reason", this.reason);
            url_items.put("admin", this.senderName);
            url_items.put("admin_uuid", this.senderUUID);
            if (this.rollback) {
                this.plugin.getRbHandler().rollback(this.senderName, this.playerName);
            }
            if (this.actionData.length() > 0) {
                url_items.put("actionData", this.actionData.toString());
            }
            url_items.put("exec", "globalBan");
            HashMap<String, String> response = webHandle.mainRequest(url_items);
            try {
                if (response.containsKey("error")) {
                    Util.message(this.senderName, ChatColor.RED + "Error: " + response.get("error"));
                    return;
                }
                if (response.containsKey("player")) {
                    this.playerName = response.get("player");
                }
                if (!response.containsKey("result")) {
                    Util.message(this.senderName, ChatColor.RED + " MCBans API is down or unreachable. We added a default ban for you. To unban, use /pardon.");
                    return;
                }
                if (response.get("result").equals("y")) {
                    this.kickPlayer(this.playerName, this.playerUUID, I18n.localize("globalBanPlayer", "%PLAYER%", this.playerName, "%ADMIN%", this.senderName, "%REASON%", this.reason, "%IP%", this.playerIP));
                    Util.broadcastMessage(ChatColor.GREEN + I18n.localize("globalBanSuccess", "%PLAYER%", this.playerName, "%ADMIN%", this.senderName, "%REASON%", this.reason, "%IP%", this.playerIP));
                    Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.plugin.getServer().getPluginManager().callEvent((Event)new PlayerBanEvent(this.playerName, this.playerUUID, this.playerIP, this.senderName, this.senderUUID, this.reason, this.action_id, this.duration, this.measure)), 1L);
                    this.log.info(this.playerName + " has been banned with a global type ban [" + this.reason + "] [" + this.senderName + "]!");
                    return;
                }
                if (response.get("result").equals("e")) {
                    Util.message(this.senderName, ChatColor.RED + I18n.localize("globalBanError", "%PLAYER%", this.playerName, "%ADMIN%", this.senderName, "%REASON%", this.reason, "%IP%", this.playerIP));
                } else if (response.get("result").equals("w")) {
                    this.badword = response.get("word");
                    Util.message(this.senderName, ChatColor.RED + I18n.localize("globalBanWarning", "%PLAYER%", this.playerName, "%ADMIN%", this.senderName, "%REASON%", this.reason, "%IP%", this.playerIP, "%BADWORD%", this.badword));
                } else if (response.get("result").equals("s")) {
                    Util.message(this.senderName, ChatColor.RED + I18n.localize("globalBanGroup", "%PLAYER%", this.playerName, "%ADMIN%", this.senderName, "%REASON%", this.reason, "%IP%", this.playerIP));
                } else if (response.get("result").equals("a")) {
                    Util.message(this.senderName, ChatColor.RED + I18n.localize("globalBanAlready", "%PLAYER%", this.playerName, "%ADMIN%", this.senderName, "%REASON%", this.reason, "%IP%", this.playerIP));
                }
                this.log.info(this.senderName + " tried to ban " + this.playerName + " with a global type ban [" + this.reason + "]!");
            }
            catch (Exception ex) {
                Util.message(this.senderName, ChatColor.RED + " MCBans API is down or unreachable. We added a default ban for you. To unban, use /pardon.");
                this.log.warning("Error occurred with global banning. Please report this to an MCBans developer.");
                ex.printStackTrace();
            }
        }).start();
    }

    public void tempBan() {
        PlayerTempBanEvent tBanEvent = new PlayerTempBanEvent(this.playerName, this.playerUUID, this.playerIP, this.senderName, this.senderUUID, this.reason, this.duration, this.measure);
        this.plugin.getServer().getPluginManager().callEvent((Event)tBanEvent);
        if (tBanEvent.isCancelled()) {
            return;
        }
        this.senderName = tBanEvent.getSenderName();
        this.reason = tBanEvent.getReason();
        this.duration = tBanEvent.getDuration();
        this.measure = tBanEvent.getMeasure();
        new Thread(() -> {
            JsonHandler webHandle = new JsonHandler(this.plugin);
            HashMap<String, String> url_items = new HashMap<String, String>();
            url_items.put("player", this.playerName);
            url_items.put("player_uuid", this.playerUUID);
            url_items.put("playerip", this.playerIP);
            url_items.put("reason", this.reason);
            url_items.put("admin", this.senderName);
            url_items.put("admin_uuid", this.senderUUID);
            url_items.put("duration", this.duration);
            url_items.put("measure", this.measure);
            if (this.actionData != null) {
                url_items.put("actionData", this.actionData.toString());
            }
            url_items.put("exec", "tempBan");
            HashMap<String, String> response = webHandle.mainRequest(url_items);
            try {
                if (response.containsKey("error")) {
                    Util.message(this.senderName, ChatColor.RED + "Error: " + response.get("error"));
                    return;
                }
                if (response.containsKey("player")) {
                    this.playerName = response.get("player");
                }
                if (!response.containsKey("result")) {
                    Util.message(this.senderName, ChatColor.RED + " MCBans API is down or unreachable. We added a default ban for you. To unban, use /pardon.");
                    return;
                }
                if (response.get("result").equals("y")) {
                    this.kickPlayer(this.playerName, this.playerUUID, I18n.localize("tempBanPlayer", "%PLAYER%", this.playerName, "%ADMIN%", this.senderName, "%REASON%", this.reason, "%IP%", this.playerIP));
                    Util.broadcastMessage(ChatColor.GREEN + I18n.localize("tempBanSuccess", "%PLAYER%", this.playerName, "%ADMIN%", this.senderName, "%REASON%", this.reason, "%IP%", this.playerIP));
                    Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.plugin.getServer().getPluginManager().callEvent((Event)new PlayerBanEvent(this.playerName, this.playerUUID, this.playerIP, this.senderName, this.senderUUID, this.reason, this.action_id, this.duration, this.measure)), 1L);
                    this.log.info(this.playerName + " has been banned with a temp type ban [" + this.reason + "] [" + this.senderName + "]!");
                    return;
                }
                if (response.get("result").equals("e")) {
                    Util.message(this.senderName, ChatColor.RED + I18n.localize("tempBanError", "%PLAYER%", this.playerName, "%ADMIN%", this.senderName, "%REASON%", this.reason, "%IP%", this.playerIP));
                } else if (response.get("result").equals("s")) {
                    Util.message(this.senderName, ChatColor.RED + I18n.localize("tempBanGroup", "%PLAYER%", this.playerName, "%ADMIN%", this.senderName, "%REASON%", this.reason, "%IP%", this.playerIP));
                } else if (response.get("result").equals("a")) {
                    Util.message(this.senderName, ChatColor.RED + I18n.localize("tempBanAlready", "%PLAYER%", this.playerName, "%ADMIN%", this.senderName, "%REASON%", this.reason, "%IP%", this.playerIP));
                } else if (response.get("result").equals("n")) {
                    if (response.get("msg") != null) {
                        Util.message(this.senderName, ChatColor.RED + response.get("msg"));
                    } else {
                        Util.message(this.senderName, ChatColor.RED + I18n.localize("tempBanError", "%PLAYER%", this.playerName, "%ADMIN%", this.senderName, "%REASON%", this.reason, "%IP%", this.playerIP));
                    }
                }
                this.log.info(this.senderName + " tried to ban " + this.playerName + " with a temp type ban [" + this.reason + "]!");
            }
            catch (Exception ex) {
                this.log.warning("Error occurred with temporary banning. Please report this to an MCBans developer.");
                ex.printStackTrace();
            }
        }).start();
    }

    private void bukkitBan(boolean flag) {
        Player target = this.plugin.getServer().getPlayer(this.playerName);
        if (target == null) {
            return;
        }
        if (flag) {
            if (!this.plugin.getServer().getBanList(BanList.Type.NAME).isBanned(target.getName())) {
                this.plugin.getServer().getBanList(BanList.Type.NAME).addBan(target.getName(), this.reason, new Date(), this.senderName);
                this.kickPlayer(this.playerName, this.playerUUID, I18n.localize("localBanPlayer", "%PLAYER%", this.playerName, "%ADMIN%", this.senderName, "%REASON%", this.reason, "%IP%", this.playerIP));
            }
        } else if (this.plugin.getServer().getBanList(BanList.Type.NAME).isBanned(target.getName())) {
            this.plugin.getServer().getBanList(BanList.Type.NAME).pardon(target.getName());
        }
    }

    private Map<String, JSONObject> getProof() throws JSONException {
        Player p;
        HashMap<String, JSONObject> ret = new HashMap<String, JSONObject>();
        Pattern regex = Pattern.compile("(fly|hack|nodus|glitch|exploit|NC|cheat|nuker|x-ray|xray)");
        boolean foundMatch = regex.matcher(this.reason).find();
        if (foundMatch && (p = this.plugin.getServer().getPlayerExact(this.playerName)) != null) {
            this.playerName = p.getName();
        }
        return ret;
    }

    private void err() {
        this.log.warning("\nError: MCBans caught an invalid action. Perhaps another plugin is using MCBans improperly?\n");
    }
}

