/*
 * Decompiled with CFR 0.152.
 */
package com.mcbans.plugin.request;

import com.mcbans.plugin.ActionLog;
import com.mcbans.plugin.MCBans;
import com.mcbans.plugin.api.data.AltLookupData;
import com.mcbans.plugin.callBacks.AltLookupCallback;
import com.mcbans.plugin.org.json.JSONException;
import com.mcbans.plugin.org.json.JSONObject;
import com.mcbans.plugin.request.BaseRequest;
import java.util.UUID;
import org.bukkit.ChatColor;

public class AltLookupRequest
extends BaseRequest<AltLookupCallback> {
    private String playerName;
    private UUID playerUUID;

    public AltLookupRequest(MCBans plugin, AltLookupCallback callback, UUID playerUUID, String playerName) {
        super(plugin, callback);
        this.items.put("player_uuid", playerUUID.toString());
        this.items.put("player", playerName);
        this.items.put("exec", "altList");
        this.playerUUID = playerUUID;
        this.playerName = playerName;
    }

    public AltLookupRequest(MCBans plugin, AltLookupCallback callback, String playerName) {
        super(plugin, callback);
        this.items.put("player", playerName);
        this.items.put("exec", "altList");
        this.playerName = playerName;
    }

    @Override
    protected void execute() {
        block10: {
            if (((AltLookupCallback)this.callback).getSender() != null) {
                this.log.info(((AltLookupCallback)this.callback).getSender().getName() + " has looked up " + this.playerName + "'s alternate accounts.");
            }
            JSONObject result = this.request_JOBJ();
            try {
                if (result != null && result.has("result") && result.getString("result").trim().equals("n")) {
                    ((AltLookupCallback)this.callback).error("This server is not premium.");
                } else {
                    ((AltLookupCallback)this.callback).success(new AltLookupData(this.playerName, result));
                }
            }
            catch (JSONException ex) {
                if (result.toString().contains("error") && result.toString().contains("Server Disabled")) {
                    ActionLog.getInstance().severe("This server has been disabled by MCBans staff.");
                    ActionLog.getInstance().severe("To appeal this decision, please file a ticket at forums.mcbans.com.");
                    ((AltLookupCallback)this.callback).error("This server has been disabled by MCBans staff.");
                    return;
                }
                ActionLog.getInstance().severe("A JSON error occurred while trying to localize alternate account data.");
                ((AltLookupCallback)this.callback).error("An error occurred while parsing JSON data.");
                if (this.plugin.getConfigs().isDebug()) {
                    ex.printStackTrace();
                }
            }
            catch (NullPointerException ex) {
                ActionLog.getInstance().severe("Unable to reach MCBans server.");
                ((AltLookupCallback)this.callback).error(ChatColor.RED + "Unable to reach MCBans server.");
                if (this.plugin.getConfigs().isDebug()) {
                    ex.printStackTrace();
                }
            }
            catch (Exception ex) {
                ((AltLookupCallback)this.callback).error("Unknown Error: " + ex.getMessage());
                if (!this.plugin.getConfigs().isDebug()) break block10;
                ex.printStackTrace();
            }
        }
    }
}

