/*
 * Decompiled with CFR 0.152.
 */
package com.mcbans.plugin.permission;

import com.mcbans.plugin.MCBans;
import com.mcbans.plugin.permission.PermissionHandler;
import com.mcbans.plugin.util.Util;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public enum Perms {
    ADMIN("admin"),
    BAN_GLOBAL("ban.global"),
    BAN_LOCAL("ban.local"),
    BAN_TEMP("ban.temp"),
    BAN_ROLLBACK("ban.rollback"),
    BAN_IP("ban.ip"),
    UNBAN("unban"),
    KICK("kick"),
    VIEW_ALTS("view.alts"),
    VIEW_BANS("view.bans"),
    VIEW_STAFF("view.staff"),
    VIEW_PREVIOUS("view.previous"),
    VIEW_PROXY("view.proxy"),
    ANNOUNCE("announce"),
    HIDE_VIEW("hideview"),
    EXEMPT_KICK("kick.exempt"),
    EXEMPT_BAN("ban.exempt"),
    EXEMPT_MAXALTS("maxalts.exempt"),
    LOOKUP_PLAYER("lookup.player"),
    LOOKUP_BAN("lookup.ban"),
    LOOKUP_ALT("lookup.alt");

    static final String HEADER = "mcbans.";
    private String node;
    private static PermissionHandler handler;

    private Perms(String node) {
        this.node = HEADER + node;
    }

    public boolean has(Permissible perm) {
        if (perm == null) {
            return false;
        }
        return handler.has(perm, this.node);
    }

    public boolean has(String playerName) {
        if (playerName == null) {
            return false;
        }
        return this.has((Permissible)MCBans.getInstance().getServer().getPlayer(playerName));
    }

    public static boolean has(Permissible perm, String node) {
        if (perm == null || node == null) {
            return false;
        }
        return handler.has(perm, HEADER + node);
    }

    public void message(String message) {
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            if (!this.has((Permissible)player)) continue;
            Util.message((CommandSender)player, message);
        }
    }

    public String getNode() {
        return this.node;
    }

    public Set<Player> getPlayers() {
        HashSet<Player> players = new HashSet<Player>();
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            if (!this.has((Permissible)player)) continue;
            players.add(player);
        }
        return players;
    }

    public Set<String> getPlayerNames() {
        HashSet<String> names = new HashSet<String>();
        for (Player player : this.getPlayers()) {
            names.add(player.getName());
        }
        return names;
    }

    public static void setupPermissionHandler() {
        if (handler == null) {
            handler = PermissionHandler.getInstance();
        }
        handler.setupPermissions();
    }

    static {
        handler = null;
    }
}

