/*
 * Decompiled with CFR 0.152.
 */
package com.mcbans.plugin.permission;

import com.mcbans.plugin.ActionLog;
import com.mcbans.plugin.MCBans;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import ru.tehkode.permissions.PermissionUser;
import ru.tehkode.permissions.bukkit.PermissionsEx;

public class PermissionHandler {
    private static PermissionHandler instance;
    private final MCBans plugin;
    private final ActionLog log;
    private PermType permType = null;
    private Permission vaultPermission = null;
    private PermissionsEx pex = null;

    private PermissionHandler(MCBans plugin) {
        this.plugin = plugin;
        this.log = plugin.getLog();
        instance = this;
    }

    public void setupPermissions(boolean silent) {
        String selected = this.plugin.getConfigs().getPermission().trim();
        boolean found = true;
        if ("vault".equalsIgnoreCase(selected)) {
            if (this.setupVaultPermission()) {
                this.permType = PermType.VAULT;
            } else {
                this.log.warning("Selected Vault for permission control, but MCBans did not find this plugin!");
            }
        } else if ("pex".equalsIgnoreCase(selected) || "permissionsex".equalsIgnoreCase(selected)) {
            if (this.setupPEXPermission()) {
                this.permType = PermType.PEX;
            } else {
                this.log.warning("Selected PermissionsEx for permission control, but MCBans did not find this plugin!");
            }
        } else if ("superperms".equalsIgnoreCase(selected)) {
            this.permType = PermType.SUPERPERMS;
        } else if ("ops".equalsIgnoreCase(selected)) {
            this.permType = PermType.OPS;
        } else {
            found = false;
        }
        if (this.permType == null) {
            this.permType = PermType.SUPERPERMS;
            if (!found) {
                this.log.warning("Valid permissions name not selected!");
            }
        }
        if (!silent) {
            this.log.info("Using " + this.getPermTypeString() + " for permission control.");
        }
    }

    public void setupPermissions() {
        this.setupPermissions(false);
    }

    public boolean has(Permissible permissible, String permission) {
        if (!(permissible instanceof Player)) {
            return true;
        }
        Player player = (Player)permissible;
        switch (this.permType) {
            case VAULT: {
                return this.vaultPermission.has(player, permission);
            }
            case PEX: {
                return this.pex.has(player, permission);
            }
            case SUPERPERMS: {
                return player.hasPermission(permission);
            }
            case OPS: {
                return player.isOp();
            }
        }
        this.log.warning("Plugin author forgot to add integration for this permission plugin. Please report this!");
        return false;
    }

    public boolean has(String playerName, String permission, String worldName) {
        switch (this.permType) {
            case VAULT: {
                return this.vaultPermission.has(worldName, playerName, permission);
            }
            case PEX: {
                PermissionUser user = PermissionsEx.getPermissionManager().getUser(playerName);
                if (user == null) {
                    return false;
                }
                return user.has(permission, worldName);
            }
            case SUPERPERMS: {
                Player player = this.plugin.getServer().getPlayer(playerName);
                if (player == null) {
                    return false;
                }
                return player.hasPermission(permission);
            }
            case OPS: {
                Player player = this.plugin.getServer().getPlayer(playerName);
                if (player == null) {
                    return false;
                }
                return player.isOp();
            }
        }
        this.log.warning("Plugin author forgot to add integration for this permission plugin. Please report this!");
        return false;
    }

    public String getPermTypeString() {
        switch (this.permType) {
            case VAULT: {
                return "Vault: " + ((Permission)Bukkit.getServer().getServicesManager().getRegistration(Permission.class).getProvider()).getName();
            }
            case PEX: {
                return "PermissionsEx";
            }
            case OPS: {
                return "OPs";
            }
            case SUPERPERMS: {
                return "SuperPerms";
            }
        }
        return "Unknown! Please report this!";
    }

    private boolean setupVaultPermission() {
        Plugin vault = this.plugin.getServer().getPluginManager().getPlugin("Vault");
        if (vault == null) {
            vault = this.plugin.getServer().getPluginManager().getPlugin("vault");
        }
        if (vault == null) {
            return false;
        }
        try {
            RegisteredServiceProvider permissionProvider = this.plugin.getServer().getServicesManager().getRegistration(Permission.class);
            if (permissionProvider != null) {
                this.vaultPermission = (Permission)permissionProvider.getProvider();
            }
        }
        catch (Exception ex) {
            this.log.warning("Unexpected error trying to setup Vault permissions!");
            ex.printStackTrace();
        }
        return this.vaultPermission != null;
    }

    private boolean setupPEXPermission() {
        Plugin testPex = this.plugin.getServer().getPluginManager().getPlugin("PermissionsEx");
        if (testPex == null) {
            testPex = this.plugin.getServer().getPluginManager().getPlugin("permissionsex");
        }
        if (testPex == null) {
            return false;
        }
        try {
            this.pex = (PermissionsEx)testPex;
        }
        catch (Exception ex) {
            this.log.warning("Unexpected error trying to setup PEX permissions!");
            ex.printStackTrace();
        }
        return this.pex != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PermissionHandler getInstance() {
        if (instance != null) return instance;
        Class<PermissionHandler> clazz = PermissionHandler.class;
        synchronized (PermissionHandler.class) {
            if (instance != null) return instance;
            instance = new PermissionHandler(MCBans.getInstance());
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static enum PermType {
        VAULT,
        PEX,
        SUPERPERMS,
        OPS;

    }
}

