/*
 * Decompiled with CFR 0.152.
 */
package com.mcbans.plugin.commands;

import com.mcbans.plugin.MCBans;
import com.mcbans.plugin.commands.BaseCommand;
import com.mcbans.plugin.commands.CommandMcbans;
import com.mcbans.plugin.util.Util;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;

public class MCBansCommandHandler
implements TabExecutor {
    private final MCBans plugin;
    private Map<String, BaseCommand> commands = new HashMap<String, BaseCommand>();

    public MCBansCommandHandler(MCBans plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String commandLabel, String[] args) {
        String commandName = command.getName().toLowerCase(Locale.ENGLISH);
        BaseCommand cmd = this.commands.get(commandName);
        if (cmd == null) {
            Util.message(sender, ChatColor.RED + "This command has not been loaded properly.");
            return true;
        }
        if (!(cmd instanceof CommandMcbans) && !this.plugin.getConfigs().isValidApiKey()) {
            Util.message(sender, ChatColor.RED + "Missing or Invalid API key! Check API key or contact MCBans staff.");
            return true;
        }
        cmd.run(this.plugin, sender, commandLabel, args);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String commandLabel, String[] args) {
        String commandName = command.getName().toLowerCase(Locale.ENGLISH);
        BaseCommand cmd = this.commands.get(commandName);
        if (cmd == null) {
            return null;
        }
        if (sender != null && !cmd.permission(sender)) {
            return null;
        }
        return cmd.tabComplete(this.plugin, sender, commandLabel, args);
    }

    public void registerCommand(BaseCommand bc) {
        if (bc.name != null) {
            this.commands.put(bc.name, bc);
        } else {
            this.plugin.getLog().warning("Invalid command! " + bc.getClass().getName());
        }
    }
}

